/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util.storage;

import com.extendedae_plus.util.storage.InfinityDataStorage;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class InfinityStorageManager
extends SavedData {
    private static final SavedData.Factory<InfinityStorageManager> FACTORY = new SavedData.Factory(InfinityStorageManager::new, InfinityStorageManager::readNbt);
    private final Map<UUID, InfinityDataStorage> cells;
    @Nullable
    private WeakReference<HolderLookup.Provider> registries;

    public InfinityStorageManager() {
        this.cells = new HashMap<UUID, InfinityDataStorage>();
        this.setDirty();
    }

    private InfinityStorageManager(Map<UUID, InfinityDataStorage> cells) {
        this.cells = cells;
        this.setDirty();
    }

    public static InfinityStorageManager readNbt(CompoundTag nbt, HolderLookup.Provider registries) {
        int version = nbt.contains("infinity_format_version") ? nbt.getInt("infinity_format_version") : 1;
        HashMap<UUID, InfinityDataStorage> cells = new HashMap<UUID, InfinityDataStorage>();
        ListTag cellList = nbt.getList("infinity_cell_list", 10);
        for (int i = 0; i < cellList.size(); ++i) {
            CompoundTag cell = cellList.getCompound(i);
            cells.put(cell.getUUID("infinity_cell_uuid"), InfinityDataStorage.loadFromNBT(cell.getCompound("infinity_cell_data")));
        }
        return new InfinityStorageManager(cells);
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider provider) {
        ListTag cellList = new ListTag();
        for (Map.Entry<UUID, InfinityDataStorage> entry : this.cells.entrySet()) {
            CompoundTag cell = new CompoundTag();
            cell.putUUID("infinity_cell_uuid", entry.getKey());
            cell.put("infinity_cell_data", (Tag)entry.getValue().serializeNBT());
            cellList.add((Object)cell);
        }
        nbt.put("infinity_cell_list", (Tag)cellList);
        nbt.putInt("infinity_format_version", 2);
        return nbt;
    }

    public Set<UUID> getAllLoadedUUIDs() {
        return Collections.unmodifiableSet(this.cells.keySet());
    }

    public void updateCell(UUID uuid, InfinityDataStorage infinityDataStorage) {
        this.cells.put(uuid, infinityDataStorage);
        this.setDirty();
    }

    public void removeCell(UUID uuid) {
        this.cells.remove(uuid);
        this.setDirty();
    }

    public boolean hasUUID(UUID uuid) {
        return this.cells.containsKey(uuid);
    }

    public InfinityDataStorage getOrCreateCell(UUID uuid) {
        if (!this.cells.containsKey(uuid)) {
            this.updateCell(uuid, new InfinityDataStorage());
        }
        return this.cells.get(uuid);
    }

    public void modifyDisk(UUID uuid, ListTag keys, ListTag amounts, BigInteger itemCount) {
        InfinityDataStorage cellToModify = this.getOrCreateCell(uuid);
        if (keys != null && amounts != null) {
            cellToModify.keys = keys;
            cellToModify.amounts = amounts;
        }
        cellToModify.itemCount = itemCount;
        this.updateCell(uuid, cellToModify);
    }

    public static InfinityStorageManager getInstance(MinecraftServer server) {
        ServerLevel world = server.getLevel(ServerLevel.OVERWORLD);
        InfinityStorageManager manager = (InfinityStorageManager)world.getDataStorage().computeIfAbsent(FACTORY, "infinity_biginteger_cells");
        manager.registries = new WeakReference<RegistryAccess.Frozen>(server.registryAccess());
        return manager;
    }

    public HolderLookup.Provider getRegistries() {
        WeakReference<HolderLookup.Provider> r = this.registries;
        if (r == null) {
            throw new IllegalStateException("StorageManager was not initialized properly.");
        }
        HolderLookup.Provider registries = (HolderLookup.Provider)r.get();
        if (registries == null) {
            throw new IllegalStateException("Using a StorageManager whose server was already closed");
        }
        return registries;
    }
}

