/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util.wireless;

import appeng.items.tools.powered.WirelessCraftingTerminalItem;
import appeng.items.tools.powered.WirelessTerminalItem;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public final class WirelessTerminalLocator {
    private WirelessTerminalLocator() {
    }

    public static LocatedTerminal find(Player player) {
        if (player == null) {
            return new LocatedTerminal(ItemStack.EMPTY, s -> {});
        }
        ItemStack main = player.getMainHandItem();
        if (!main.isEmpty() && (main.getItem() instanceof WirelessCraftingTerminalItem || main.getItem() instanceof WirelessTerminalItem)) {
            return new LocatedTerminal(main, ns -> player.setItemInHand(InteractionHand.MAIN_HAND, ns), -1, InteractionHand.MAIN_HAND);
        }
        ItemStack off = player.getOffhandItem();
        if (!off.isEmpty() && (off.getItem() instanceof WirelessCraftingTerminalItem || off.getItem() instanceof WirelessTerminalItem)) {
            return new LocatedTerminal(off, ns -> player.setItemInHand(InteractionHand.OFF_HAND, ns), -1, InteractionHand.OFF_HAND);
        }
        Inventory inv = player.getInventory();
        int size = inv.getContainerSize();
        for (int i = 0; i < size; ++i) {
            ItemStack st = inv.getItem(i);
            if (st.isEmpty() || !(st.getItem() instanceof WirelessCraftingTerminalItem) && !(st.getItem() instanceof WirelessTerminalItem)) continue;
            int slot = i;
            return new LocatedTerminal(st, ns -> inv.setItem(slot, ns), slot);
        }
        if (ModList.get().isLoaded("curios")) {
            try {
                Optional opt = CuriosApi.getCuriosInventory((LivingEntity)player);
                if (opt.isPresent()) {
                    ICuriosItemHandler handler = (ICuriosItemHandler)opt.get();
                    for (Map.Entry entry : handler.getCurios().entrySet()) {
                        String slotId = (String)entry.getKey();
                        ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                        IDynamicStackHandler stacks = stacksHandler.getStacks();
                        int slots = stacks.getSlots();
                        for (int i = 0; i < slots; ++i) {
                            ItemStack st = stacks.getStackInSlot(i);
                            if (st.isEmpty() || !(st.getItem() instanceof WirelessCraftingTerminalItem) && !(st.getItem() instanceof WirelessTerminalItem)) continue;
                            int slot = i;
                            Consumer<ItemStack> setter = ns -> stacks.setStackInSlot(slot, ns);
                            return new LocatedTerminal(st, setter, -1, null, slotId, slot);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new LocatedTerminal(ItemStack.EMPTY, s -> {}, -1, null);
    }

    public static final class LocatedTerminal {
        public final ItemStack stack;
        private final Consumer<ItemStack> setter;
        private final int slotIndex;
        private final InteractionHand hand;
        private final String curiosSlotId;
        private final int curiosIndex;

        LocatedTerminal(ItemStack stack, Consumer<ItemStack> setter) {
            this(stack, setter, -1, null, null, -1);
        }

        LocatedTerminal(ItemStack stack, Consumer<ItemStack> setter, int slotIndex) {
            this(stack, setter, slotIndex, null, null, -1);
        }

        LocatedTerminal(ItemStack stack, Consumer<ItemStack> setter, int slotIndex, InteractionHand hand) {
            this(stack, setter, slotIndex, hand, null, -1);
        }

        LocatedTerminal(ItemStack stack, Consumer<ItemStack> setter, int slotIndex, InteractionHand hand, String curiosSlotId, int curiosIndex) {
            this.stack = stack;
            this.setter = setter;
            this.slotIndex = slotIndex;
            this.hand = hand;
            this.curiosSlotId = curiosSlotId;
            this.curiosIndex = curiosIndex;
        }

        public void set(ItemStack newStack) {
            this.setter.accept(newStack);
        }

        public void commit() {
            this.setter.accept(this.stack);
        }

        public boolean isEmpty() {
            return this.stack == null || this.stack.isEmpty();
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }

        public InteractionHand getHand() {
            return this.hand;
        }

        public String getCuriosSlotId() {
            return this.curiosSlotId;
        }

        public int getCuriosIndex() {
            return this.curiosIndex;
        }
    }
}

