/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.client;

import appeng.api.stacks.GenericStack;
import appeng.client.gui.me.common.MEStorageScreen;
import com.extendedae_plus.integration.jei.JeiRuntimeProxy;
import com.extendedae_plus.mixin.ae2.accessor.MEStorageScreenAccessor;
import com.extendedae_plus.network.OpenCraftFromJeiC2SPacket;
import com.extendedae_plus.network.PullFromJeiOrCraftC2SPacket;
import java.util.Optional;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="extendedae_plus", value={Dist.CLIENT})
public final class InputEvents {
    private InputEvents() {
    }

    private static GenericStack toGenericStack(ITypedIngredient<?> typed) {
        try {
            Optional maybe = typed.getItemStack();
            if (maybe.isPresent()) {
                ItemStack is = (ItemStack)maybe.get();
                try {
                    return GenericStack.fromItemStack((ItemStack)is);
                }
                catch (Throwable ignored) {
                    return null;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @SubscribeEvent
    public static void onMouseButtonPre(ScreenEvent.MouseButtonPressed.Pre event) {
        GenericStack stack;
        ITypedIngredient<?> typed;
        Optional<ITypedIngredient<?>> hovered;
        double mouseY;
        double mouseX;
        if (event.getButton() == 0 && Screen.hasShiftDown()) {
            mouseX = event.getMouseX();
            hovered = JeiRuntimeProxy.getIngredientUnderMouse(mouseX, mouseY = event.getMouseY());
            if (hovered.isEmpty()) {
                hovered = JeiRuntimeProxy.getIngredientUnderMouse();
            }
            if (hovered.isPresent()) {
                if (JeiRuntimeProxy.isJeiCheatModeEnabled()) {
                    return;
                }
                typed = hovered.get();
                stack = InputEvents.toGenericStack(typed);
                if (stack != null) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new PullFromJeiOrCraftC2SPacket(stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    event.setCanceled(true);
                    return;
                }
            }
        }
        if (event.getButton() == 2) {
            mouseX = event.getMouseX();
            hovered = JeiRuntimeProxy.getIngredientUnderMouse(mouseX, mouseY = event.getMouseY());
            if (hovered.isEmpty()) {
                hovered = JeiRuntimeProxy.getIngredientUnderMouse();
            }
            if (hovered.isEmpty()) {
                return;
            }
            typed = hovered.get();
            if (JeiRuntimeProxy.isJeiCheatModeEnabled()) {
                return;
            }
            stack = InputEvents.toGenericStack(typed);
            if (stack == null) {
                return;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new OpenCraftFromJeiC2SPacket(stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onKeyPressedPre(ScreenEvent.KeyPressed.Pre event) {
        if (event.getKeyCode() != 70) {
            return;
        }
        Optional<ITypedIngredient<?>> hovered = JeiRuntimeProxy.getIngredientUnderMouse();
        if (hovered.isEmpty()) {
            return;
        }
        ITypedIngredient<?> typed = hovered.get();
        String name = JeiRuntimeProxy.getTypedIngredientDisplayName(typed);
        if (name == null || name.isEmpty()) {
            return;
        }
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof MEStorageScreen) {
            MEStorageScreen me = (MEStorageScreen)screen;
            try {
                MEStorageScreenAccessor acc = (MEStorageScreenAccessor)me;
                acc.eap$getSearchField().setValue(name);
                acc.eap$setSearchText(name);
                event.setCanceled(true);
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

