/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.client.ui;

import com.extendedae_plus.network.UploadEncodedPatternToProviderC2SPacket;
import com.extendedae_plus.util.ExtendedAEPatternUploadUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public class ProviderSelectScreen
extends Screen {
    private final Screen parent;
    private final List<Long> ids;
    private final List<String> names;
    private final List<Integer> emptySlots;
    private final List<Long> gIds = new ArrayList<Long>();
    private final List<String> gNames = new ArrayList<String>();
    private final List<Integer> gTotalSlots = new ArrayList<Integer>();
    private final List<Integer> gCount = new ArrayList<Integer>();
    private final List<Long> fIds = new ArrayList<Long>();
    private final List<String> fNames = new ArrayList<String>();
    private final List<Integer> fTotalSlots = new ArrayList<Integer>();
    private final List<Integer> fCount = new ArrayList<Integer>();
    private EditBox searchBox;
    private EditBox cnInput;
    private String query = "";
    private boolean needsRefresh = false;
    private int page = 0;
    private static final int PAGE_SIZE = 6;
    private final List<Button> entryButtons = new ArrayList<Button>();
    private static Boolean JEC_AVAILABLE = null;
    private static Method JEC_CONTAINS = null;

    public ProviderSelectScreen(Screen parent, List<Long> ids, List<String> names, List<Integer> emptySlots) {
        super((Component)Component.translatable((String)"extendedae_plus.screen.choose_provider.title"));
        this.parent = parent;
        this.ids = ids;
        this.names = names;
        this.emptySlots = emptySlots;
        try {
            String recent = ExtendedAEPatternUploadUtil.lastProcessingName;
            if (recent != null && !recent.isBlank()) {
                this.query = recent;
                ExtendedAEPatternUploadUtil.lastProcessingName = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.buildGroups();
        this.applyFilter();
    }

    protected void init() {
        this.clearWidgets();
        this.entryButtons.clear();
        int centerX = this.width / 2;
        int startY = this.height / 2 - 70;
        if (this.searchBox == null) {
            this.searchBox = new EditBox(this.font, centerX - 120, startY - 25, 240, 18, (Component)Component.translatable((String)"extendedae_plus.screen.search"));
        } else {
            this.searchBox.setX(centerX - 120);
            this.searchBox.setY(startY - 25);
            this.searchBox.setWidth(240);
        }
        this.searchBox.setValue(this.query);
        this.searchBox.setResponder(text -> {
            if (Objects.equals(text, this.query)) {
                return;
            }
            this.query = text;
            this.page = 0;
            this.applyFilter();
            this.needsRefresh = true;
        });
        this.addRenderableWidget((GuiEventListener)this.searchBox);
        int start = this.page * 6;
        int end = Math.min(start + 6, this.fIds.size());
        int buttonWidth = 240;
        int buttonHeight = 20;
        int gap = 5;
        for (int i = start; i < end; ++i) {
            int idx = i;
            String label = this.buildLabel(idx);
            Button btn = Button.builder((Component)Component.literal((String)label), b -> this.onChoose(idx)).bounds(centerX - buttonWidth / 2, startY + (i - start) * (buttonHeight + gap), buttonWidth, buttonHeight).build();
            this.entryButtons.add(btn);
            this.addRenderableWidget((GuiEventListener)btn);
        }
        int navY = startY + 6 * (buttonHeight + gap) + 10;
        Button prev = Button.builder((Component)Component.literal((String)"<"), b -> this.changePage(-1)).bounds(centerX - 60, navY, 20, 20).build();
        Button next = Button.builder((Component)Component.literal((String)">"), b -> this.changePage(1)).bounds(centerX + 40, navY, 20, 20).build();
        prev.active = this.page > 0;
        next.active = (this.page + 1) * 6 < this.fIds.size();
        this.addRenderableWidget((GuiEventListener)prev);
        this.addRenderableWidget((GuiEventListener)next);
        Button reload = Button.builder((Component)Component.translatable((String)"extendedae_plus.screen.reload_mapping"), b -> this.reloadMapping()).bounds(centerX - 130, navY + 30, 80, 20).build();
        this.addRenderableWidget((GuiEventListener)reload);
        if (this.cnInput == null) {
            this.cnInput = new EditBox(this.font, centerX + 50, navY + 30, 120, 20, (Component)Component.translatable((String)"extendedae_plus.screen.cn_name"));
        } else {
            this.cnInput.setX(centerX + 50);
            this.cnInput.setY(navY + 30);
            this.cnInput.setWidth(120);
        }
        this.addRenderableWidget((GuiEventListener)this.cnInput);
        Button addMap = Button.builder((Component)Component.translatable((String)"extendedae_plus.screen.add_mapping"), b -> this.addMappingFromUI()).bounds(centerX + 175, navY + 30, 60, 20).build();
        this.addRenderableWidget((GuiEventListener)addMap);
        Button delByCn = Button.builder((Component)Component.literal((String)"\u5220\u9664\u6620\u5c04"), b -> this.deleteMappingByCnFromUI()).bounds(centerX + 240, navY + 30, 60, 20).build();
        this.addRenderableWidget((GuiEventListener)delByCn);
        Button close = Button.builder((Component)Component.translatable((String)"gui.cancel"), b -> this.onClose()).bounds(centerX - 40, navY + 30, 80, 20).build();
        this.addRenderableWidget((GuiEventListener)close);
    }

    private void changePage(int delta) {
        int newPage = this.page + delta;
        if (newPage < 0) {
            return;
        }
        if (newPage * 6 >= this.fIds.size()) {
            return;
        }
        this.page = newPage;
        this.needsRefresh = true;
    }

    private void reloadMapping() {
        block3: {
            try {
                ExtendedAEPatternUploadUtil.loadRecipeTypeNames();
                LocalPlayer player = Minecraft.getInstance().player;
                if (player != null) {
                    player.sendSystemMessage((Component)Component.literal((String)"ExtendedAE Plus: \u5df2\u91cd\u8f7d\u6620\u5c04\u8868"));
                }
            }
            catch (Throwable t) {
                LocalPlayer player = Minecraft.getInstance().player;
                if (player == null) break block3;
                player.sendSystemMessage((Component)Component.literal((String)("ExtendedAE Plus: \u91cd\u8f7d\u6620\u5c04\u8868\u5931\u8d25: " + t.getClass().getSimpleName())));
            }
        }
    }

    private String buildLabel(int idx) {
        String name = this.fNames.get(idx);
        int totalSlots = this.fTotalSlots.get(idx);
        int count = this.fCount.get(idx);
        return name + "  (" + totalSlots + ")  x" + count;
    }

    private void onChoose(int idx) {
        if (idx < 0 || idx >= this.fIds.size()) {
            return;
        }
        long providerId = this.fIds.get(idx);
        ClientPacketListener conn = Minecraft.getInstance().getConnection();
        if (conn != null) {
            conn.send((CustomPacketPayload)new UploadEncodedPatternToProviderC2SPacket(providerId));
        }
        this.onClose();
    }

    public void onClose() {
        Minecraft.getInstance().setScreen(this.parent);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void buildGroups() {
        LinkedHashMap<String, Group> map = new LinkedHashMap<String, Group>();
        for (int i = 0; i < this.names.size(); ++i) {
            String name = this.names.get(i);
            long id = this.ids.get(i);
            int slots = this.emptySlots.get(i);
            Group g = map.computeIfAbsent(name, k -> new Group());
            ++g.count;
            g.totalSlots += Math.max(0, slots);
            if (slots <= g.bestSlots) continue;
            g.bestSlots = slots;
            g.bestId = id;
        }
        for (Map.Entry e : map.entrySet()) {
            String name = (String)e.getKey();
            Group g = (Group)e.getValue();
            this.gNames.add(name);
            this.gIds.add(g.bestId);
            this.gTotalSlots.add(g.totalSlots);
            this.gCount.add(g.count);
        }
    }

    private void applyFilter() {
        this.fIds.clear();
        this.fNames.clear();
        this.fTotalSlots.clear();
        this.fCount.clear();
        String q = this.query == null ? "" : this.query.trim();
        for (int i = 0; i < this.gIds.size(); ++i) {
            String name = this.gNames.get(i);
            if (!q.isEmpty() && !ProviderSelectScreen.nameMatches(name, q)) continue;
            this.fIds.add(this.gIds.get(i));
            this.fNames.add(name);
            this.fTotalSlots.add(this.gTotalSlots.get(i));
            this.fCount.add(this.gCount.get(i));
        }
    }

    private static boolean nameMatches(String name, String key) {
        if (name == null) {
            return false;
        }
        if (key == null || key.isEmpty()) {
            return true;
        }
        try {
            if (JEC_AVAILABLE == null) {
                try {
                    Class<?> cls = Class.forName("me.towdium.jecharacters.utils.Match");
                    JEC_CONTAINS = cls.getMethod("contains", CharSequence.class, CharSequence.class);
                    JEC_AVAILABLE = true;
                }
                catch (Throwable t) {
                    JEC_AVAILABLE = false;
                }
            }
            if (Boolean.TRUE.equals(JEC_AVAILABLE) && JEC_CONTAINS != null) {
                String kL;
                Object r = JEC_CONTAINS.invoke(null, name, key);
                if (r instanceof Boolean && ((Boolean)r).booleanValue()) {
                    return true;
                }
                String nL = name.toLowerCase();
                Object r2 = JEC_CONTAINS.invoke(null, nL, kL = key.toLowerCase());
                if (r2 instanceof Boolean && ((Boolean)r2).booleanValue()) {
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return name.toLowerCase().contains(key.toLowerCase());
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox != null && this.searchBox.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (this.searchBox != null && this.searchBox.charTyped(codePoint, modifiers)) {
            return true;
        }
        return super.charTyped(codePoint, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 1 && this.searchBox != null) {
            int x = this.searchBox.getX();
            int y = this.searchBox.getY();
            int w = this.searchBox.getWidth();
            int h = this.searchBox.getHeight();
            if (mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h)) {
                if (!this.searchBox.getValue().isEmpty()) {
                    this.searchBox.setValue("");
                }
                this.query = "";
                this.page = 0;
                this.applyFilter();
                this.needsRefresh = true;
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void tick() {
        super.tick();
        if (this.needsRefresh) {
            this.needsRefresh = false;
            this.init();
        }
    }

    private void addMappingFromUI() {
        String key = this.query == null ? "" : this.query.trim();
        String val = this.cnInput == null ? "" : this.cnInput.getValue().trim();
        LocalPlayer player = Minecraft.getInstance().player;
        if (key.isEmpty()) {
            if (player != null) {
                player.sendSystemMessage((Component)Component.literal((String)"\u8bf7\u8f93\u5165\u641c\u7d22\u5173\u952e\u5b57\u540e\u518d\u6dfb\u52a0\u6620\u5c04"));
            }
            return;
        }
        if (val.isEmpty()) {
            if (player != null) {
                player.sendSystemMessage((Component)Component.literal((String)"\u8bf7\u8f93\u5165\u4e2d\u6587\u540d\u79f0"));
            }
            return;
        }
        boolean ok = ExtendedAEPatternUploadUtil.addOrUpdateAliasMapping(key, val);
        if (ok) {
            if (player != null) {
                player.sendSystemMessage((Component)Component.literal((String)("\u5df2\u6dfb\u52a0/\u66f4\u65b0\u6620\u5c04: " + key + " -> " + val)));
            }
            this.query = val;
            if (this.searchBox != null) {
                this.searchBox.setValue(val);
            }
            this.applyFilter();
            this.page = 0;
            this.needsRefresh = true;
        } else if (player != null) {
            player.sendSystemMessage((Component)Component.literal((String)"\u5199\u5165\u6620\u5c04\u5931\u8d25"));
        }
    }

    private void deleteMappingByCnFromUI() {
        String val = this.cnInput == null ? "" : this.cnInput.getValue().trim();
        LocalPlayer player = Minecraft.getInstance().player;
        if (val.isEmpty()) {
            if (player != null) {
                player.sendSystemMessage((Component)Component.literal((String)"\u8bf7\u8f93\u5165\u4e2d\u6587\u540d\u79f0\u540e\u518d\u5220\u9664\u6620\u5c04"));
            }
            return;
        }
        int removed = ExtendedAEPatternUploadUtil.removeMappingsByCnValue(val);
        if (removed > 0) {
            if (player != null) {
                player.sendSystemMessage((Component)Component.literal((String)("\u5df2\u5220\u9664 " + removed + " \u6761\u6620\u5c04\uff0c\u4e2d\u6587= " + val)));
            }
            this.applyFilter();
            this.needsRefresh = true;
        } else if (player != null) {
            player.sendSystemMessage((Component)Component.literal((String)("\u672a\u627e\u5230\u4e2d\u6587\u4e3a '" + val + "' \u7684\u6620\u5c04")));
        }
    }

    private static class Group {
        long bestId = Long.MIN_VALUE;
        int bestSlots = Integer.MIN_VALUE;
        int totalSlots = 0;
        int count = 0;

        private Group() {
        }
    }
}

