/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.content;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.crafting.pattern.AEProcessingPattern;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class ScaledProcessingPattern
implements IPatternDetails {
    private final AEProcessingPattern original;
    private final AEItemKey definition;
    private final List<GenericStack> sparseInputs;
    private final List<GenericStack> sparseOutputs;
    private final IPatternDetails.IInput[] inputs;
    private final List<GenericStack> condensedOutputs;

    public ScaledProcessingPattern(AEProcessingPattern original, AEItemKey definition, List<GenericStack> sparseInputs, List<GenericStack> sparseOutputs, IPatternDetails.IInput[] inputs, List<GenericStack> condensedOutputs) {
        this.original = Objects.requireNonNull(original);
        this.definition = Objects.requireNonNull(definition);
        this.sparseInputs = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(sparseInputs)));
        this.sparseOutputs = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(sparseOutputs)));
        this.inputs = Objects.requireNonNull(inputs);
        this.condensedOutputs = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(condensedOutputs)));
    }

    public AEProcessingPattern getOriginal() {
        return this.original;
    }

    public AEItemKey getDefinition() {
        return this.definition;
    }

    public IPatternDetails.IInput[] getInputs() {
        return this.inputs;
    }

    public List<GenericStack> getOutputs() {
        return this.condensedOutputs;
    }

    public List<GenericStack> getSparseInputs() {
        return this.sparseInputs;
    }

    public List<GenericStack> getSparseOutputs() {
        return this.sparseOutputs;
    }

    public GenericStack getPrimaryOutput() {
        if (!this.condensedOutputs.isEmpty()) {
            return this.condensedOutputs.get(0);
        }
        return this.original.getPrimaryOutput();
    }

    public boolean supportsPushInputsToExternalInventory() {
        return this.original.supportsPushInputsToExternalInventory();
    }

    public void pushInputsToExternalInventory(KeyCounter[] inputHolder, IPatternDetails.PatternInputSink inputSink) {
        if (this.sparseInputs.size() == this.inputs.length) {
            super.pushInputsToExternalInventory(inputHolder, inputSink);
        } else {
            KeyCounter allInputs = new KeyCounter();
            for (KeyCounter counter : inputHolder) {
                allInputs.addAll(counter);
            }
            for (GenericStack sparseInput : this.sparseInputs) {
                if (sparseInput == null) continue;
                AEKey key = sparseInput.what();
                long amount = sparseInput.amount();
                long available = allInputs.get(key);
                if (available < amount) {
                    throw new RuntimeException("Expected at least %d of %s when pushing scaled pattern, but only %d available".formatted(amount, key, available));
                }
                inputSink.pushInput(key, amount);
                allInputs.remove(key, amount);
            }
        }
    }

    public static final class Input
    implements IPatternDetails.IInput {
        private final GenericStack[] template;
        private final long multiplier;

        public Input(GenericStack[] template, long multiplier) {
            this.template = template;
            this.multiplier = multiplier;
        }

        public GenericStack[] getPossibleInputs() {
            return this.template;
        }

        public long getMultiplier() {
            return this.multiplier;
        }

        public boolean isValid(AEKey input, Level level) {
            return input.matches(this.template[0]);
        }

        @Nullable
        public AEKey getRemainingKey(AEKey template) {
            return null;
        }
    }
}

