/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.content.wireless;

import com.extendedae_plus.content.wireless.WirelessTransceiverBlockEntity;
import com.extendedae_plus.init.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class WirelessTransceiverBlock
extends Block
implements EntityBlock {
    public WirelessTransceiverBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WirelessTransceiverBlockEntity(pos, state);
    }

    public void attack(BlockState state, Level level, BlockPos pos, Player player) {
        BlockEntity be;
        if (!level.isClientSide && player.isShiftKeyDown() && (be = level.getBlockEntity(pos)) instanceof WirelessTransceiverBlockEntity) {
            WirelessTransceiverBlockEntity te = (WirelessTransceiverBlockEntity)be;
            if (te.isLocked()) {
                player.displayClientMessage((Component)Component.literal((String)"\u6536\u53d1\u5668\u5df2\u9501\u5b9a\uff0c\u65e0\u6cd5\u4fee\u6539\u9891\u9053"), true);
                super.attack(state, level, pos, player);
                return;
            }
            int step = 1;
            if (player.getMainHandItem().is(Items.REDSTONE_TORCH)) {
                step = 10;
            }
            if (player.getMainHandItem().is(Items.STICK)) {
                step = 10;
            }
            long f = te.getFrequency();
            if ((f -= (long)step) < 0L) {
                f = 0L;
            }
            te.setFrequency(f);
            player.displayClientMessage((Component)Component.literal((String)("\u9891\u9053\uff1a" + te.getFrequency())), true);
        }
        super.attack(state, level, pos, player);
    }

    protected ItemInteractionResult useItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof WirelessTransceiverBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        WirelessTransceiverBlockEntity te = (WirelessTransceiverBlockEntity)be;
        boolean sneaking = player.isShiftKeyDown();
        if (sneaking) {
            if (te.isLocked()) {
                if (!level.isClientSide) {
                    player.displayClientMessage((Component)Component.literal((String)"\u6536\u53d1\u5668\u5df2\u9501\u5b9a\uff0c\u65e0\u6cd5\u4fee\u6539\u9891\u9053"), true);
                }
            } else {
                int step = 1;
                if (heldItem.is(Items.REDSTONE_TORCH)) {
                    step = 10;
                }
                if (heldItem.is(Items.STICK)) {
                    step = 10;
                }
                long f = te.getFrequency();
                if (hand == InteractionHand.MAIN_HAND) {
                    f += (long)step;
                } else if ((f -= (long)step) < 0L) {
                    f = 0L;
                }
                te.setFrequency(f);
                if (!level.isClientSide) {
                    player.displayClientMessage((Component)Component.literal((String)("\u9891\u9053\uff1a" + te.getFrequency())), true);
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (te.isLocked()) {
            if (!level.isClientSide) {
                player.displayClientMessage((Component)Component.literal((String)"\u6536\u53d1\u5668\u5df2\u9501\u5b9a\uff0c\u65e0\u6cd5\u5207\u6362\u6a21\u5f0f"), true);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        te.setMasterMode(!te.isMasterMode());
        if (!level.isClientSide) {
            player.displayClientMessage((Component)Component.literal((String)(te.isMasterMode() ? "\u6a21\u5f0f\uff1a\u4e3b\u7aef" : "\u6a21\u5f0f\uff1a\u4ece\u7aef")), true);
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof WirelessTransceiverBlockEntity)) {
            return InteractionResult.PASS;
        }
        WirelessTransceiverBlockEntity te = (WirelessTransceiverBlockEntity)be;
        boolean sneaking = player.isShiftKeyDown();
        if (sneaking) {
            if (te.isLocked()) {
                if (!level.isClientSide) {
                    player.displayClientMessage((Component)Component.literal((String)"\u6536\u53d1\u5668\u5df2\u9501\u5b9a\uff0c\u65e0\u6cd5\u4fee\u6539\u9891\u9053"), true);
                }
            } else {
                long f = te.getFrequency();
                te.setFrequency(++f);
                if (!level.isClientSide) {
                    player.displayClientMessage((Component)Component.literal((String)("\u9891\u9053\uff1a" + te.getFrequency())), true);
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (te.isLocked()) {
            if (!level.isClientSide) {
                player.displayClientMessage((Component)Component.literal((String)"\u6536\u53d1\u5668\u5df2\u9501\u5b9a\uff0c\u65e0\u6cd5\u5207\u6362\u6a21\u5f0f"), true);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        te.setMasterMode(!te.isMasterMode());
        if (!level.isClientSide) {
            player.displayClientMessage((Component)Component.literal((String)(te.isMasterMode() ? "\u6a21\u5f0f\uff1a\u4e3b\u7aef" : "\u6a21\u5f0f\uff1a\u4ece\u7aef")), true);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity be;
        if (!state.is(newState.getBlock()) && (be = level.getBlockEntity(pos)) instanceof WirelessTransceiverBlockEntity) {
            WirelessTransceiverBlockEntity te = (WirelessTransceiverBlockEntity)be;
            te.onRemoved();
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.isClientSide) {
            return null;
        }
        return type == ModBlockEntities.WIRELESS_TRANSCEIVER_BE.get() ? (lvl, pos, st, be) -> WirelessTransceiverBlockEntity.serverTick(lvl, pos, st, (WirelessTransceiverBlockEntity)be) : null;
    }
}

