/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.integration.jade;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import com.extendedae_plus.content.wireless.WirelessTransceiverBlockEntity;
import com.extendedae_plus.wireless.IWirelessEndpoint;
import com.extendedae_plus.wireless.WirelessMasterRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IServerDataProvider;

public enum WirelessTransceiverProvider implements IServerDataProvider<BlockAccessor>
{
    INSTANCE;

    private static final ResourceLocation UID;

    public ResourceLocation getUid() {
        return UID;
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof WirelessTransceiverBlockEntity) {
            long freq;
            ServerLevel level;
            IWirelessEndpoint master;
            WirelessTransceiverBlockEntity blockEntity2 = (WirelessTransceiverBlockEntity)blockEntity;
            data.putLong("frequency", blockEntity2.getFrequency());
            data.putBoolean("masterMode", blockEntity2.isMasterMode());
            data.putBoolean("locked", blockEntity2.isLocked());
            IGridNode node = blockEntity2.getGridNode();
            IGrid grid = node == null ? null : node.getGrid();
            boolean networkUsable = false;
            if (grid != null) {
                try {
                    networkUsable = grid.getEnergyService().isNetworkPowered();
                }
                catch (Throwable ignored) {
                    networkUsable = false;
                }
            }
            data.putBoolean("networkUsable", networkUsable);
            if (!blockEntity2.isMasterMode() && (master = WirelessMasterRegistry.get(level = blockEntity2.getServerLevel(), freq = blockEntity2.getFrequency())) != null && !master.isEndpointRemoved()) {
                BlockPos pos = master.getBlockPos();
                if (pos != null) {
                    data.putLong("masterPos", pos.asLong());
                }
                if (master.getServerLevel() != null) {
                    data.putString("masterDim", master.getServerLevel().dimension().location().toString());
                }
            }
        }
    }

    static {
        UID = ResourceLocation.fromNamespaceAndPath((String)"extendedae_plus", (String)"wireless_transceiver_info");
    }
}

