/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.items.tools.powered.WirelessCraftingTerminalItem;
import appeng.items.tools.powered.WirelessTerminalItem;
import appeng.me.helpers.PlayerSource;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.crafting.CraftAmountMenu;
import com.extendedae_plus.util.WirelessTerminalLocator;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PullFromJeiOrCraftC2SPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<PullFromJeiOrCraftC2SPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"extendedae_plus", (String)"pull_from_jei_or_craft"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PullFromJeiOrCraftC2SPacket> STREAM_CODEC = StreamCodec.of((buf, pkt) -> GenericStack.writeBuffer((GenericStack)pkt.stack, (RegistryFriendlyByteBuf)buf), buf -> new PullFromJeiOrCraftC2SPacket(GenericStack.readBuffer((RegistryFriendlyByteBuf)buf)));
    private final GenericStack stack;

    public PullFromJeiOrCraftC2SPacket(GenericStack stack) {
        this.stack = stack;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(PullFromJeiOrCraftC2SPacket msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            MEStorage storage;
            WirelessCraftingTerminalItem wt;
            WirelessCraftingTerminalItem c;
            WirelessCraftingTerminalItem wct;
            Player patt0$temp = ctx.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            if (msg.stack == null) {
                return;
            }
            AEKey what = msg.stack.what();
            if (!(what instanceof AEItemKey)) {
                return;
            }
            AEItemKey itemKey = (AEItemKey)what;
            WirelessTerminalLocator.LocatedTerminal located = WirelessTerminalLocator.find((Player)player);
            ItemStack terminal = located.stack;
            if (terminal.isEmpty()) {
                return;
            }
            ServerLevel level = player.serverLevel();
            Item patt1$temp = terminal.getItem();
            WirelessCraftingTerminalItem wirelessCraftingTerminalItem = wct = patt1$temp instanceof WirelessCraftingTerminalItem ? (c = (WirelessCraftingTerminalItem)patt1$temp) : null;
            if (wct != null) {
                v1 = wct;
            } else {
                Item patt1$temp2 = terminal.getItem();
                if (patt1$temp2 instanceof WirelessTerminalItem) {
                    WirelessTerminalItem t = (WirelessTerminalItem)patt1$temp2;
                    v1 = t;
                } else {
                    v1 = wt = null;
                }
            }
            if (wt == null) {
                return;
            }
            IGrid grid = wt.getLinkedGrid(terminal, (Level)level, null);
            if (grid == null) {
                return;
            }
            if (!wt.hasPower((Player)player, 0.5, terminal)) {
                return;
            }
            Inventory inv = player.getInventory();
            int free = inv.getFreeSlot();
            if (free == -1) {
                return;
            }
            int targetMax = itemKey.toStack(1).getMaxStackSize();
            IEnergyService energy = grid.getEnergyService();
            long extracted = StorageHelper.poweredExtraction((IEnergySource)energy, (MEStorage)(storage = grid.getStorageService().getInventory()), (AEKey)itemKey, (long)targetMax, (IActionSource)new PlayerSource((Player)player));
            if (extracted > 0L) {
                WirelessCraftingTerminalItem wt2;
                WirelessCraftingTerminalItem c2;
                WirelessCraftingTerminalItem wct2;
                inv.setItem(free, itemKey.toStack((int)extracted));
                Item patt1$temp3 = terminal.getItem();
                WirelessCraftingTerminalItem wirelessCraftingTerminalItem2 = wct2 = patt1$temp3 instanceof WirelessCraftingTerminalItem ? (c2 = (WirelessCraftingTerminalItem)patt1$temp3) : null;
                if (wct2 != null) {
                    v3 = wct2;
                } else {
                    Item patt1$temp4 = terminal.getItem();
                    if (patt1$temp4 instanceof WirelessTerminalItem) {
                        WirelessTerminalItem t2 = (WirelessTerminalItem)patt1$temp4;
                        v3 = t2;
                    } else {
                        v3 = wt2 = null;
                    }
                }
                if (wt2 != null) {
                    wt2.usePower((Player)player, Math.max(0.5, (double)extracted * 0.05), terminal);
                }
                located.commit();
                player.containerMenu.broadcastChanges();
                return;
            }
            ICraftingService craftingService = grid.getCraftingService();
            if (!craftingService.isCraftable(what)) {
                return;
            }
            InteractionHand hand = located.getHand();
            int slot = located.getSlotIndex();
            if (hand != null) {
                CraftAmountMenu.open((ServerPlayer)player, (MenuHostLocator)MenuLocators.forHand((Player)player, (InteractionHand)hand), (AEKey)what, (int)1);
            } else if (slot >= 0) {
                CraftAmountMenu.open((ServerPlayer)player, (MenuHostLocator)MenuLocators.forInventorySlot((int)slot), (AEKey)what, (int)1);
            }
        });
    }
}

