/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.crafting.pattern.AEProcessingPattern;
import com.extendedae_plus.api.SmartDoublingAwarePattern;
import com.extendedae_plus.config.ModConfigs;
import com.extendedae_plus.content.ScaledProcessingPattern;
import java.util.ArrayList;
import java.util.List;

public final class PatternScaler {
    private PatternScaler() {
    }

    public static ScaledProcessingPattern scale(AEProcessingPattern base, AEKey target, long requestedAmount) {
        long amt;
        int i;
        SmartDoublingAwarePattern aware;
        if (base == null) {
            throw new IllegalArgumentException("base");
        }
        if (target == null) {
            throw new IllegalArgumentException("target");
        }
        if (base instanceof SmartDoublingAwarePattern && !(aware = (SmartDoublingAwarePattern)base).eap$allowScaling()) {
            return null;
        }
        List baseSparseInputs = base.getSparseInputs();
        List baseSparseOutputs = base.getSparseOutputs();
        IPatternDetails.IInput[] baseInputs = base.getInputs();
        List baseOutputs = base.getOutputs();
        int targetOutIndex = -1;
        for (i = 0; i < baseOutputs.size(); ++i) {
            GenericStack out = (GenericStack)baseOutputs.get(i);
            if (out == null || target == null || out.what() == null || !out.what().equals(target)) continue;
            targetOutIndex = i;
            break;
        }
        if (targetOutIndex == -1) {
            for (i = 0; i < baseOutputs.size(); ++i) {
                if (baseOutputs.get(i) == null) continue;
                targetOutIndex = i;
                break;
            }
        }
        if (targetOutIndex == -1 && !baseOutputs.isEmpty()) {
            targetOutIndex = 0;
        }
        long perOperationTarget = 1L;
        if (targetOutIndex >= 0 && baseOutputs.get(targetOutIndex) != null && (amt = ((GenericStack)baseOutputs.get(targetOutIndex)).amount()) > 0L) {
            perOperationTarget = amt;
        }
        long multiplier = 1L;
        if (requestedAmount > 0L) {
            long needed = requestedAmount / perOperationTarget + (long)(requestedAmount % perOperationTarget == 0L ? 0 : 1);
            multiplier = needed <= 1L ? 1L : needed;
        }
        try {
            int maxMul = (Integer)ModConfigs.SMART_SCALING_MAX_MULTIPLIER.get();
            if (maxMul > 0 && multiplier > (long)maxMul) {
                multiplier = maxMul;
            }
        }
        catch (Throwable maxMul) {
            // empty catch block
        }
        IPatternDetails.IInput[] scaledInputs = new IPatternDetails.IInput[baseInputs.length];
        for (int i2 = 0; i2 < baseInputs.length; ++i2) {
            IPatternDetails.IInput in = baseInputs[i2];
            GenericStack[] template = in.getPossibleInputs();
            GenericStack[] scaledTemplates = new GenericStack[template.length];
            for (int j = 0; j < template.length; ++j) {
                scaledTemplates[j] = new GenericStack(template[j].what(), template[j].amount());
            }
            scaledInputs[i2] = new ScaledProcessingPattern.Input(scaledTemplates, in.getMultiplier() * multiplier);
        }
        ArrayList<GenericStack> scaledCondensedOutputs = new ArrayList<GenericStack>(baseOutputs.size());
        for (int i3 = 0; i3 < baseOutputs.size(); ++i3) {
            GenericStack out = (GenericStack)baseOutputs.get(i3);
            if (out != null) {
                scaledCondensedOutputs.add(new GenericStack(out.what(), out.amount() * multiplier));
                continue;
            }
            scaledCondensedOutputs.add(null);
        }
        ArrayList<GenericStack> scaledSparseInputs = new ArrayList<GenericStack>(baseSparseInputs.size());
        for (int i4 = 0; i4 < baseSparseInputs.size(); ++i4) {
            GenericStack in = (GenericStack)baseSparseInputs.get(i4);
            if (in != null) {
                scaledSparseInputs.add(new GenericStack(in.what(), in.amount() * multiplier));
                continue;
            }
            scaledSparseInputs.add(null);
        }
        ArrayList<GenericStack> scaledSparseOutputs = new ArrayList<GenericStack>(baseSparseOutputs.size());
        for (int i5 = 0; i5 < baseSparseOutputs.size(); ++i5) {
            GenericStack out = (GenericStack)baseSparseOutputs.get(i5);
            if (out != null) {
                scaledSparseOutputs.add(new GenericStack(out.what(), out.amount() * multiplier));
                continue;
            }
            scaledSparseOutputs.add(null);
        }
        return new ScaledProcessingPattern(base, base.getDefinition(), scaledSparseInputs, scaledSparseOutputs, scaledInputs, scaledCondensedOutputs);
    }
}

