/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.ae.parts;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.YesNo;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.storage.MEStorage;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.core.definitions.AEItems;
import appeng.items.parts.PartModels;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import appeng.parts.automation.UpgradeablePart;
import com.extendedae_plus.ae.menu.EntitySpeedTickerMenu;
import com.extendedae_plus.ae.wireless.WirelessSlaveLink;
import com.extendedae_plus.ae.wireless.endpoint.GenericNodeEndpointImpl;
import com.extendedae_plus.api.bridge.IInterfaceWirelessLinkBridge;
import com.extendedae_plus.api.config.Settings;
import com.extendedae_plus.config.ModConfig;
import com.extendedae_plus.init.ModItems;
import com.extendedae_plus.init.ModMenuTypes;
import com.extendedae_plus.items.materials.ChannelCardItem;
import com.extendedae_plus.util.Logger;
import com.extendedae_plus.util.ModCheckUtils;
import com.extendedae_plus.util.entitySpeed.ConfigParsingUtils;
import com.extendedae_plus.util.entitySpeed.PowerUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntitySpeedTickerPart
extends UpgradeablePart
implements IGridTickable,
MenuProvider,
IUpgradeableObject,
IInterfaceWirelessLinkBridge {
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("extendedae_plus", "part/entity_speed_ticker_part");
    @PartModels
    public static final PartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("extendedae_plus", "part/entity_speed_ticker_off")});
    @PartModels
    public static final PartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("extendedae_plus", "part/entity_speed_ticker_on")});
    @PartModels
    public static final PartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("extendedae_plus", "part/entity_speed_ticker_has_channel")});
    private static volatile MethodHandle cachedFEExtractHandle;
    private static volatile boolean FE_UNAVAILABLE;
    private YesNo redstoneState = YesNo.UNDECIDED;
    public EntitySpeedTickerMenu menu;
    private boolean networkEnergySufficient = true;
    private int cachedSpeed = -1;
    private int cachedEnergyCardCount = -1;
    private BlockEntity cachedTarget = null;
    private BlockPos cachedTargetPos = null;
    private WirelessSlaveLink wirelessLink;
    private long lastChannelFrequency = -1L;
    private UUID lastChannelOwner;
    private boolean wirelessClientConnected = false;
    private boolean wirelessPendingInit = true;

    public EntitySpeedTickerPart(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).setIdlePowerUsage(1.0).addService(IGridTickable.class, (IGridNodeService)this);
        this.getConfigManager().registerSetting(Settings.ACCELERATE, (Enum)YesNo.YES);
        this.getConfigManager().registerSetting(Settings.REDSTONE_CONTROL, (Enum)YesNo.NO);
    }

    public boolean getAccelerateEnabled() {
        return this.getConfigManager().getSetting(Settings.ACCELERATE) == YesNo.YES;
    }

    public boolean getRedstoneControlEnabled() {
        return this.getConfigManager().getSetting(Settings.REDSTONE_CONTROL) == YesNo.YES;
    }

    public void setAccelerateEnabled(boolean enabled) {
        this.getConfigManager().putSetting(Settings.ACCELERATE, (Enum)(enabled ? YesNo.YES : YesNo.NO));
        if (this.menu != null) {
            this.menu.setAccelerateEnabled(enabled);
        }
    }

    public void setRedstoneControlEnabled(boolean enabled) {
        this.getConfigManager().putSetting(Settings.REDSTONE_CONTROL, (Enum)(enabled ? YesNo.YES : YesNo.NO));
        if (this.menu != null) {
            this.menu.m_38946_();
        }
    }

    public boolean getNetworkEnergySufficient() {
        return this.networkEnergySufficient;
    }

    private void setNetworkEnergySufficient(boolean sufficient) {
        this.networkEnergySufficient = sufficient;
        if (this.menu != null) {
            this.menu.setNetworkEnergySufficient(sufficient);
        }
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    public boolean onPartActivate(Player player, InteractionHand hand, Vec3 pos) {
        if (!player.m_20193_().m_5776_()) {
            MenuOpener.open((MenuType)((MenuType)ModMenuTypes.ENTITY_TICKER_MENU.get()), (Player)player, (MenuLocator)MenuLocators.forPart((AEBasePart)this));
        }
        return true;
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(3.0, 3.0, 14.0, 13.0, 13.0, 16.0);
        bch.addBox(5.0, 5.0, 11.0, 11.0, 11.0, 14.0);
    }

    public TickingRequest getTickingRequest(IGridNode iGridNode) {
        return new TickingRequest(1, 1, false, true);
    }

    public void upgradesChanged() {
        this.cachedEnergyCardCount = this.getUpgrades().getInstalledUpgrades((ItemLike)AEItems.ENERGY_CARD);
        this.cachedSpeed = this.calculateSpeed();
        if (this.menu != null) {
            this.menu.m_38946_();
        }
        this.scheduleWirelessInit();
    }

    protected void onMainNodeStateChanged(IGridNodeListener.State reason) {
        super.onMainNodeStateChanged(reason);
        if (reason == IGridNodeListener.State.GRID_BOOT) {
            this.scheduleWirelessInit();
        }
    }

    public TickRateModulation tickingRequest(IGridNode iGridNode, int ticksSinceLastCall) {
        this.handleWirelessLogic();
        if (!this.getAccelerateEnabled()) {
            return TickRateModulation.IDLE;
        }
        if (this.getRedstoneControlEnabled() && !this.getRedstoneState()) {
            return TickRateModulation.IDLE;
        }
        this.updateCachedTarget();
        if (this.cachedTarget != null && this.isActive()) {
            this.ticker(this.cachedTarget);
        }
        return TickRateModulation.IDLE;
    }

    private <T extends BlockEntity> void ticker(@Nullable T blockEntity) {
        if (blockEntity == null || !this.isValidForTicking()) {
            return;
        }
        String blockId = ForgeRegistries.BLOCKS.getKey((Object)blockEntity.m_58900_().m_60734_()).toString();
        if (ConfigParsingUtils.isBlockBlacklisted(blockId)) {
            return;
        }
        BlockEntityTicker<T> ticker = this.getTicker(blockEntity);
        if (ticker == null) {
            return;
        }
        if (this.cachedEnergyCardCount == -1 || this.cachedSpeed == -1) {
            this.cachedEnergyCardCount = this.getUpgrades().getInstalledUpgrades((ItemLike)AEItems.ENERGY_CARD);
            this.cachedSpeed = this.calculateSpeed();
        }
        if (this.cachedSpeed <= 0) {
            return;
        }
        double requiredPower = PowerUtils.getCachedPower(this.cachedSpeed, this.cachedEnergyCardCount) * ConfigParsingUtils.getMultiplierForBlock(blockId);
        if (!this.extractPower(requiredPower)) {
            return;
        }
        this.performTicks(blockEntity, ticker, this.cachedSpeed);
    }

    private boolean isValidForTicking() {
        return this.getGridNode() != null && this.getMainNode() != null && this.getMainNode().getGrid() != null;
    }

    private void updateCachedTarget() {
        BlockPos targetPos = this.getBlockEntity().m_58899_().m_121945_(this.getSide());
        if (!targetPos.equals((Object)this.cachedTargetPos) || this.cachedTarget == null || this.cachedTarget.m_58901_() || this.cachedTarget.m_58903_() != this.getLevel().m_7702_(targetPos).m_58903_()) {
            this.cachedTargetPos = targetPos;
            this.cachedTarget = this.getLevel().m_7702_(targetPos);
        }
    }

    private <T extends BlockEntity> BlockEntityTicker<T> getTicker(T blockEntity) {
        return this.getLevel().m_8055_(blockEntity.m_58899_()).m_155944_(this.getLevel(), blockEntity.m_58903_());
    }

    private int calculateSpeed() {
        int entitySpeedCardCount = this.getUpgrades().getInstalledUpgrades((ItemLike)ModItems.ENTITY_SPEED_CARD.get());
        if (entitySpeedCardCount <= 0) {
            return 0;
        }
        return PowerUtils.computeProductWithCap(this.getUpgrades(), 8);
    }

    private boolean extractPower(double requiredPower) {
        IEnergyService energyService = this.getMainNode().getGrid().getEnergyService();
        MEStorage storage = this.getMainNode().getGrid().getStorageService().getInventory();
        IActionSource source = IActionSource.ofMachine((IActionHost)this);
        boolean preferDiskEnergy = ModConfig.INSTANCE.prioritizeDiskEnergy;
        if (preferDiskEnergy && this.tryExtractFE(energyService, storage, requiredPower, source)) {
            return true;
        }
        double simulated = energyService.extractAEPower(requiredPower, Actionable.SIMULATE, PowerMultiplier.CONFIG);
        if (simulated >= requiredPower) {
            double extracted = energyService.extractAEPower(requiredPower, Actionable.MODULATE, PowerMultiplier.CONFIG);
            boolean sufficient = extracted >= requiredPower;
            this.setNetworkEnergySufficient(sufficient);
            return sufficient;
        }
        this.setNetworkEnergySufficient(false);
        if (!preferDiskEnergy) {
            return this.tryExtractFE(energyService, storage, requiredPower, source);
        }
        return false;
    }

    private boolean tryExtractFE(IEnergyService energyService, MEStorage storage, double requiredPower, IActionSource source) {
        if (FE_UNAVAILABLE || cachedFEExtractHandle == null) {
            this.setNetworkEnergySufficient(false);
            return false;
        }
        try {
            long feRequired = (long)requiredPower << 1;
            long feExtracted = cachedFEExtractHandle.invokeExact(null, energyService, storage, feRequired, source);
            if (feExtracted >= feRequired) {
                this.setNetworkEnergySufficient(true);
                return true;
            }
        }
        catch (Throwable e) {
            FE_UNAVAILABLE = true;
        }
        this.setNetworkEnergySufficient(false);
        return false;
    }

    private <T extends BlockEntity> void performTicks(T blockEntity, BlockEntityTicker<T> ticker, int speed) {
        for (int i = 0; i < speed - 1; ++i) {
            try {
                ticker.m_155252_(blockEntity.m_58904_(), blockEntity.m_58899_(), blockEntity.m_58900_(), blockEntity);
                continue;
            }
            catch (IllegalStateException e) {
                if (e.getMessage() != null && e.getMessage().contains("LegacyRandomSource")) {
                    Logger.EAP$LOGGER.warn("\u68c0\u6d4b\u5230\u65b9\u5757\u5b9e\u4f53 {} \u5728\u4f4d\u7f6e {} \u7684\u968f\u673a\u6570\u8bbf\u95ee\u51b2\u7a81\uff0c\u5df2\u505c\u6b62\u672c\u6b21\u52a0\u901f\u4ee5\u907f\u514d\u5d29\u6e83\u3002\u5efa\u8bae\u5c06\u6b64\u65b9\u5757\u7c7b\u578b\u6dfb\u52a0\u5230\u914d\u7f6e\u9ed1\u540d\u5355\u4e2d\u3002", (Object)blockEntity.m_58903_().toString(), (Object)blockEntity.m_58899_());
                    break;
                }
                throw e;
            }
            catch (Exception e) {
                Logger.EAP$LOGGER.error("\u5728\u52a0\u901f\u65b9\u5757\u5b9e\u4f53 {} \u4f4d\u7f6e {} \u65f6\u53d1\u751f\u9519\u8bef: {}", new Object[]{blockEntity.m_58903_().toString(), blockEntity.m_58899_(), e.getMessage(), e});
                break;
            }
        }
    }

    public boolean m_8077_() {
        return super.m_8077_();
    }

    @NotNull
    public Component m_5446_() {
        return super.m_5446_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new EntitySpeedTickerMenu(containerId, playerInventory, this);
    }

    protected int getUpgradeSlots() {
        return 8;
    }

    public void removeFromWorld() {
        super.removeFromWorld();
        this.cachedTarget = null;
        this.cachedTargetPos = null;
        if (this.wirelessLink != null) {
            this.wirelessLink.onUnloadOrRemove();
            this.wirelessLink = null;
        }
    }

    private boolean getRedstoneState() {
        this.updateRedstoneState();
        return this.redstoneState == YesNo.YES;
    }

    private void updateRedstoneState() {
        BlockEntity be = this.getHost().getBlockEntity();
        if (be != null && be.m_58904_() != null) {
            this.redstoneState = be.m_58904_().m_276867_(be.m_58899_()) ? YesNo.YES : YesNo.NO;
        }
    }

    private void handleWirelessLogic() {
        if (!this.isServerEnvironmentReady()) {
            return;
        }
        if (this.wirelessPendingInit) {
            this.initializeWirelessLink();
        } else {
            this.eap$updateWirelessLink();
        }
    }

    private boolean isServerEnvironmentReady() {
        BlockEntity be = this.getBlockEntity();
        return be != null && be.m_58904_() != null && !be.m_58904_().m_5776_();
    }

    private void scheduleWirelessInit() {
        this.wirelessPendingInit = true;
    }

    private void resetWirelessState() {
        this.lastChannelFrequency = -1L;
        this.lastChannelOwner = null;
        this.scheduleWirelessInit();
    }

    private void initializeWirelessLink() {
        if (!this.isServerEnvironmentReady()) {
            return;
        }
        this.wirelessPendingInit = false;
        try {
            IUpgradeInventory upgrades = this.getUpgrades();
            long channel = 0L;
            UUID ownerUUID = null;
            boolean found = false;
            for (ItemStack stack : upgrades) {
                if (stack.m_41619_() || stack.m_41720_() != ModItems.CHANNEL_CARD.get()) continue;
                channel = ChannelCardItem.getChannel(stack);
                ownerUUID = ChannelCardItem.getOwnerUUID(stack);
                found = true;
                break;
            }
            if (!found) {
                this.disconnectWirelessLink();
                return;
            }
            if (this.wirelessLink == null) {
                GenericNodeEndpointImpl endpoint = new GenericNodeEndpointImpl(() -> {
                    IPartHost host = this.getHost();
                    return host != null ? host.getBlockEntity() : null;
                }, () -> ((EntitySpeedTickerPart)this).getActionableNode());
                this.wirelessLink = new WirelessSlaveLink(endpoint);
                Logger.EAP$LOGGER.debug("[\u670d\u52a1\u7aef] EntitySpeedTicker \u521b\u5efa\u65e0\u7ebf\u94fe\u63a5");
            }
            boolean changed = this.lastChannelFrequency != channel || !Objects.equals(this.lastChannelOwner, ownerUUID);
            this.wirelessLink.setPlacerId(ownerUUID);
            this.wirelessLink.setFrequency(channel);
            this.wirelessLink.updateStatus();
            this.lastChannelFrequency = channel;
            this.lastChannelOwner = ownerUUID;
            if (changed) {
                this.markPartForUpdate();
                Logger.EAP$LOGGER.debug("[\u670d\u52a1\u7aef] EntitySpeedTicker \u8bbe\u7f6e\u9891\u9053: {}, connected={}", (Object)channel, (Object)this.wirelessLink.isConnected());
            }
        }
        catch (Exception e) {
            Logger.EAP$LOGGER.error("[\u670d\u52a1\u7aef] EntitySpeedTicker \u521d\u59cb\u5316\u9891\u9053\u94fe\u63a5\u5931\u8d25", (Throwable)e);
        }
    }

    private void disconnectWirelessLink() {
        this.lastChannelFrequency = 0L;
        this.lastChannelOwner = null;
        if (this.wirelessLink != null) {
            this.wirelessLink.setFrequency(0L);
            this.wirelessLink.updateStatus();
        }
        this.markPartForUpdate();
    }

    private void markPartForUpdate() {
        IPartHost host = this.getHost();
        if (host != null) {
            host.markForUpdate();
        }
    }

    @Override
    public void eap$updateWirelessLink() {
        if (this.wirelessLink != null && this.isServerEnvironmentReady()) {
            this.wirelessLink.updateStatus();
        }
    }

    @Override
    public boolean eap$isWirelessConnected() {
        if (this.isClientSide()) {
            return this.wirelessClientConnected;
        }
        return this.wirelessLink != null && this.wirelessLink.isConnected();
    }

    @Override
    public void eap$setClientWirelessState(boolean connected) {
        this.wirelessClientConnected = connected;
    }

    @Override
    public boolean eap$hasTickInitialized() {
        return !this.wirelessPendingInit;
    }

    @Override
    public void eap$setTickInitialized(boolean initialized) {
        this.wirelessPendingInit = !initialized;
    }

    @Override
    public void eap$initializeChannelLink() {
        this.scheduleWirelessInit();
    }

    @Override
    public void eap$handleDelayedInit() {
        this.handleWirelessLogic();
    }

    static {
        if (ModCheckUtils.isAppfluxLoading()) {
            try {
                Class<?> helperClass = Class.forName("com.extendedae_plus.util.entitySpeed.FluxEnergyHelper");
                Method method = helperClass.getMethod("extractFE", IEnergyService.class, MEStorage.class, Long.TYPE, IActionSource.class);
                cachedFEExtractHandle = MethodHandles.lookup().unreflect(method);
                FE_UNAVAILABLE = false;
            }
            catch (Exception e) {
                FE_UNAVAILABLE = true;
                cachedFEExtractHandle = null;
            }
        }
    }
}

