/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.client.screen;

import com.extendedae_plus.init.ModNetwork;
import com.extendedae_plus.network.UploadEncodedPatternToProviderC2SPacket;
import com.extendedae_plus.util.GlobalSendMessage;
import com.extendedae_plus.util.uploadPattern.RecipeTypeNameConfig;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ProviderSelectScreen
extends Screen {
    private final Screen parent;
    private final List<Long> ids;
    private final List<String> names;
    private final List<Integer> emptySlots;
    private final List<Long> gIds = new ArrayList<Long>();
    private final List<String> gNames = new ArrayList<String>();
    private final List<Integer> gTotalSlots = new ArrayList<Integer>();
    private final List<Integer> gCount = new ArrayList<Integer>();
    private final List<Long> fIds = new ArrayList<Long>();
    private final List<String> fNames = new ArrayList<String>();
    private final List<Integer> fTotalSlots = new ArrayList<Integer>();
    private final List<Integer> fCount = new ArrayList<Integer>();
    private EditBox searchBox;
    private EditBox cnInput;
    private String query = "";
    private Button prevButton;
    private Button nextButton;
    private int page = 0;
    private static final int PAGE_SIZE = 6;
    private final List<Button> entryButtons = new ArrayList<Button>();
    private final int[] buttonIndexMap = new int[6];
    private static final Map<String, String> componentCache = new HashMap<String, String>();
    private String lastLanguage = "";
    private static Boolean JEC_AVAILABLE = null;
    private static Method JEC_CONTAINS = null;
    private static final Pattern NATURAL_PATTERN = Pattern.compile("(\\D*)(\\d*)");

    public ProviderSelectScreen(Screen parent, List<Long> ids, List<String> names, List<Integer> emptySlots) {
        super((Component)Component.m_237115_((String)"extendedae_plus.screen.choose_provider.title"));
        this.parent = parent;
        this.ids = ids;
        this.names = names;
        this.emptySlots = emptySlots;
        try {
            String recent = RecipeTypeNameConfig.lastProcessingName;
            if (recent != null && !recent.isBlank()) {
                this.query = recent;
                RecipeTypeNameConfig.lastProcessingName = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.buildGroups();
        this.applyFilter();
    }

    protected void m_7856_() {
        this.m_169413_();
        this.entryButtons.clear();
        int centerX = this.f_96543_ / 2;
        int startY = this.f_96544_ / 2 - 70;
        if (this.searchBox == null) {
            this.searchBox = new EditBox(this.f_96547_, centerX - 120, startY - 25, 240, 18, (Component)Component.m_237115_((String)"extendedae_plus.screen.search"));
        } else {
            this.searchBox.m_252865_(centerX - 120);
            this.searchBox.m_253211_(startY - 25);
            this.searchBox.m_93674_(240);
        }
        this.searchBox.m_94144_(this.query);
        this.searchBox.m_94151_(text -> {
            if (Objects.equals(text, this.query)) {
                return;
            }
            this.query = text;
            this.page = 0;
            this.applyFilter();
            this.refreshButtons();
        });
        this.m_142416_((GuiEventListener)this.searchBox);
        int buttonWidth = 240;
        int buttonHeight = 20;
        int gap = 5;
        for (int i = 0; i < 6; ++i) {
            int btnIdx = i;
            Button btn = Button.m_253074_((Component)Component.m_237113_((String)""), b -> {
                int actualIdx = this.buttonIndexMap[btnIdx];
                if (actualIdx >= 0 && actualIdx < this.fIds.size()) {
                    this.onChoose(actualIdx);
                }
            }).m_252987_(centerX - buttonWidth / 2, startY + i * (buttonHeight + gap), buttonWidth, buttonHeight).m_253136_();
            this.entryButtons.add(btn);
            this.buttonIndexMap[i] = -1;
            this.m_142416_((GuiEventListener)btn);
        }
        int navY = startY + 6 * (buttonHeight + gap) + 10;
        this.prevButton = Button.m_253074_((Component)Component.m_237113_((String)"<"), b -> this.changePage(-1)).m_252987_(centerX - 60, navY, 20, 20).m_253136_();
        this.nextButton = Button.m_253074_((Component)Component.m_237113_((String)">"), b -> this.changePage(1)).m_252987_(centerX + 40, navY, 20, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.prevButton);
        this.m_142416_((GuiEventListener)this.nextButton);
        int btnWidth2 = 80;
        int inputWidth = 120;
        int btnGap = 5;
        int totalWidth = btnWidth2 + btnGap + inputWidth + btnGap + btnWidth2 * 2 + btnGap + btnWidth2;
        int startX = centerX - totalWidth / 2;
        Button reload = Button.m_253074_((Component)Component.m_237115_((String)"extendedae_plus.screen.reload_mapping"), b -> this.reloadMapping()).m_252987_(startX, navY + 30, btnWidth2, 20).m_253136_();
        this.m_142416_((GuiEventListener)reload);
        if (this.cnInput == null) {
            this.cnInput = new EditBox(this.f_96547_, startX + btnWidth2 + btnGap, navY + 30, inputWidth, 20, (Component)Component.m_237115_((String)"extendedae_plus.screen.upload.name"));
        } else {
            this.cnInput.m_252865_(startX + btnWidth2 + btnGap);
            this.cnInput.m_253211_(navY + 30);
            this.cnInput.m_93674_(inputWidth);
        }
        this.m_142416_((GuiEventListener)this.cnInput);
        Button close = Button.m_253074_((Component)Component.m_237115_((String)"gui.cancel"), b -> this.m_7379_()).m_252987_(startX + btnWidth2 + btnGap + inputWidth + btnGap, navY + 30, btnWidth2, 20).m_253136_();
        this.m_142416_((GuiEventListener)close);
        Button addMap = Button.m_253074_((Component)Component.m_237115_((String)"extendedae_plus.screen.add_mapping"), b -> this.addMappingFromUI()).m_252987_(startX + btnWidth2 + btnGap + inputWidth + btnGap + btnWidth2 + btnGap, navY + 30, btnWidth2, 20).m_253136_();
        this.m_142416_((GuiEventListener)addMap);
        Button delByCn = Button.m_253074_((Component)Component.m_237115_((String)"extendedae_plus.screen.delete_mapping"), b -> this.deleteMappingByCnFromUI()).m_252987_(startX + btnWidth2 + btnGap + inputWidth + btnGap + btnWidth2 * 2 + btnGap * 2, navY + 30, btnWidth2, 20).m_253136_();
        this.m_142416_((GuiEventListener)delByCn);
        this.refreshButtons();
    }

    private void changePage(int delta) {
        int newPage = this.page + delta;
        if (newPage < 0 || newPage * 6 >= this.fIds.size()) {
            return;
        }
        this.page = newPage;
        this.refreshButtons();
    }

    private void refreshButtons() {
        int start = this.page * 6;
        int end = Math.min(start + 6, this.fIds.size());
        for (int i = 0; i < 6; ++i) {
            Button btn = this.entryButtons.get(i);
            int idx = start + i;
            if (idx < end) {
                btn.f_93624_ = true;
                btn.f_93623_ = true;
                btn.m_93666_((Component)Component.m_237113_((String)this.buildLabel(idx)));
                this.buttonIndexMap[i] = idx;
                continue;
            }
            btn.f_93624_ = false;
            btn.f_93623_ = false;
            this.buttonIndexMap[i] = -1;
        }
        if (this.prevButton != null) {
            boolean bl = this.prevButton.f_93623_ = this.page > 0;
        }
        if (this.nextButton != null) {
            this.nextButton.f_93623_ = this.fIds.size() > (this.page + 1) * 6;
        }
    }

    private void reloadMapping() {
        try {
            RecipeTypeNameConfig.loadRecipeTypeNames();
            GlobalSendMessage.sendPlayerMessage((Component)Component.m_237115_((String)"extendedae_plus.screen.reload_mapping_success"));
        }
        catch (Throwable t) {
            GlobalSendMessage.sendPlayerMessage((Component)Component.m_237110_((String)"extendedae_plus.screen.reload_mapping_fail", (Object[])new Object[]{t.getClass().getSimpleName()}));
        }
    }

    private String deserializeComponentName(String name) {
        return componentCache.computeIfAbsent(name, k -> {
            try {
                MutableComponent component;
                if ((name.startsWith("{") || name.startsWith("\"")) && (component = Component.Serializer.m_130701_((String)name)) != null) {
                    return component.getString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return name;
        });
    }

    private String buildLabel(int idx) {
        String name = this.fNames.get(idx);
        int totalSlots = this.fTotalSlots.get(idx);
        int count = this.fCount.get(idx);
        return name + "  (" + totalSlots + ")  x" + count;
    }

    private void onChoose(int idx) {
        if (idx < 0 || idx >= this.fIds.size()) {
            return;
        }
        long providerId = this.fIds.get(idx);
        ModNetwork.CHANNEL.sendToServer((Object)new UploadEncodedPatternToProviderC2SPacket(providerId));
        this.m_7379_();
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }

    private void buildGroups() {
        LinkedHashMap<String, Group> map = new LinkedHashMap<String, Group>();
        for (int i = 0; i < this.names.size(); ++i) {
            String name = this.names.get(i);
            long id = this.ids.get(i);
            int slots = this.emptySlots.get(i);
            String groupKey = this.deserializeComponentName(name);
            map.compute(groupKey, (k, g) -> {
                if (g == null) {
                    return new Group(id, slots);
                }
                g.merge(id, slots);
                return g;
            });
        }
        for (Map.Entry e : map.entrySet()) {
            String name = (String)e.getKey();
            Group g2 = (Group)e.getValue();
            this.gNames.add(name);
            this.gIds.add(g2.bestId);
            this.gTotalSlots.add(g2.totalSlots);
            this.gCount.add(g2.count);
        }
    }

    private void applyFilter() {
        int i;
        this.fIds.clear();
        this.fNames.clear();
        this.fTotalSlots.clear();
        this.fCount.clear();
        String q = this.query == null ? "" : this.query.trim();
        String qLower = q.toLowerCase(Locale.ROOT);
        for (i = 0; i < this.gIds.size(); ++i) {
            String name = this.gNames.get(i);
            if (!q.isEmpty() && !ProviderSelectScreen.nameMatches(name, q, qLower)) continue;
            this.fIds.add(this.gIds.get(i));
            this.fNames.add(name);
            this.fTotalSlots.add(this.gTotalSlots.get(i));
            this.fCount.add(this.gCount.get(i));
        }
        if (!q.isEmpty() && this.fIds.isEmpty()) {
            for (i = 0; i < this.gIds.size(); ++i) {
                this.fIds.add(this.gIds.get(i));
                this.fNames.add(this.gNames.get(i));
                this.fTotalSlots.add(this.gTotalSlots.get(i));
                this.fCount.add(this.gCount.get(i));
            }
        }
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i3 = 0; i3 < this.fNames.size(); ++i3) {
            indices.add(i3);
        }
        indices.sort((i1, i2) -> ProviderSelectScreen.compareNatural(this.fNames.get((int)i1), this.fNames.get((int)i2)));
        ArrayList<Long> sortedIds = new ArrayList<Long>();
        ArrayList<String> sortedNames = new ArrayList<String>();
        ArrayList<Integer> sortedSlots = new ArrayList<Integer>();
        ArrayList<Integer> sortedCount = new ArrayList<Integer>();
        Iterator iterator = indices.iterator();
        while (iterator.hasNext()) {
            int idx = (Integer)iterator.next();
            sortedIds.add(this.fIds.get(idx));
            sortedNames.add(this.fNames.get(idx));
            sortedSlots.add(this.fTotalSlots.get(idx));
            sortedCount.add(this.fCount.get(idx));
        }
        this.fIds.clear();
        this.fIds.addAll(sortedIds);
        this.fNames.clear();
        this.fNames.addAll(sortedNames);
        this.fTotalSlots.clear();
        this.fTotalSlots.addAll(sortedSlots);
        this.fCount.clear();
        this.fCount.addAll(sortedCount);
    }

    private static boolean nameMatches(String name, String key, String keyLower) {
        if (name == null) {
            return false;
        }
        if (key == null || key.isEmpty()) {
            return true;
        }
        try {
            if (JEC_AVAILABLE == null) {
                try {
                    Class<?> cls = Class.forName("me.towdium.jecharacters.utils.Match");
                    JEC_CONTAINS = cls.getMethod("contains", CharSequence.class, CharSequence.class);
                    JEC_AVAILABLE = true;
                }
                catch (Throwable t) {
                    JEC_AVAILABLE = false;
                }
            }
            if (Boolean.TRUE.equals(JEC_AVAILABLE) && JEC_CONTAINS != null) {
                Object r = JEC_CONTAINS.invoke(null, name, key);
                if (r instanceof Boolean && ((Boolean)r).booleanValue()) {
                    return true;
                }
                Object r2 = JEC_CONTAINS.invoke(null, name.toLowerCase(Locale.ROOT), keyLower);
                if (r2 instanceof Boolean && ((Boolean)r2).booleanValue()) {
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return name.toLowerCase(Locale.ROOT).contains(keyLower);
    }

    private static int compareNatural(String s1, String s2) {
        Matcher m1 = NATURAL_PATTERN.matcher(s1);
        Matcher m2 = NATURAL_PATTERN.matcher(s2);
        while (m1.find() && m2.find()) {
            int n2;
            int n1;
            int cmp = m1.group(1).compareTo(m2.group(1));
            if (cmp != 0) {
                return cmp;
            }
            String num1 = m1.group(2);
            String num2 = m2.group(2);
            if (num1.isEmpty() && num2.isEmpty() || (n1 = num1.isEmpty() ? 0 : Integer.parseInt(num1)) == (n2 = num2.isEmpty() ? 0 : Integer.parseInt(num2))) continue;
            return Integer.compare(n1, n2);
        }
        return s1.length() - s2.length();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox != null && this.searchBox.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.searchBox != null && this.searchBox.m_5534_(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 1 && this.searchBox != null) {
            int x = this.searchBox.m_252754_();
            int y = this.searchBox.m_252907_();
            int w = this.searchBox.m_5711_();
            int h = this.searchBox.m_93694_();
            if (mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h)) {
                if (!this.searchBox.m_94155_().isEmpty()) {
                    this.searchBox.m_94144_("");
                }
                this.query = "";
                this.page = 0;
                this.applyFilter();
                this.refreshButtons();
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_86600_() {
        String currentLang;
        super.m_86600_();
        if (this.searchBox != null) {
            this.searchBox.m_94120_();
        }
        if (this.cnInput != null) {
            this.cnInput.m_94120_();
        }
        if (!(currentLang = Minecraft.m_91087_().f_91066_.f_92075_).equals(this.lastLanguage)) {
            this.lastLanguage = currentLang;
            componentCache.clear();
            this.refreshButtons();
        }
    }

    private void addMappingFromUI() {
        String val;
        String key = this.query == null ? "" : this.query.trim();
        String string = val = this.cnInput == null ? "" : this.cnInput.m_94155_().trim();
        if (key.isEmpty()) {
            GlobalSendMessage.sendPlayerMessage((Component)Component.m_237115_((String)"extendedae_plus.screen.upload.enter_search_key"));
            return;
        }
        if (val.isEmpty()) {
            GlobalSendMessage.sendPlayerMessage((Component)Component.m_237115_((String)"extendedae_plus.screen.upload.enter_cn_name"));
            return;
        }
        boolean ok = RecipeTypeNameConfig.addOrUpdateAliasMapping(key, val);
        if (ok) {
            GlobalSendMessage.sendPlayerMessage((Component)Component.m_237110_((String)"extendedae_plus.screen.upload.mapping_added", (Object[])new Object[]{key, val}));
            this.query = val;
            if (this.searchBox != null) {
                this.searchBox.m_94144_(val);
            }
            this.applyFilter();
            this.page = 0;
            this.refreshButtons();
        } else {
            GlobalSendMessage.sendPlayerMessage((Component)Component.m_237115_((String)"extendedae_plus.screen.upload.mapping_failed"));
        }
    }

    private void deleteMappingByCnFromUI() {
        String val;
        String string = val = this.cnInput == null ? "" : this.cnInput.m_94155_().trim();
        if (val.isEmpty()) {
            GlobalSendMessage.sendPlayerMessage((Component)Component.m_237115_((String)"extendedae_plus.screen.upload.enter_cn_name_delete"));
            return;
        }
        int removed = RecipeTypeNameConfig.removeMappingsByCnValue(val);
        if (removed > 0) {
            GlobalSendMessage.sendPlayerMessage((Component)Component.m_237110_((String)"extendedae_plus.screen.upload.mapping_deleted", (Object[])new Object[]{removed, val}));
            this.applyFilter();
            this.page = 0;
            this.refreshButtons();
        } else {
            GlobalSendMessage.sendPlayerMessage((Component)Component.m_237110_((String)"extendedae_plus.screen.upload.mapping_not_found", (Object[])new Object[]{val}));
        }
    }

    private static class Group {
        long bestId;
        int bestSlots;
        int totalSlots;
        int count;

        Group(long id, int slots) {
            this.bestId = id;
            this.bestSlots = slots;
            this.totalSlots = Math.max(0, slots);
            this.count = 1;
        }

        void merge(long id, int slots) {
            ++this.count;
            this.totalSlots += Math.max(0, slots);
            if (slots > this.bestSlots) {
                this.bestSlots = slots;
                this.bestId = id;
            }
        }
    }
}

