/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.content.matrix;

import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.KeyCounter;
import appeng.blockentity.crafting.IMolecularAssemblerSupportedPattern;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.AEItemFilters;
import appeng.util.inv.filter.IAEItemFilter;
import com.extendedae_plus.init.ModBlockEntities;
import com.glodblock.github.extendedae.common.EPPItemAndBlock;
import com.glodblock.github.extendedae.common.me.matrix.ClusterAssemblerMatrix;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixPattern;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PatternCorePlusBlockEntity
extends TileAssemblerMatrixPattern {
    public static final int INV_SIZE = 72;
    private final AppEngInternalInventory patternInventory;
    private final FilteredInternalInventory exposedInventory;
    private final List<IPatternDetails> patterns = new ArrayList<IPatternDetails>();
    private final BlockEntityType<?> overriddenType = (BlockEntityType)ModBlockEntities.ASSEMBLER_MATRIX_PATTERN_PLUS_BE.get();

    public PatternCorePlusBlockEntity(BlockPos pos, BlockState blockState) {
        super(pos, blockState);
        this.patternInventory = new AppEngInternalInventory((InternalInventoryHost)this, 72, 1);
        this.patternInventory.setFilter((IAEItemFilter)new Filter(() -> ((PatternCorePlusBlockEntity)this).m_58904_()));
        this.exposedInventory = new FilteredInternalInventory((InternalInventory)this.patternInventory, AEItemFilters.INSERT_ONLY);
        this.getMainNode().addService(ICraftingProvider.class, (IGridNodeService)this);
    }

    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        this.patternInventory.writeToNBT(data, "pattern");
    }

    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.patternInventory.readFromNBT(data, "pattern");
    }

    public AppEngInternalInventory getPatternInventory() {
        return this.patternInventory;
    }

    public FilteredInternalInventory getExposedInventory() {
        return this.exposedInventory;
    }

    public long getLocateID() {
        return this.f_58858_.m_121878_();
    }

    public void updatePatterns() {
        this.patterns.clear();
        for (ItemStack stack : this.patternInventory) {
            IPatternDetails details = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)this.m_58904_());
            if (details == null) continue;
            this.patterns.add(details);
        }
        ICraftingProvider.requestUpdate((IManagedGridNode)this.getMainNode());
    }

    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (ItemStack pattern : this.patternInventory) {
            drops.add(pattern);
        }
    }

    public void m_6211_() {
        super.m_6211_();
        this.patternInventory.clear();
    }

    public void add(ClusterAssemblerMatrix c) {
        c.addPattern((TileAssemblerMatrixPattern)this);
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        this.saveChanges();
        this.updatePatterns();
    }

    public void onReady() {
        super.onReady();
        this.updatePatterns();
    }

    public List<IPatternDetails> getAvailablePatterns() {
        return this.patterns;
    }

    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        if (!(this.isFormed() && this.getMainNode().isActive() && this.patterns.contains(patternDetails))) {
            return false;
        }
        return this.cluster.pushCraftingJob(patternDetails, inputHolder);
    }

    public boolean isBusy() {
        return this.cluster == null || this.cluster.isBusy();
    }

    @Nullable
    public IGrid getGrid() {
        return this.getMainNode().getGrid();
    }

    public InternalInventory getTerminalPatternInventory() {
        return this.patternInventory;
    }

    public boolean isVisibleInTerminal() {
        return this.manager.getSetting(Settings.PATTERN_ACCESS_TERMINAL) == YesNo.YES;
    }

    public PatternContainerGroup getTerminalGroup() {
        AEItemKey icon = AEItemKey.of((ItemLike)EPPItemAndBlock.ASSEMBLER_MATRIX_PATTERN);
        return new PatternContainerGroup(icon, icon.getDisplayName(), List.of(Component.m_237115_((String)"gui.expatternprovider.assembler_matrix.pattern")));
    }

    public BlockEntityType<?> m_58903_() {
        return this.overriddenType;
    }

    public record Filter(Supplier<Level> world) implements IAEItemFilter
    {
        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            if (stack.m_41720_() instanceof EncodedPatternItem) {
                return PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)this.world.get()) instanceof IMolecularAssemblerSupportedPattern;
            }
            return false;
        }
    }
}

