/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.hooks;

import appeng.block.crafting.CraftingUnitBlock;
import appeng.util.InteractionUtil;
import com.extendedae_plus.client.screen.FrequencyInputScreen;
import com.extendedae_plus.content.wireless.WirelessTransceiverBlockEntity;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="extendedae_plus")
public final class WrenchHook {
    private WrenchHook() {
    }

    @SubscribeEvent
    public static void onPlayerUseBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        BlockEntity be;
        if (event.getUseBlock() == Event.Result.DENY) {
            return;
        }
        Player player = event.getEntity();
        Level level = event.getLevel();
        InteractionHand hand = event.getHand();
        BlockHitResult hit = event.getHitVec();
        if (player.m_5833_() || hand != InteractionHand.MAIN_HAND) {
            return;
        }
        ItemStack stack = player.m_21120_(hand);
        if (InteractionUtil.isInAlternateUseMode((Player)player) && InteractionUtil.canWrenchDisassemble((ItemStack)stack)) {
            BlockEntity be2 = level.m_7702_(hit.m_82425_());
            if (be2 instanceof WirelessTransceiverBlockEntity) {
                WirelessTransceiverBlockEntity te = (WirelessTransceiverBlockEntity)be2;
                BlockPos pos = hit.m_82425_();
                BlockState state = level.m_8055_(pos);
                Block block = state.m_60734_();
                if (!level.f_46443_) {
                    List drops = Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)te, (Entity)player, (ItemStack)stack);
                    for (ItemStack item : drops) {
                        player.m_150109_().m_150079_(item);
                    }
                }
                level.m_5594_(player, hit.m_82425_(), SoundEvents.f_12016_, SoundSource.BLOCKS, 0.7f, 1.0f);
                block.m_5707_(level, hit.m_82425_(), state, player);
                level.m_7471_(hit.m_82425_(), false);
                block.m_6786_((LevelAccessor)level, hit.m_82425_(), state);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
            } else {
                BlockPos pos = hit.m_82425_();
                BlockState state = level.m_8055_(pos);
                if (state.m_60734_() instanceof CraftingUnitBlock) {
                    if (!level.f_46443_) {
                        List drops = Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)level.m_7702_(pos), (Entity)player, (ItemStack)stack);
                        for (ItemStack item : drops) {
                            player.m_150109_().m_150079_(item);
                        }
                    }
                    level.m_5594_(player, hit.m_82425_(), SoundEvents.f_12016_, SoundSource.BLOCKS, 0.7f, 1.0f);
                    state.m_60734_().m_5707_(level, pos, state, player);
                    level.m_7471_(pos, false);
                    state.m_60734_().m_6786_((LevelAccessor)level, pos, state);
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
                }
            }
        } else if (!InteractionUtil.isInAlternateUseMode((Player)player) && InteractionUtil.canWrenchRotate((ItemStack)stack) && (be = level.m_7702_(hit.m_82425_())) instanceof WirelessTransceiverBlockEntity) {
            WirelessTransceiverBlockEntity te = (WirelessTransceiverBlockEntity)be;
            boolean newLocked = !te.isLocked();
            te.setLocked(newLocked);
            String translationKey = newLocked ? "extendedae_plus.chat.wireless_transceiver.locked_status" : "extendedae_plus.chat.wireless_transceiver.unlocked_status";
            player.m_5661_((Component)Component.m_237115_((String)translationKey), true);
            level.m_5594_(player, hit.m_82425_(), SoundEvents.f_12088_, SoundSource.BLOCKS, 0.5f, newLocked ? 0.6f : 0.9f);
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
        }
    }

    @SubscribeEvent
    public static void onPlayerLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        BlockEntity be;
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        if (player.m_5833_()) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (InteractionUtil.isInAlternateUseMode((Player)player) && InteractionUtil.canWrenchRotate((ItemStack)stack) && (be = level.m_7702_(pos)) instanceof WirelessTransceiverBlockEntity) {
            WirelessTransceiverBlockEntity te = (WirelessTransceiverBlockEntity)be;
            if (level.f_46443_) {
                WrenchHook.openFrequencyInputScreen(pos, te.getFrequency());
            }
            level.m_5594_(player, pos, (SoundEvent)SoundEvents.f_12490_.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void openFrequencyInputScreen(BlockPos pos, long currentFrequency) {
        Minecraft.m_91087_().m_91152_((Screen)new FrequencyInputScreen(pos, currentFrequency));
    }
}

