/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.mixin.ae2.menu;

import appeng.api.inventories.InternalInventory;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.core.definitions.AEItems;
import appeng.helpers.IPatternTerminalMenuHost;
import appeng.items.materials.MaterialItem;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.menu.slot.RestrictedInputSlot;
import com.extendedae_plus.mixin.ae2.accessor.MEStorageMenuAccessor;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PatternEncodingTermMenu.class})
public abstract class PatternEncodingTermMenuMixin {
    @Final
    @Shadow(remap=false)
    private RestrictedInputSlot blankPatternSlot;
    @Unique
    private boolean eap$blankAutoFilled = false;

    @Inject(method={"<init>(Lnet/minecraft/world/inventory/MenuType;ILnet/minecraft/world/entity/player/Inventory;Lappeng/helpers/IPatternTerminalMenuHost;Z)V"}, at={@At(value="TAIL")}, remap=false)
    private void eap$onCtor1(MenuType<?> menuType, int id, Inventory ip, IPatternTerminalMenuHost host, boolean bindInventory, CallbackInfo ci) {
        this.eap$tryAutoFill(ip, host, false);
    }

    @Inject(method={"<init>(ILnet/minecraft/world/entity/player/Inventory;Lappeng/helpers/IPatternTerminalMenuHost;)V"}, at={@At(value="TAIL")}, remap=false)
    private void eap$onCtor2(int id, Inventory ip, IPatternTerminalMenuHost host, CallbackInfo ci) {
        this.eap$tryAutoFill(ip, host, false);
    }

    @Inject(method={"broadcastChanges"}, at={@At(value="TAIL")})
    private void eap$onBroadcastChanges(CallbackInfo ci) {
        if (!this.eap$blankAutoFilled) {
            PatternEncodingTermMenu self = (PatternEncodingTermMenu)this;
            Player player = self.getPlayerInventory().f_35978_;
            if (!player.m_9236_().m_5776_()) {
                this.eap$tryAutoFill(self.getPlayerInventory(), (IPatternTerminalMenuHost)self.getTarget(), true);
            }
        }
    }

    @Unique
    private void eap$tryAutoFill(Inventory ip, IPatternTerminalMenuHost host, boolean markFilled) {
        try {
            PatternEncodingTermMenu self = (PatternEncodingTermMenu)this;
            Player player = ip.f_35978_;
            if (player.m_9236_().m_5776_()) {
                return;
            }
            MEStorageMenuAccessor accessor = (MEStorageMenuAccessor)self;
            MEStorage storage = accessor.getStorage();
            IEnergySource power = accessor.getPowerSource();
            if (storage == null || power == null || !accessor.getHasPower()) {
                return;
            }
            InternalInventory blankInv = host.getLogic().getBlankPatternInv();
            ItemStack current = blankInv.getStackInSlot(0);
            int limit = blankInv.getSlotLimit(0);
            int space = Math.min(Math.max(0, limit - current.m_41613_()), ((MaterialItem)AEItems.BLANK_PATTERN.m_5456_()).m_41459_());
            if (space <= 0) {
                if (markFilled) {
                    this.eap$blankAutoFilled = true;
                }
                return;
            }
            AEItemKey blankKey = AEItemKey.of((ItemLike)AEItems.BLANK_PATTERN.m_5456_());
            long extracted = StorageHelper.poweredExtraction((IEnergySource)power, (MEStorage)storage, (AEKey)blankKey, (long)space, (IActionSource)self.getActionSource());
            if (extracted <= 0L) {
                return;
            }
            int toInsert = (int)Math.min(extracted, (long)space);
            ItemStack slotStack = this.blankPatternSlot.m_7993_();
            if (slotStack.m_41619_()) {
                this.blankPatternSlot.m_5852_(AEItems.BLANK_PATTERN.stack(toInsert));
            } else {
                slotStack.m_41769_(toInsert);
                this.blankPatternSlot.m_5852_(slotStack);
            }
            long leftover = extracted - (long)toInsert;
            if (leftover > 0L) {
                StorageHelper.poweredInsert((IEnergySource)power, (MEStorage)storage, (AEKey)blankKey, (long)leftover, (IActionSource)self.getActionSource());
            }
            if (markFilled) {
                this.eap$blankAutoFilled = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

