/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.mixin.guideme;

import guideme.PageAnchor;
import guideme.compiler.PageCompiler;
import guideme.compiler.tags.ItemLinkCompiler;
import guideme.compiler.tags.MdxAttrs;
import guideme.document.LytErrorSink;
import guideme.document.flow.LytFlowContent;
import guideme.document.flow.LytFlowLink;
import guideme.document.flow.LytFlowParent;
import guideme.document.flow.LytTooltipSpan;
import guideme.document.interaction.GuideTooltip;
import guideme.document.interaction.ItemTooltip;
import guideme.indices.ItemIndex;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import guideme.libs.unist.UnistNode;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemLinkCompiler.class}, remap=false)
public abstract class ItemLinkCompilerMixin {
    @Inject(method={"compile"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCompile(PageCompiler compiler, LytFlowParent parent, MdxJsxElementFields el, CallbackInfo ci) {
        Pair<ResourceLocation, ItemStack> itemAndId = this.getRequiredItemStackAndId(compiler, (LytErrorSink)parent, el);
        if (itemAndId == null) {
            ci.cancel();
            return;
        }
        ResourceLocation id = (ResourceLocation)itemAndId.getLeft();
        ItemStack stack = (ItemStack)itemAndId.getRight();
        PageAnchor linksTo = (PageAnchor)((ItemIndex)compiler.getIndex(ItemIndex.class)).get((Object)id);
        if (linksTo == null && id.m_135827_().equals(compiler.getPageId().m_135827_())) {
            parent.append(compiler.createErrorFlowContent("No page found for item " + String.valueOf(id), (UnistNode)el));
            ci.cancel();
            return;
        }
        if (linksTo == null || linksTo.anchor() == null && compiler.getPageId().equals((Object)linksTo.pageId())) {
            LytTooltipSpan span = new LytTooltipSpan();
            span.modifyStyle(style -> style.italic(Boolean.valueOf(true)));
            span.appendComponent((FormattedText)stack.m_41786_());
            span.setTooltip((GuideTooltip)new ItemTooltip(stack));
            parent.append((LytFlowContent)span);
        } else {
            LytFlowLink link = new LytFlowLink();
            link.setClickCallback(screen -> screen.navigateTo(linksTo));
            link.appendComponent((FormattedText)stack.m_41786_());
            link.setTooltip((GuideTooltip)new ItemTooltip(stack));
            parent.append((LytFlowContent)link);
        }
        ci.cancel();
    }

    @Unique
    public Pair<ResourceLocation, ItemStack> getRequiredItemStackAndId(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el) {
        Pair itemAndId = MdxAttrs.getRequiredItemAndId((PageCompiler)compiler, (LytErrorSink)errorSink, (MdxJsxElementFields)el, (String)"id");
        if (itemAndId == null) {
            return null;
        }
        CompoundTag tag = MdxAttrs.getCompoundTag((PageCompiler)compiler, (LytErrorSink)errorSink, (MdxJsxElementFields)el, (String)"tag", null);
        ItemStack stack = new ItemStack((ItemLike)itemAndId.getRight());
        stack.m_41751_(tag);
        return Pair.of((Object)((ResourceLocation)itemAndId.getKey()), (Object)stack);
    }
}

