/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import com.glodblock.github.extendedae.client.render.EAEHighlightHandler;
import com.glodblock.github.extendedae.util.FCClientUtil;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class SetBlockHighlightS2CPacket {
    private final BlockPos pos;
    private final Direction face;
    private final ResourceLocation dim;
    private final long durationMillis;

    public SetBlockHighlightS2CPacket(BlockPos pos, Direction face, ResourceLocation dim, long durationMillis) {
        this.pos = pos;
        this.face = face;
        this.dim = dim;
        this.durationMillis = durationMillis;
    }

    public static void encode(SetBlockHighlightS2CPacket pkt, FriendlyByteBuf buf) {
        buf.m_130064_(pkt.pos);
        buf.writeBoolean(pkt.face != null);
        if (pkt.face != null) {
            buf.m_130068_((Enum)pkt.face);
        }
        buf.m_130085_(pkt.dim);
        buf.writeLong(pkt.durationMillis);
    }

    public static SetBlockHighlightS2CPacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        Direction face = null;
        if (buf.readBoolean()) {
            face = (Direction)buf.m_130066_(Direction.class);
        }
        ResourceLocation dim = buf.m_130281_();
        long dur = buf.readLong();
        return new SetBlockHighlightS2CPacket(pos, face, dim, dur);
    }

    public static void handle(SetBlockHighlightS2CPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            try {
                ResourceKey dimKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)msg.dim);
                long endTime = System.currentTimeMillis() + msg.durationMillis;
                if (msg.face == null) {
                    EAEHighlightHandler.highlight((BlockPos)msg.pos, (ResourceKey)dimKey, (long)endTime);
                } else {
                    AABB origin = new AABB(msg.pos);
                    switch (msg.face) {
                        case WEST: {
                            origin = FCClientUtil.rotor((AABB)origin, (Vec3)origin.m_82399_(), (Direction.Axis)Direction.Axis.Y, (float)1.5707964f);
                            break;
                        }
                        case SOUTH: {
                            origin = FCClientUtil.rotor((AABB)origin, (Vec3)origin.m_82399_(), (Direction.Axis)Direction.Axis.Y, (float)((float)Math.PI));
                            break;
                        }
                        case EAST: {
                            origin = FCClientUtil.rotor((AABB)origin, (Vec3)origin.m_82399_(), (Direction.Axis)Direction.Axis.Y, (float)-1.5707964f);
                            break;
                        }
                        case UP: {
                            origin = FCClientUtil.rotor((AABB)origin, (Vec3)origin.m_82399_(), (Direction.Axis)Direction.Axis.X, (float)-1.5707964f);
                            break;
                        }
                        case DOWN: {
                            origin = FCClientUtil.rotor((AABB)origin, (Vec3)origin.m_82399_(), (Direction.Axis)Direction.Axis.X, (float)1.5707964f);
                        }
                    }
                    EAEHighlightHandler.highlight((BlockPos)msg.pos, (Direction)msg.face, (ResourceKey)dimKey, (long)endTime, (AABB)origin);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        ctx.setPacketHandled(true);
    }
}

