/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util;

import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.helpers.patternprovider.PatternContainer;
import appeng.menu.implementations.PatternAccessTermMenu;
import appeng.menu.me.items.PatternEncodingTermMenu;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;

public final class PatternTerminalUtil {
    private PatternTerminalUtil() {
    }

    public static boolean isExtendedAETerminal(ServerPlayer player) {
        if (player == null || player.f_36096_ == null) {
            return false;
        }
        String containerClassName = player.f_36096_.getClass().getName();
        return containerClassName.equals("com.glodblock.github.extendedae.container.ContainerExPatternTerminal");
    }

    public static PatternContainer getPatternContainerById(PatternAccessTermMenu menu, long providerId) {
        try {
            Field byIdField = PatternTerminalUtil.findByIdField(menu.getClass());
            if (byIdField == null) {
                System.err.println("ExtendedAE Plus: \u65e0\u6cd5\u627e\u5230byId\u5b57\u6bb5");
                return null;
            }
            byIdField.setAccessible(true);
            Map byId = (Map)byIdField.get(menu);
            Object containerTracker = byId.get(providerId);
            if (containerTracker == null) {
                return null;
            }
            Field containerField = PatternTerminalUtil.findContainerField(containerTracker.getClass());
            if (containerField == null) {
                System.err.println("ExtendedAE Plus: \u65e0\u6cd5\u627e\u5230container\u5b57\u6bb5");
                return null;
            }
            containerField.setAccessible(true);
            return (PatternContainer)containerField.get(containerTracker);
        }
        catch (Exception e) {
            System.err.println("ExtendedAE Plus: \u65e0\u6cd5\u83b7\u53d6PatternContainer\uff0c\u9519\u8bef: " + e.getMessage());
            return null;
        }
    }

    public static Field findByIdField(Class<?> clazz) {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                return currentClass.getDeclaredField("byId");
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }

    private static Field findContainerField(Class<?> clazz) {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                return currentClass.getDeclaredField("container");
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }

    public static PatternAccessTermMenu getPatternAccessMenu(ServerPlayer player) {
        if (player == null || player.f_36096_ == null) {
            return null;
        }
        String containerClassName = player.f_36096_.getClass().getName();
        if (containerClassName.equals("com.glodblock.github.extendedae.container.ContainerExPatternTerminal")) {
            return (PatternAccessTermMenu)player.f_36096_;
        }
        if (player.f_36096_ instanceof PatternAccessTermMenu) {
            return (PatternAccessTermMenu)player.f_36096_;
        }
        return null;
    }

    public static List<Long> getAllProviderIds(PatternAccessTermMenu menu) {
        ArrayList<Long> result = new ArrayList<Long>();
        if (menu == null) {
            return result;
        }
        try {
            Field byIdField = PatternTerminalUtil.findByIdField(menu.getClass());
            if (byIdField == null) {
                return result;
            }
            byIdField.setAccessible(true);
            Map byId = (Map)byIdField.get(menu);
            if (byId != null) {
                result.addAll(byId.keySet());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public static List<PatternContainer> listAvailableProvidersFromGrid(PatternEncodingTermMenu menu) {
        ArrayList<PatternContainer> list = new ArrayList<PatternContainer>();
        if (menu == null) {
            return list;
        }
        try {
            IGridNode node = menu.getNetworkNode();
            if (node == null) {
                return list;
            }
            IGrid grid = node.getGrid();
            if (grid == null) {
                return list;
            }
            for (Class machineClass : grid.getMachineClasses()) {
                if (!PatternContainer.class.isAssignableFrom(machineClass)) continue;
                Class containerClass = machineClass;
                for (PatternContainer container : grid.getActiveMachines(containerClass)) {
                    InternalInventory inv;
                    if (container == null || !container.isVisibleInTerminal() || (inv = container.getTerminalPatternInventory()) == null || inv.size() <= 0) continue;
                    boolean hasEmpty = false;
                    for (int i = 0; i < inv.size(); ++i) {
                        if (!inv.getStackInSlot(i).m_41619_()) continue;
                        hasEmpty = true;
                        break;
                    }
                    if (!hasEmpty) continue;
                    list.add(container);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return list;
    }
}

