/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util.uploadPattern;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.core.definitions.AEItems;
import appeng.crafting.pattern.AECraftingPattern;
import appeng.crafting.pattern.AESmithingTablePattern;
import appeng.crafting.pattern.AEStonecuttingPattern;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.util.inv.FilteredInternalInventory;
import com.extendedae_plus.content.matrix.PatternCorePlusBlockEntity;
import com.extendedae_plus.content.matrix.UploadCoreBlockEntity;
import com.extendedae_plus.mixin.ae2.accessor.PatternEncodingTermMenuAccessor;
import com.extendedae_plus.util.GlobalSendMessage;
import com.glodblock.github.extendedae.common.me.matrix.ClusterAssemblerMatrix;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixPattern;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public final class MatrixUploadUtil {
    private MatrixUploadUtil() {
    }

    public static void uploadFromEncodingMenuToMatrix(ServerPlayer player, PatternEncodingTermMenu menu) {
        if (player == null || menu == null) {
            return;
        }
        RestrictedInputSlot encodedSlot = ((PatternEncodingTermMenuAccessor)menu).eap$getEncodedPatternSlot();
        ItemStack stack = encodedSlot.m_7993_();
        if (stack.m_41619_() || !PatternDetailsHelper.isEncodedPattern((ItemStack)stack)) {
            return;
        }
        IPatternDetails details = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)player.m_9236_());
        if (!(details instanceof AECraftingPattern || details instanceof AESmithingTablePattern || details instanceof AEStonecuttingPattern)) {
            return;
        }
        IGridNode node = menu.getNetworkNode();
        if (node == null) {
            return;
        }
        IGrid grid = node.getGrid();
        if (grid == null) {
            return;
        }
        int stackCount = stack.m_41613_();
        ItemStack toInsert = stack.m_41777_();
        List<InternalInventory> inventories = MatrixUploadUtil.findAllMatrixPatternInventories(grid);
        if (MatrixUploadUtil.matrixContainsPattern(inventories, stack)) {
            GlobalSendMessage.sendPlayerMessage((Player)player, (Component)Component.m_237115_((String)"extendedae_plus.upload_to_matrix.repetition"));
            MatrixUploadUtil.refundBlankPattern(player, menu, stackCount);
            encodedSlot.m_5852_(ItemStack.f_41583_);
            return;
        }
        for (InternalInventory inv : inventories) {
            ItemStack remain;
            if (inv == null || (remain = inv.addItems(toInsert)).m_41613_() >= stackCount) continue;
            MatrixUploadUtil.completeUploadSuccess(player, encodedSlot, stack, remain);
            return;
        }
    }

    private static List<InternalInventory> findAllMatrixPatternInventories(IGrid grid) {
        ArrayList<InternalInventory> result = new ArrayList<InternalInventory>();
        if (grid == null) {
            return result;
        }
        try {
            FilteredInternalInventory inv;
            ClusterAssemblerMatrix cluster;
            Set allTiles = grid.getMachines(TileAssemblerMatrixPattern.class);
            Set myAllTiles = grid.getMachines(PatternCorePlusBlockEntity.class);
            HashSet<ClusterAssemblerMatrix> scannedClusters = new HashSet<ClusterAssemblerMatrix>();
            for (TileAssemblerMatrixPattern tile : allTiles) {
                if (tile == null || !tile.isFormed() || !tile.getMainNode().isActive() || (cluster = tile.getCluster()) == null || !scannedClusters.contains(cluster) && !MatrixUploadUtil.clusterHasSingleUploadCore(cluster)) continue;
                scannedClusters.add(cluster);
                inv = tile.getExposedInventory();
                if (inv == null) continue;
                result.add((InternalInventory)inv);
            }
            for (PatternCorePlusBlockEntity myTile : myAllTiles) {
                if (myTile == null || !myTile.isFormed() || !myTile.getMainNode().isActive() || (cluster = myTile.getCluster()) == null || !scannedClusters.contains(cluster) && !MatrixUploadUtil.clusterHasSingleUploadCore(cluster)) continue;
                scannedClusters.add(cluster);
                inv = myTile.getExposedInventory();
                if (inv == null) continue;
                result.add((InternalInventory)inv);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    private static boolean matrixContainsPattern(@NotNull List<InternalInventory> inventories, @NotNull ItemStack pattern) {
        for (InternalInventory inv : inventories) {
            if (inv == null) continue;
            ItemStack patternCopy = pattern.m_41777_();
            if (patternCopy.m_41783_() != null) {
                patternCopy.m_41783_().m_128473_("encodePlayer");
            }
            for (int i = 0; i < inv.size(); ++i) {
                ItemStack s = inv.getStackInSlot(i);
                ItemStack sCopy = s.m_41777_();
                if (sCopy.m_41783_() != null) {
                    sCopy.m_41783_().m_128473_("encodePlayer");
                }
                if (s.m_41619_() || !ItemStack.m_150942_((ItemStack)sCopy, (ItemStack)patternCopy)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean clusterHasSingleUploadCore(@NotNull ClusterAssemblerMatrix cluster) {
        try {
            Iterator it = cluster.getBlockEntities();
            while (it.hasNext()) {
                if (!(it.next() instanceof UploadCoreBlockEntity)) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static void completeUploadSuccess(ServerPlayer player, RestrictedInputSlot encodedSlot, ItemStack stack, ItemStack remain) {
        int inserted = stack.m_41613_() - remain.m_41613_();
        if (inserted > 0) {
            stack.m_41774_(inserted);
            if (stack.m_41619_()) {
                encodedSlot.m_5852_(ItemStack.f_41583_);
            }
            GlobalSendMessage.sendPlayerMessage((Player)player, (Component)Component.m_237115_((String)"extendedae_plus.upload_to_matrix.success"));
        }
    }

    private static void refundBlankPattern(ServerPlayer player, PatternEncodingTermMenu menu, int count) {
        block6: {
            try {
                PatternEncodingTermMenuAccessor accessor = (PatternEncodingTermMenuAccessor)menu;
                RestrictedInputSlot blankSlot = accessor.eap$getBlankPatternSlot();
                ItemStack blanks = AEItems.BLANK_PATTERN.stack(count);
                if (blankSlot != null && blankSlot.m_5857_(blanks)) {
                    ItemStack remain = blankSlot.m_150659_(blanks);
                    if (!remain.m_41619_() && player != null) {
                        player.m_150109_().m_150076_(remain, false);
                    }
                } else if (player != null) {
                    player.m_150109_().m_150076_(blanks, false);
                }
            }
            catch (Throwable t) {
                if (player == null) break block6;
                player.m_150109_().m_150076_(AEItems.BLANK_PATTERN.stack(count), false);
            }
        }
    }
}

