/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util.uploadPattern;

import com.extendedae_plus.util.GlobalSendMessage;
import com.extendedae_plus.util.Logger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fml.loading.FMLPaths;

public final class RecipeTypeNameConfig {
    private static final String CONFIG_PATH = "extendedae_plus/recipe_type_names.json";
    private static final Map<ResourceLocation, String> CUSTOM_NAMES = new ConcurrentHashMap<ResourceLocation, String>();
    private static final Map<String, String> CUSTOM_ALIASES = new ConcurrentHashMap<String, String>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static volatile String lastProcessingName;

    private RecipeTypeNameConfig() {
    }

    public static void setLastProcessingName(String name) {
        lastProcessingName = name;
    }

    private static Map<String, String> getDefaultMappings() {
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("minecraft:smelting", "\u7194\u7089");
        mappings.put("minecraft:blasting", "\u9ad8\u7089");
        mappings.put("minecraft:smoking", "\u70df\u718f");
        mappings.put("minecraft:campfire_cooking", "\u8425\u706b");
        mappings.put("gtceu:assembler", "\u7ec4\u88c5\u673a");
        mappings.put("assembler", "\u7ec4\u88c5\u673a");
        return mappings;
    }

    private static JsonObject createDefaultTemplate() {
        JsonObject tmpl = new JsonObject();
        RecipeTypeNameConfig.getDefaultMappings().forEach((arg_0, arg_1) -> ((JsonObject)tmpl).addProperty(arg_0, arg_1));
        return tmpl;
    }

    private static JsonObject loadJsonConfig(Path cfgPath) throws IOException, JsonSyntaxException {
        if (!Files.exists(cfgPath, new LinkOption[0])) {
            return new JsonObject();
        }
        String json = Files.readString(cfgPath);
        JsonObject obj = (JsonObject)GSON.fromJson(json, JsonObject.class);
        return obj != null ? obj : new JsonObject();
    }

    private static void saveJsonConfig(Path cfgPath, JsonObject config) throws IOException {
        Files.createDirectories(cfgPath.getParent(), new FileAttribute[0]);
        Files.writeString(cfgPath, (CharSequence)GSON.toJson((JsonElement)config), new OpenOption[0]);
    }

    public static synchronized void loadRecipeTypeNames() throws IOException {
        Path cfgPath = FMLPaths.CONFIGDIR.get().resolve(CONFIG_PATH);
        JsonObject config = RecipeTypeNameConfig.loadJsonConfig(cfgPath);
        if (config.entrySet().isEmpty()) {
            config = RecipeTypeNameConfig.createDefaultTemplate();
            RecipeTypeNameConfig.saveJsonConfig(cfgPath, config);
        }
        HashMap<ResourceLocation, String> nameMap = new HashMap<ResourceLocation, String>();
        HashMap<String, String> alias = new HashMap<String, String>();
        for (Map.Entry entry : config.entrySet()) {
            String name;
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (value == null || !value.isJsonPrimitive() || (name = value.getAsString()) == null || name.isBlank()) continue;
            if (key.contains(":")) {
                try {
                    ResourceLocation rl = new ResourceLocation(key);
                    nameMap.put(rl, name);
                }
                catch (Exception exception) {}
                continue;
            }
            alias.put(key.toLowerCase(), name);
        }
        CUSTOM_NAMES.clear();
        CUSTOM_NAMES.putAll(nameMap);
        CUSTOM_ALIASES.clear();
        CUSTOM_ALIASES.putAll(alias);
    }

    public static synchronized boolean addOrUpdateAliasMapping(String aliasKey, String value) {
        if (aliasKey == null || aliasKey.isBlank() || value == null || value.isBlank()) {
            return false;
        }
        try {
            Path cfgPath = FMLPaths.CONFIGDIR.get().resolve(CONFIG_PATH);
            JsonObject config = RecipeTypeNameConfig.loadJsonConfig(cfgPath);
            String key = aliasKey.trim();
            config.addProperty(key, value);
            RecipeTypeNameConfig.saveJsonConfig(cfgPath, config);
            if (key.contains(":")) {
                try {
                    ResourceLocation rl = new ResourceLocation(key);
                    CUSTOM_NAMES.put(rl, value);
                }
                catch (Exception exception) {}
            } else {
                CUSTOM_ALIASES.put(key.toLowerCase(), value);
            }
            return true;
        }
        catch (JsonSyntaxException | IOException e) {
            GlobalSendMessage.sendPlayerMessage((Component)Component.m_237110_((String)"extendedae_plus.message.config_update_failed", (Object[])new Object[]{e.getMessage()}));
            return false;
        }
    }

    public static synchronized int removeMappingsByCnValue(String delValue) {
        if (delValue == null || delValue.trim().isEmpty()) {
            return 0;
        }
        try {
            Path cfgPath = FMLPaths.CONFIGDIR.get().resolve(CONFIG_PATH);
            JsonObject config = RecipeTypeNameConfig.loadJsonConfig(cfgPath);
            ArrayList<String> toRemove = new ArrayList<String>();
            for (Map.Entry entry : config.entrySet()) {
                JsonElement value = (JsonElement)entry.getValue();
                if (value == null || !value.isJsonPrimitive() || !delValue.equals(value.getAsString())) continue;
                toRemove.add((String)entry.getKey());
            }
            if (toRemove.isEmpty()) {
                return 0;
            }
            toRemove.forEach(arg_0 -> ((JsonObject)config).remove(arg_0));
            RecipeTypeNameConfig.saveJsonConfig(cfgPath, config);
            for (String key : toRemove) {
                if (key.contains(":")) {
                    try {
                        ResourceLocation rl = new ResourceLocation(key);
                        if (!delValue.equals(CUSTOM_NAMES.get(rl))) continue;
                        CUSTOM_NAMES.remove(rl);
                    }
                    catch (Exception rl) {}
                    continue;
                }
                String lower = key.toLowerCase();
                if (!delValue.equals(CUSTOM_ALIASES.get(lower))) continue;
                CUSTOM_ALIASES.remove(lower);
            }
            return toRemove.size();
        }
        catch (JsonSyntaxException | IOException e) {
            GlobalSendMessage.sendPlayerMessage((Component)Component.m_237110_((String)"extendedae_plus.message.config_delete_failed", (Object[])new Object[]{e.getMessage()}));
            return 0;
        }
    }

    public static String mapRecipeTypeToSearchKey(Recipe<?> recipe) {
        if (recipe == null) {
            return null;
        }
        RecipeType type = recipe.m_6671_();
        ResourceLocation key = BuiltInRegistries.f_256990_.m_7981_((Object)type);
        if (key == null) {
            return null;
        }
        String path = key.m_135815_().toLowerCase();
        return CUSTOM_ALIASES.getOrDefault(path, CUSTOM_NAMES.getOrDefault(key, path));
    }

    public static String mapGTCEuRecipeToSearchKey(Object gtRecipeObj) {
        if (gtRecipeObj == null) {
            return null;
        }
        try {
            String alias;
            Method mGetType = gtRecipeObj.getClass().getMethod("getType", new Class[0]);
            Object typeObj = mGetType.invoke(gtRecipeObj, new Object[0]);
            String idStr = String.valueOf(typeObj);
            if (idStr == null || idStr.isBlank()) {
                return null;
            }
            ResourceLocation rl = new ResourceLocation(idStr);
            String path = rl.m_135815_();
            if (path != null && (alias = CUSTOM_ALIASES.get(path.toLowerCase())) != null && !alias.isBlank()) {
                return alias;
            }
            String custom = CUSTOM_NAMES.get(rl);
            return custom != null && !custom.isBlank() ? custom : path;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String deriveSearchKeyFromUnknownRecipe(Object recipeBase) {
        if (recipeBase == null) {
            return null;
        }
        try {
            String key;
            Class<?> cls = recipeBase.getClass();
            String simple = cls.getSimpleName();
            String pkg = cls.getName();
            String namespace = null;
            String lower = pkg.toLowerCase();
            if (lower.contains("gtceu")) {
                namespace = "gtceu";
            } else if (lower.contains("gregtech")) {
                namespace = "gregtech";
            } else if (lower.contains("projecte")) {
                namespace = "projecte";
            } else if (lower.contains("create")) {
                namespace = "create";
            } else if (lower.contains("immersiveengineering")) {
                namespace = "immersive";
            }
            String token = RecipeTypeNameConfig.toSearchToken(simple);
            String string = key = namespace != null && token != null && !token.isBlank() ? namespace + " " + token : token;
            if (key == null || key.isBlank()) {
                return null;
            }
            String alias = CUSTOM_ALIASES.get(key.toLowerCase());
            return alias != null && !alias.isBlank() ? alias : key;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static String toSearchToken(String simpleName) {
        if (simpleName == null || simpleName.isBlank()) {
            return null;
        }
        String s = simpleName.replaceAll("Recipe(s)?$", "").replaceAll("Category$", "").replaceAll("JEI$", "").replaceAll("(?<!^)([A-Z])", " $1").toLowerCase().trim();
        return s.isBlank() ? null : s;
    }

    static {
        try {
            RecipeTypeNameConfig.loadRecipeTypeNames();
        }
        catch (Throwable t) {
            Logger.EAP$LOGGER.warn("ExtendedAE_Plus: \u6620\u5c04\u6587\u4ef6\u89e3\u6790\u5931\u8d25, {}", (Object)t.getMessage());
        }
        lastProcessingName = null;
    }
}

