/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.api.crafting;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.crafting.pattern.AEProcessingPattern;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScaledProcessingPattern
implements IPatternDetails {
    private final AEProcessingPattern original;
    private final long multiplier;

    public ScaledProcessingPattern(@NotNull AEProcessingPattern original, long multiplier) {
        if (multiplier <= 0L) {
            throw new IllegalArgumentException("multiplier must be > 0");
        }
        this.original = original;
        this.multiplier = multiplier;
    }

    public AEProcessingPattern getOriginal() {
        return this.original;
    }

    public long getMultiplier() {
        return this.multiplier;
    }

    public final AEItemKey getDefinition() {
        return this.original.getDefinition();
    }

    public final IPatternDetails.IInput[] getInputs() {
        IPatternDetails.IInput[] original = this.original.getInputs();
        IPatternDetails.IInput[] scaled = new IPatternDetails.IInput[original.length];
        for (int i = 0; i < original.length; ++i) {
            scaled[i] = new ScaledInput(original[i], this.multiplier);
        }
        return scaled;
    }

    public final GenericStack[] getOutputs() {
        GenericStack[] original = this.original.getOutputs();
        GenericStack[] scaled = new GenericStack[original.length];
        for (int i = 0; i < original.length; ++i) {
            if (original[i] == null) continue;
            scaled[i] = new GenericStack(original[i].what(), original[i].amount() * this.multiplier);
        }
        return scaled;
    }

    public final GenericStack[] getSparseInputs() {
        GenericStack[] original = this.original.getSparseInputs();
        GenericStack[] scaled = new GenericStack[original.length];
        for (int i = 0; i < original.length; ++i) {
            if (original[i] == null) continue;
            scaled[i] = new GenericStack(original[i].what(), original[i].amount() * this.multiplier);
        }
        return scaled;
    }

    public final GenericStack[] getSparseOutputs() {
        GenericStack[] original = this.original.getSparseOutputs();
        GenericStack[] scaled = new GenericStack[original.length];
        for (int i = 0; i < original.length; ++i) {
            if (original[i] == null) continue;
            scaled[i] = new GenericStack(original[i].what(), original[i].amount() * this.multiplier);
        }
        return scaled;
    }

    public int hashCode() {
        int h = this.original.hashCode();
        h = 31 * h + Long.hashCode(this.multiplier);
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ScaledProcessingPattern)) {
            return false;
        }
        ScaledProcessingPattern sp = (ScaledProcessingPattern)obj;
        return sp.original.equals((Object)this.original) && sp.multiplier == this.multiplier;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Scaled[Mult=").append(this.multiplier).append("] ");
        sb.append("Inputs: [");
        IPatternDetails.IInput[] inputs = this.original.getInputs();
        for (int i = 0; i < inputs.length; ++i) {
            IPatternDetails.IInput input = inputs[i];
            GenericStack[] stacks = input.getPossibleInputs();
            if (stacks == null || stacks.length <= 0) continue;
            GenericStack stack = stacks[0];
            sb.append(stack.what()).append("\u00d7").append(input.getMultiplier());
            if (i >= inputs.length - 1) continue;
            sb.append(", ");
        }
        sb.append("] ");
        sb.append("Outputs: [");
        GenericStack[] outputs = this.original.getOutputs();
        for (int i = 0; i < outputs.length; ++i) {
            GenericStack stack = outputs[i];
            if (stack == null) continue;
            sb.append(stack.what()).append("\u00d7").append(stack.amount());
            if (i >= outputs.length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    private record ScaledInput(IPatternDetails.IInput original, long multiplier) implements IPatternDetails.IInput
    {
        public GenericStack[] getPossibleInputs() {
            return this.original.getPossibleInputs();
        }

        public long getMultiplier() {
            return this.original.getMultiplier() * this.multiplier;
        }

        public boolean isValid(AEKey input, Level level) {
            return this.original.isValid(input, level);
        }

        @Nullable
        public AEKey getRemainingKey(AEKey template) {
            return this.original.getRemainingKey(template);
        }
    }
}

