/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.api.storage;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.core.AELog;
import com.extendedae_plus.ExtendedAEPlus;
import com.extendedae_plus.items.InfinityBigIntegerCellItem;
import com.extendedae_plus.util.storage.InfinityDataStorage;
import com.extendedae_plus.util.storage.InfinityStorageManager;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class InfinityBigIntegerCellInventory
implements StorageCell {
    private final InfinityBigIntegerCellItem cell;
    private final ItemStack self;
    private final ISaveProvider container;
    private Object2ObjectMap<AEKey, BigInteger> AEKey2AmountsMap;
    private int totalAEKeyType;
    private BigInteger totalAEKey2Amounts = BI_ZERO;
    private boolean isPersisted = true;
    private static final BigInteger BI_ZERO = BigInteger.ZERO;
    private static final BigInteger BI_LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);

    public InfinityBigIntegerCellInventory(InfinityBigIntegerCellItem cell, ItemStack stack, ISaveProvider saveProvider) {
        this.cell = cell;
        this.self = stack;
        this.container = saveProvider;
        this.AEKey2AmountsMap = null;
        this.initData();
    }

    public static String formatBigInteger(BigInteger number) {
        int idx;
        DecimalFormat df = new DecimalFormat("#.##");
        BigDecimal bd = new BigDecimal(number);
        BigDecimal thousand = new BigDecimal(1000);
        String[] units = new String[]{"", "K", "M", "G", "T", "P", "E", "Z", "Y"};
        for (idx = 0; bd.compareTo(thousand) >= 0 && idx < units.length - 1; ++idx) {
            bd = bd.divide(thousand, 2, RoundingMode.HALF_UP);
        }
        if (idx == 0) {
            return bd.setScale(0, RoundingMode.DOWN).toPlainString();
        }
        return df.format(bd.doubleValue()) + units[idx];
    }

    private InfinityDataStorage getCellStorage() {
        if (this.getUUID() != null) {
            return InfinityBigIntegerCellInventory.getStorageManagerInstance().getOrCreateCell(this.getUUID());
        }
        return InfinityDataStorage.EMPTY;
    }

    private void initData() {
        if (this.hasUUID()) {
            InfinityDataStorage storage = this.getCellStorage();
            this.totalAEKeyType = storage.amounts.size();
            this.totalAEKey2Amounts = storage.itemCount.equals(BI_ZERO) ? BI_ZERO : storage.itemCount;
        } else {
            this.totalAEKeyType = 0;
            this.totalAEKey2Amounts = BI_ZERO;
            this.getCellStoredMap();
        }
    }

    public CellState getStatus() {
        if (this.getTotalAEKey2Amounts().equals(BI_ZERO)) {
            return CellState.EMPTY;
        }
        return CellState.NOT_EMPTY;
    }

    public double getIdleDrain() {
        return 512.0;
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        if (this.totalAEKey2Amounts.equals(BI_ZERO)) {
            if (this.hasUUID()) {
                InfinityBigIntegerCellInventory.getStorageManagerInstance().removeCell(this.getUUID());
                if (this.self.m_41782_()) {
                    CompoundTag tag = this.self.m_41783_();
                    tag.m_128473_("infinity_cell_uuid");
                    tag.m_128473_("infinity_item_total");
                    tag.m_128473_("infinity_item_types");
                    tag.m_128473_("infinity_cell_item_count");
                }
                this.initData();
            }
            return;
        }
        ListTag keys = new ListTag();
        ListTag amounts = new ListTag();
        BigInteger itemCount = BI_ZERO;
        for (Object2ObjectMap.Entry entry : this.AEKey2AmountsMap.object2ObjectEntrySet()) {
            BigInteger amount = (BigInteger)entry.getValue();
            if (amount.compareTo(BI_ZERO) <= 0) continue;
            keys.add((Object)((AEKey)entry.getKey()).toTagGeneric());
            CompoundTag amountTag = new CompoundTag();
            amountTag.m_128382_("value", amount.toByteArray());
            amounts.add((Object)amountTag);
            itemCount = itemCount.add(amount);
        }
        if (keys.isEmpty()) {
            InfinityBigIntegerCellInventory.getStorageManagerInstance().updateCell(this.getUUID(), new InfinityDataStorage());
        } else {
            InfinityBigIntegerCellInventory.getStorageManagerInstance().modifyDisk(this.getUUID(), keys, amounts, itemCount);
        }
        this.totalAEKeyType = this.AEKey2AmountsMap.size();
        this.totalAEKey2Amounts = itemCount;
        CompoundTag tag = this.self.m_41784_();
        tag.m_128382_("infinity_item_total", itemCount.toByteArray());
        tag.m_128405_("infinity_item_types", this.totalAEKeyType);
        tag.m_128382_("infinity_cell_item_count", itemCount.toByteArray());
        this.isPersisted = true;
    }

    public Component getDescription() {
        return null;
    }

    public static InfinityBigIntegerCellInventory createInventory(ItemStack stack, ISaveProvider saveProvider) {
        Objects.requireNonNull(stack, "Cannot create cell inventory for null itemstack");
        Item item = stack.m_41720_();
        if (!(item instanceof InfinityBigIntegerCellItem)) {
            return null;
        }
        InfinityBigIntegerCellItem cell = (InfinityBigIntegerCellItem)item;
        return new InfinityBigIntegerCellInventory(cell, stack, saveProvider);
    }

    public BigInteger getTotalAEKey2Amounts() {
        return this.totalAEKey2Amounts;
    }

    public int getTotalAEKeyType() {
        return this.totalAEKeyType;
    }

    public boolean hasUUID() {
        return this.self.m_41782_() && this.self.m_41784_().m_128441_("infinity_cell_uuid");
    }

    public UUID getUUID() {
        if (this.hasUUID()) {
            return this.self.m_41784_().m_128342_("infinity_cell_uuid");
        }
        return null;
    }

    private Object2ObjectMap<AEKey, BigInteger> getCellStoredMap() {
        if (this.AEKey2AmountsMap == null) {
            this.AEKey2AmountsMap = new Object2ObjectOpenHashMap(512, 0.6f);
            this.loadCellStoredMap();
        }
        return this.AEKey2AmountsMap;
    }

    public void getAvailableStacks(KeyCounter out) {
        Object2ObjectMap<AEKey, BigInteger> map = this.getCellStoredMap();
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Object2ObjectMap.Entry entry : map.object2ObjectEntrySet()) {
            AEKey key = (AEKey)entry.getKey();
            BigInteger amount = (BigInteger)entry.getValue();
            if (amount.compareTo(BI_LONG_MAX) > 0) {
                out.set(key, Long.MAX_VALUE);
                continue;
            }
            long addAmount = amount.longValue();
            long existing = out.get(key);
            if (existing == Long.MAX_VALUE) continue;
            long sum = existing + addAmount;
            if (sum < 0L || sum < existing) {
                out.set(key, Long.MAX_VALUE);
                continue;
            }
            out.add(key, addAmount);
        }
    }

    private void loadCellStoredMap() {
        boolean dataCorruption = false;
        if (!this.self.m_41782_()) {
            return;
        }
        ListTag keys = this.getCellStorage().keys;
        ListTag amounts = this.getCellStorage().amounts;
        if (keys.size() != amounts.size()) {
            AELog.warn((String)"Loading storage cell with mismatched amounts/tags: %d != %d", (Object[])new Object[]{amounts.size(), keys.size()});
        }
        for (int i = 0; i < amounts.size(); ++i) {
            AEKey key = AEKey.fromTagGeneric((CompoundTag)keys.m_128728_(i));
            BigInteger amount = new BigInteger(amounts.m_128728_(i).m_128463_("value"));
            if (amount.compareTo(BI_ZERO) <= 0 || key == null) {
                dataCorruption = true;
                continue;
            }
            this.AEKey2AmountsMap.put((Object)key, (Object)amount);
        }
        if (dataCorruption) {
            this.saveChanges();
        }
    }

    private static InfinityStorageManager getStorageManagerInstance() {
        return ExtendedAEPlus.STORAGE_INSTANCE;
    }

    private void saveChanges() {
        this.totalAEKeyType = this.AEKey2AmountsMap.size();
        this.totalAEKey2Amounts = BI_ZERO;
        for (BigInteger AEKey2Amounts : this.AEKey2AmountsMap.values()) {
            this.totalAEKey2Amounts = this.totalAEKey2Amounts.add(AEKey2Amounts);
        }
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        AEItemKey itemKey;
        if (amount == 0L) {
            return 0L;
        }
        if (what instanceof AEItemKey && (itemKey = (AEItemKey)what).getItem() instanceof InfinityBigIntegerCellItem && itemKey.hasTag()) {
            return 0L;
        }
        if (!this.hasUUID()) {
            this.self.m_41784_().m_128362_("infinity_cell_uuid", UUID.randomUUID());
            InfinityBigIntegerCellInventory.getStorageManagerInstance().getOrCreateCell(this.getUUID());
            this.loadCellStoredMap();
        }
        BigInteger currentAmount = (BigInteger)this.getCellStoredMap().getOrDefault((Object)what, (Object)BI_ZERO);
        if (mode == Actionable.MODULATE) {
            BigInteger newAmount = currentAmount.add(BigInteger.valueOf(amount));
            this.getCellStoredMap().put((Object)what, (Object)newAmount);
            this.saveChanges();
        }
        return amount;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        BigInteger currentAmount = (BigInteger)this.getCellStoredMap().getOrDefault((Object)what, (Object)BI_ZERO);
        if (currentAmount.compareTo(BI_ZERO) > 0) {
            BigInteger requested = BigInteger.valueOf(amount);
            if (requested.compareTo(currentAmount) >= 0) {
                if (mode == Actionable.MODULATE) {
                    this.getCellStoredMap().remove((Object)what);
                    this.saveChanges();
                }
                return currentAmount.compareTo(BI_LONG_MAX) > 0 ? Long.MAX_VALUE : currentAmount.longValue();
            }
            if (mode == Actionable.MODULATE) {
                this.getCellStoredMap().put((Object)what, (Object)currentAmount.subtract(requested));
                this.saveChanges();
            }
            return requested.longValue();
        }
        return 0L;
    }

    public String getTotalStorage() {
        return InfinityBigIntegerCellInventory.formatBigInteger(this.totalAEKey2Amounts);
    }
}

