/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.content.matrix;

import appeng.api.config.Actionable;
import appeng.api.crafting.IPatternDetails;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.util.inv.CombinedInternalInventory;
import com.extendedae_plus.init.ModBlockEntities;
import com.glodblock.github.extendedae.common.me.CraftingMatrixThread;
import com.glodblock.github.extendedae.common.me.CraftingThread;
import com.glodblock.github.extendedae.common.me.matrix.ClusterAssemblerMatrix;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixCrafter;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CrafterCorePlusBlockEntity
extends TileAssemblerMatrixCrafter {
    public static final int MAX_THREAD = 32;
    private final CraftingThread[] threads = new CraftingThread[32];
    private final InternalInventory internalInv;
    private final BlockEntityType<?> overriddenType = (BlockEntityType)ModBlockEntities.ASSEMBLER_MATRIX_CRAFTER_PLUS_BE.get();
    private short states = 0;

    public CrafterCorePlusBlockEntity(BlockPos pos, BlockState blockState) {
        super(pos, blockState);
        InternalInventory[] inventories = new InternalInventory[32];
        for (int i = 0; i < 32; ++i) {
            int finalI = i;
            this.threads[i] = new CraftingMatrixThread((AEBaseBlockEntity)this, this::getSrc, signal -> this.changeState(finalI, signal));
            inventories[i] = this.threads[i].getInternalInventory();
        }
        this.internalInv = new CombinedInternalInventory(inventories);
    }

    private void changeState(int index, boolean state) {
        boolean oldState = this.states > 0;
        this.states = state ? (short)(this.states | (short)(1 << index)) : (short)(this.states & (short)(~(1 << index)));
        if (state) {
            if (!oldState) {
                this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
            }
        } else if (oldState && this.states <= 0) {
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().sleepDevice(node));
        }
    }

    private IActionSource getSrc() {
        return this.cluster.getSrc();
    }

    public int usedThread() {
        int count = 0;
        for (CraftingThread thread : this.threads) {
            if (thread.getInternalInventory().isEmpty()) continue;
            ++count;
        }
        double scale = 0.25;
        int reported = (int)Math.ceil((double)count * scale);
        return Math.min(8, reported);
    }

    public boolean pushJob(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        for (CraftingThread thread : this.threads) {
            if (!thread.acceptJob(patternDetails, inputHolder, Direction.DOWN)) continue;
            if (this.cluster != null) {
                this.cluster.updateCrafter((TileAssemblerMatrixCrafter)this);
            }
            return true;
        }
        return false;
    }

    public void stop() {
        for (CraftingThread thread : this.threads) {
            thread.stop();
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        for (int i = 0; i < 32; ++i) {
            tag.m_128365_("#ct" + i, (Tag)this.threads[i].writeNBT());
        }
        CompoundTag invTag = new CompoundTag();
        for (int i = 0; i < this.internalInv.size(); ++i) {
            invTag.m_128365_("item" + i, (Tag)this.internalInv.getStackInSlot(i).m_41739_(new CompoundTag()));
        }
        tag.m_128365_("inv", (Tag)invTag);
    }

    public void loadTag(CompoundTag tag) {
        super.loadTag(tag);
        for (int i = 0; i < 32; ++i) {
            if (!tag.m_128441_("#ct" + i)) continue;
            this.threads[i].readNBT(tag.m_128469_("#ct" + i));
        }
        CompoundTag invTag = tag.m_128469_("inv");
        for (int i = 0; i < this.internalInv.size(); ++i) {
            this.internalInv.setItemDirect(i, ItemStack.m_41712_((CompoundTag)invTag.m_128469_("item" + i)));
        }
    }

    public ItemStack pushResult(ItemStack stack, Direction direction) {
        IStorageService storage;
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null && (storage = (IStorageService)grid.getService(IStorageService.class)) != null) {
            long inserted = storage.getInventory().insert((AEKey)AEItemKey.of((ItemStack)stack), (long)stack.m_41613_(), Actionable.MODULATE, this.cluster == null ? null : this.cluster.getSrc());
            if (inserted == 0L) {
                return stack;
            }
            this.saveChanges();
            if (inserted != (long)stack.m_41613_()) {
                return stack.m_255036_((int)((long)stack.m_41613_() - inserted));
            }
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public void add(ClusterAssemblerMatrix cluster) {
        cluster.addCrafter((TileAssemblerMatrixCrafter)this);
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        boolean isAwake = false;
        for (CraftingThread thread : this.threads) {
            thread.recalculatePlan();
            thread.updateSleepiness();
            isAwake |= thread.isAwake();
        }
        return new TickingRequest(1, 1, !isAwake, false);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.cluster == null) {
            return TickRateModulation.SLEEP;
        }
        TickRateModulation rate = TickRateModulation.SLEEP;
        for (CraftingThread thread : this.threads) {
            TickRateModulation threadRate;
            if (!thread.isAwake() || (threadRate = thread.tick(this.cluster.getSpeedCore(), ticksSinceLastCall)).ordinal() <= rate.ordinal()) continue;
            rate = threadRate;
        }
        this.cluster.updateCrafter((TileAssemblerMatrixCrafter)this);
        return rate;
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        for (CraftingThread thread : this.threads) {
            if (inv != thread.getInternalInventory()) continue;
            thread.recalculatePlan();
            break;
        }
    }

    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (ItemStack stack : this.internalInv) {
            GenericStack genericStack = GenericStack.unwrapItemStack((ItemStack)stack);
            if (genericStack != null) {
                genericStack.what().addDrops(genericStack.amount(), drops, level, pos);
                continue;
            }
            drops.add(stack);
        }
    }

    public void m_6211_() {
        super.m_6211_();
        this.internalInv.clear();
    }

    public BlockEntityType<?> m_58903_() {
        return this.overriddenType;
    }
}

