/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.content.wireless;

import com.extendedae_plus.content.wireless.WirelessTransceiverBlockEntity;
import com.extendedae_plus.init.ModBlockEntities;
import com.extendedae_plus.init.ModItems;
import com.extendedae_plus.items.materials.ChannelCardItem;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class WirelessTransceiverBlock
extends Block
implements EntityBlock {
    public static final IntegerProperty STATE = IntegerProperty.m_61631_((String)"state", (int)0, (int)5);

    public WirelessTransceiverBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)STATE, (Comparable)Integer.valueOf(5)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{STATE});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new WirelessTransceiverBlockEntity(pos, state);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (!level.f_46443_ && placer instanceof Player) {
            Player player = (Player)placer;
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof WirelessTransceiverBlockEntity) {
                WirelessTransceiverBlockEntity te = (WirelessTransceiverBlockEntity)be;
                te.setPlacerId(player.m_20148_(), player.m_7755_().getString());
            }
        }
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        BlockEntity be;
        if (!level.f_46443_ && (be = level.m_7702_(pos)) instanceof WirelessTransceiverBlockEntity) {
            WirelessTransceiverBlockEntity te = (WirelessTransceiverBlockEntity)be;
            ItemStack mainHand = player.m_21205_();
            if (player.m_6144_() && mainHand.m_41720_() == ModItems.CHANNEL_CARD.get()) {
                this.handleChannelCardBinding(te, mainHand, player);
                super.m_6256_(state, level, pos, player);
                return;
            }
            if (player.m_6144_()) {
                if (te.isLocked()) {
                    player.m_5661_((Component)Component.m_237115_((String)"extendedae_plus.chat.wireless_transceiver.locked"), true);
                    super.m_6256_(state, level, pos, player);
                    return;
                }
                int step = 1;
                if (mainHand.m_150930_(Items.f_41978_)) {
                    step = 10;
                }
                if (mainHand.m_150930_(Items.f_42398_)) {
                    step = 10;
                }
                long f = te.getFrequency();
                if ((f -= (long)step) < 0L) {
                    f = 0L;
                }
                te.setFrequency(f);
                player.m_5661_((Component)Component.m_237110_((String)"extendedae_plus.chat.wireless_transceiver.channel", (Object[])new Object[]{te.getFrequency()}), true);
            }
        }
        super.m_6256_(state, level, pos, player);
    }

    private void handleChannelCardBinding(WirelessTransceiverBlockEntity te, ItemStack channelCard, Player player) {
        UUID cardOwner = ChannelCardItem.getOwnerUUID(channelCard);
        if (cardOwner != null) {
            String teamName = ChannelCardItem.getTeamName(channelCard);
            te.setPlacerId(cardOwner, teamName);
            String displayName = teamName != null ? teamName : cardOwner.toString().substring(0, 8);
            player.m_5661_((Component)Component.m_237110_((String)"extendedae_plus.chat.wireless_transceiver.bound_to", (Object[])new Object[]{displayName}), true);
        } else {
            te.setPlacerId(player.m_20148_(), player.m_7755_().getString());
            player.m_5661_((Component)Component.m_237115_((String)"extendedae_plus.chat.wireless_transceiver.card_unbound"), true);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof WirelessTransceiverBlockEntity) {
            WirelessTransceiverBlockEntity te = (WirelessTransceiverBlockEntity)be;
            boolean sneaking = player.m_6144_();
            if (sneaking) {
                if (te.isLocked()) {
                    player.m_5661_((Component)Component.m_237115_((String)"extendedae_plus.chat.wireless_transceiver.locked"), true);
                    return InteractionResult.CONSUME;
                }
                int step = 1;
                if (player.m_21120_(hand).m_150930_(Items.f_41978_)) {
                    step = 10;
                }
                if (player.m_21120_(hand).m_150930_(Items.f_42398_)) {
                    step = 10;
                }
                long f = te.getFrequency();
                if (hand == InteractionHand.MAIN_HAND) {
                    f += (long)step;
                } else if ((f -= (long)step) < 0L) {
                    f = 0L;
                }
                te.setFrequency(f);
                player.m_5661_((Component)Component.m_237110_((String)"extendedae_plus.chat.wireless_transceiver.channel", (Object[])new Object[]{te.getFrequency()}), true);
            } else {
                if (te.isLocked()) {
                    player.m_5661_((Component)Component.m_237115_((String)"extendedae_plus.chat.wireless_transceiver.locked"), true);
                    return InteractionResult.CONSUME;
                }
                te.setMasterMode(!te.isMasterMode());
                String modeKey = te.isMasterMode() ? "extendedae_plus.chat.wireless_transceiver.mode_master" : "extendedae_plus.chat.wireless_transceiver.mode_slave";
                player.m_5661_((Component)Component.m_237110_((String)"extendedae_plus.chat.wireless_transceiver.mode", (Object[])new Object[]{Component.m_237115_((String)modeKey)}), true);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity be;
        if (!state.m_60713_(newState.m_60734_()) && (be = level.m_7702_(pos)) instanceof WirelessTransceiverBlockEntity) {
            WirelessTransceiverBlockEntity te = (WirelessTransceiverBlockEntity)be;
            te.onRemoved();
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        WirelessTransceiverBlockEntity te;
        float baseProgress = super.m_5880_(state, player, level, pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof WirelessTransceiverBlockEntity && (te = (WirelessTransceiverBlockEntity)blockEntity).isLocked()) {
            return baseProgress * 0.1f;
        }
        return baseProgress;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.f_46443_) {
            return null;
        }
        return type == ModBlockEntities.WIRELESS_TRANSCEIVER_BE.get() ? (lvl, pos, st, be) -> WirelessTransceiverBlockEntity.serverTick(lvl, pos, st, (WirelessTransceiverBlockEntity)be) : null;
    }
}

