/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.content.wireless;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.util.AECableType;
import appeng.blockentity.AEBaseBlockEntity;
import com.extendedae_plus.ae.wireless.IWirelessEndpoint;
import com.extendedae_plus.ae.wireless.WirelessMasterLink;
import com.extendedae_plus.ae.wireless.WirelessSlaveLink;
import com.extendedae_plus.content.wireless.WirelessTransceiverBlock;
import com.extendedae_plus.init.ModBlockEntities;
import com.extendedae_plus.init.ModItems;
import java.util.EnumSet;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class WirelessTransceiverBlockEntity
extends AEBaseBlockEntity
implements IWirelessEndpoint,
IInWorldGridNodeHost {
    private IManagedGridNode managedNode = GridHelper.createManagedNode((Object)this, (IGridNodeListener)NodeListener.INSTANCE).setFlags(new GridFlags[]{GridFlags.DENSE_CAPACITY});
    private long frequency = 1L;
    private boolean masterMode = false;
    private boolean locked = false;
    private boolean beingRemoved = false;
    @Nullable
    private UUID placerId;
    @Nullable
    private String placerName;
    private WirelessMasterLink masterLink;
    private WirelessSlaveLink slaveLink;

    public WirelessTransceiverBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.WIRELESS_TRANSCEIVER_BE.get(), pos, state);
        this.managedNode.setIdlePowerUsage(1.0);
        this.managedNode.setTagName("wireless_node");
        this.managedNode.setInWorldNode(true);
        this.managedNode.setExposedOnSides(EnumSet.allOf(Direction.class));
        this.managedNode.setVisualRepresentation(((Item)ModItems.WIRELESS_TRANSCEIVER.get()).m_7968_());
        this.masterLink = new WirelessMasterLink(this);
        this.slaveLink = new WirelessSlaveLink(this);
    }

    public AECableType getCableConnectionType(Direction dir) {
        AECableType t;
        if (this.f_58857_ == null) {
            return AECableType.GLASS;
        }
        BlockPos adjacentPos = this.f_58858_.m_121945_(dir);
        if (!Objects.requireNonNull(this.m_58904_()).m_46805_(adjacentPos)) {
            return AECableType.GLASS;
        }
        IInWorldGridNodeHost adjacentHost = GridHelper.getNodeHost((Level)this.m_58904_(), (BlockPos)adjacentPos);
        if (adjacentHost != null && (t = adjacentHost.getCableConnectionType(dir.m_122424_())) != null) {
            return t;
        }
        return AECableType.GLASS;
    }

    @Nullable
    public IGridNode getGridNode(Direction dir) {
        return this.getGridNode();
    }

    @Override
    public ServerLevel getServerLevel() {
        ServerLevel sl;
        Level lvl = super.m_58904_();
        return lvl instanceof ServerLevel ? (sl = (ServerLevel)lvl) : null;
    }

    @Override
    public BlockPos m_58899_() {
        return this.f_58858_;
    }

    @Override
    public IGridNode getGridNode() {
        return this.managedNode == null ? null : this.managedNode.getNode();
    }

    @Override
    public boolean isEndpointRemoved() {
        return super.m_58901_();
    }

    public void setPlacerId(@Nullable UUID placerId, @Nullable String placerName) {
        if (this.placerId != null && !this.placerId.equals(placerId)) {
            if (this.masterMode) {
                this.masterLink.onUnloadOrRemove();
            } else {
                this.slaveLink.onUnloadOrRemove();
            }
        }
        this.placerId = placerId;
        this.placerName = placerName;
        this.masterLink.setPlacerId(placerId);
        this.slaveLink.setPlacerId(placerId);
        this.m_6596_();
    }

    public void setPlacerId(@Nullable UUID placerId) {
        this.setPlacerId(placerId, null);
    }

    @Nullable
    public UUID getPlacerId() {
        return this.placerId;
    }

    @Nullable
    public String getPlacerName() {
        return this.placerName;
    }

    public long getFrequency() {
        return this.frequency;
    }

    public void setFrequency(long frequency) {
        if (this.locked) {
            return;
        }
        if (this.frequency == frequency) {
            return;
        }
        this.frequency = frequency;
        if (this.isMasterMode()) {
            this.masterLink.setFrequency(frequency);
        } else {
            this.slaveLink.setFrequency(frequency);
        }
        this.m_6596_();
    }

    public boolean isMasterMode() {
        return this.masterMode;
    }

    public void setMasterMode(boolean masterMode) {
        if (this.locked) {
            return;
        }
        if (this.masterMode == masterMode) {
            return;
        }
        if (this.masterMode) {
            this.masterLink.onUnloadOrRemove();
        } else {
            this.slaveLink.onUnloadOrRemove();
        }
        this.masterMode = masterMode;
        if (this.masterMode) {
            this.masterLink.setFrequency(this.frequency);
        } else {
            this.slaveLink.setFrequency(this.frequency);
        }
        this.m_6596_();
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        if (this.locked == locked) {
            return;
        }
        this.locked = locked;
        this.m_6596_();
    }

    public void onRemoved() {
        this.beingRemoved = true;
        if (this.masterMode) {
            this.masterLink.onUnloadOrRemove();
        } else {
            this.slaveLink.onUnloadOrRemove();
        }
        if (this.managedNode != null) {
            this.managedNode.destroy();
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, WirelessTransceiverBlockEntity be) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        if (!be.masterMode) {
            be.slaveLink.updateStatus();
        }
        be.updateState();
    }

    private void updateState() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.beingRemoved || this.m_58901_()) {
            return;
        }
        BlockState currentState = this.m_58900_();
        if (!(currentState.m_60734_() instanceof WirelessTransceiverBlock)) {
            return;
        }
        IGridNode node = this.getGridNode();
        int newState = 5;
        if (node != null && node.isActive()) {
            int usedChannels = 0;
            for (IGridConnection connection : node.getConnections()) {
                usedChannels = Math.max(connection.getUsedChannels(), usedChannels);
            }
            if (usedChannels >= 32) {
                newState = 4;
            } else if (usedChannels >= 24) {
                newState = 3;
            } else if (usedChannels >= 16) {
                newState = 2;
            } else if (usedChannels >= 8) {
                newState = 1;
            } else if (usedChannels >= 0) {
                newState = 0;
            }
        }
        if ((Integer)currentState.m_61143_((Property)WirelessTransceiverBlock.STATE) != newState) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)currentState.m_61124_((Property)WirelessTransceiverBlock.STATE, (Comparable)Integer.valueOf(newState)), 3);
        }
    }

    public void onLoad() {
        super.onLoad();
        ServerLevel sl = this.getServerLevel();
        if (sl == null) {
            return;
        }
        GridHelper.onFirstTick((BlockEntity)this, be -> {
            be.managedNode.create(be.m_58904_(), be.m_58899_());
            if (be.masterMode) {
                be.masterLink.setFrequency(be.frequency);
            } else {
                be.slaveLink.setFrequency(be.frequency);
            }
        });
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128356_("frequency", this.frequency);
        tag.m_128379_("master", this.masterMode);
        tag.m_128379_("locked", this.locked);
        if (this.placerId != null) {
            tag.m_128362_("placerId", this.placerId);
        }
        if (this.placerName != null) {
            tag.m_128359_("placerName", this.placerName);
        }
        if (this.managedNode != null) {
            this.managedNode.saveToNBT(tag);
        }
    }

    public void loadTag(CompoundTag tag) {
        super.loadTag(tag);
        this.frequency = tag.m_128454_("frequency");
        this.masterMode = tag.m_128471_("master");
        this.locked = tag.m_128471_("locked");
        if (tag.m_128403_("placerId")) {
            this.placerId = tag.m_128342_("placerId");
            this.masterLink.setPlacerId(this.placerId);
            this.slaveLink.setPlacerId(this.placerId);
        }
        if (tag.m_128441_("placerName")) {
            this.placerName = tag.m_128461_("placerName");
        }
        if (this.managedNode != null) {
            this.managedNode.loadFromNBT(tag);
        }
        if (this.masterMode) {
            this.masterLink.setFrequency(this.frequency);
        } else {
            this.slaveLink.setFrequency(this.frequency);
        }
    }

    static enum NodeListener implements IGridNodeListener<WirelessTransceiverBlockEntity>
    {
        INSTANCE;


        public void onSaveChanges(WirelessTransceiverBlockEntity host, IGridNode node) {
            host.m_6596_();
        }

        public void onStateChanged(WirelessTransceiverBlockEntity host, IGridNode node, IGridNodeListener.State state) {
            host.updateState();
        }

        public void onInWorldConnectionChanged(WirelessTransceiverBlockEntity host, IGridNode node) {
            host.updateState();
        }

        public void onGridChanged(WirelessTransceiverBlockEntity host, IGridNode node) {
            host.updateState();
        }

        public void onOwnerChanged(WirelessTransceiverBlockEntity host, IGridNode node) {
        }
    }
}

