/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.datagen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.CraftingRecipeBuilder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class NBTShapedRecipeBuilder
extends CraftingRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final ItemStack result;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, JsonObject> key = Maps.newLinkedHashMap();
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();
    private final List<ICondition> conditions = new ArrayList<ICondition>();
    @Nullable
    private String group;
    private boolean showNotification = true;

    private NBTShapedRecipeBuilder(RecipeCategory category, ItemStack result) {
        this.category = category;
        this.result = result;
    }

    public static NBTShapedRecipeBuilder shaped(RecipeCategory category, ItemStack result) {
        return new NBTShapedRecipeBuilder(category, result);
    }

    public static NBTShapedRecipeBuilder shaped(RecipeCategory category, ItemLike result) {
        return NBTShapedRecipeBuilder.shaped(category, new ItemStack(result));
    }

    public static NBTShapedRecipeBuilder shaped(RecipeCategory category, ItemLike result, int count) {
        return NBTShapedRecipeBuilder.shaped(category, new ItemStack(result, count));
    }

    public NBTShapedRecipeBuilder define(Character symbol, ItemLike item) {
        JsonObject json = new JsonObject();
        json.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item.m_5456_())).toString());
        this.key.put(symbol, json);
        return this;
    }

    public NBTShapedRecipeBuilder define(Character symbol, TagKey<Item> tag) {
        JsonObject json = new JsonObject();
        json.addProperty("tag", tag.f_203868_().toString());
        this.key.put(symbol, json);
        return this;
    }

    public NBTShapedRecipeBuilder defineNbt(Character symbol, ItemStack stackWithNbt) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "forge:nbt");
        json.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)stackWithNbt.m_41720_())).toString());
        if (stackWithNbt.m_41782_() && stackWithNbt.m_41783_() != null) {
            json.add("nbt", NBTShapedRecipeBuilder.nbtToJson(stackWithNbt.m_41783_()));
        }
        this.key.put(symbol, json);
        return this;
    }

    public NBTShapedRecipeBuilder pattern(String pattern) {
        if (!this.rows.isEmpty() && pattern.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width");
        }
        this.rows.add(pattern);
        return this;
    }

    @NotNull
    public NBTShapedRecipeBuilder unlockedBy(@NotNull String name, @NotNull CriterionTriggerInstance criterion) {
        this.advancement.m_138386_(name, criterion);
        return this;
    }

    @NotNull
    public NBTShapedRecipeBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public NBTShapedRecipeBuilder showNotification(boolean show) {
        this.showNotification = show;
        return this;
    }

    public NBTShapedRecipeBuilder condition(ICondition condition) {
        this.conditions.add(Objects.requireNonNull(condition));
        return this;
    }

    public NBTShapedRecipeBuilder requiresMod(String modid) {
        return this.condition((ICondition)new ModLoadedCondition(modid));
    }

    public NBTShapedRecipeBuilder notRequiresMod(String modid) {
        return this.condition((ICondition)new NotCondition((ICondition)new ModLoadedCondition(modid)));
    }

    @NotNull
    public Item m_142372_() {
        return this.result.m_41720_();
    }

    public void m_176500_(@NotNull Consumer<FinishedRecipe> consumer, @NotNull String id) {
        this.m_126140_(consumer, new ResourceLocation(id));
    }

    public void m_126140_(@NotNull Consumer<FinishedRecipe> consumer, @NotNull ResourceLocation id) {
        this.ensureValid(id);
        Advancement.Builder advancementBuilder = this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        NBTResult plainRecipe = new NBTResult(id, this.result, this.group == null ? "" : this.group, NBTShapedRecipeBuilder.m_245179_((RecipeCategory)this.category), this.rows, this.key, advancementBuilder, id.m_246208_("recipes/" + this.category.m_247710_() + "/"), this.showNotification);
        if (this.conditions.isEmpty()) {
            consumer.accept((FinishedRecipe)plainRecipe);
        } else {
            ConditionalRecipe.Builder builder = ConditionalRecipe.builder();
            for (ICondition cond : this.conditions) {
                builder.addCondition(cond);
            }
            builder.addRecipe(arg_0 -> NBTShapedRecipeBuilder.lambda$save$0((FinishedRecipe)plainRecipe, arg_0));
            builder.generateAdvancement();
            builder.build(consumer, id);
        }
    }

    private void ensureValid(ResourceLocation id) {
        if (this.rows.isEmpty()) {
            throw new IllegalStateException("No pattern for " + String.valueOf(id));
        }
        HashSet defined = Sets.newHashSet(this.key.keySet());
        defined.remove(Character.valueOf(' '));
        for (String row : this.rows) {
            for (int i = 0; i < row.length(); ++i) {
                char c = row.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c)) && c != ' ') {
                    throw new IllegalStateException("Undefined symbol '" + c + "'");
                }
                defined.remove(Character.valueOf(c));
            }
        }
        if (!defined.isEmpty()) {
            throw new IllegalStateException("Unused ingredients: " + String.valueOf(defined));
        }
        if (this.rows.size() == 1 && this.rows.get(0).length() == 1) {
            throw new IllegalStateException("Use shapeless for 1x1");
        }
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No unlock criterion for " + String.valueOf(id));
        }
    }

    private static JsonElement nbtToJson(CompoundTag tag) {
        JsonObject obj = new JsonObject();
        tag.m_128431_().forEach(key -> {
            Tag value = tag.m_128423_(key);
            if (value instanceof CompoundTag) {
                CompoundTag c = (CompoundTag)value;
                obj.add(key, NBTShapedRecipeBuilder.nbtToJson(c));
            } else if (value instanceof ListTag) {
                ListTag list = (ListTag)value;
                JsonArray arr = new JsonArray();
                for (Tag item : list) {
                    arr.add(NBTShapedRecipeBuilder.nbtToJson(item));
                }
                obj.add(key, (JsonElement)arr);
            } else if (value instanceof StringTag) {
                StringTag s = (StringTag)value;
                obj.addProperty(key, s.m_7916_());
            } else if (value instanceof NumericTag) {
                NumericTag n = (NumericTag)value;
                if (value instanceof ByteTag) {
                    obj.addProperty(key, (Number)n.m_7063_());
                } else if (value instanceof ShortTag) {
                    obj.addProperty(key, (Number)n.m_7053_());
                } else if (value instanceof IntTag) {
                    obj.addProperty(key, (Number)n.m_7047_());
                } else if (value instanceof LongTag) {
                    obj.addProperty(key, (Number)n.m_7046_());
                } else if (value instanceof FloatTag) {
                    obj.addProperty(key, (Number)Float.valueOf(n.m_7057_()));
                } else if (value instanceof DoubleTag) {
                    obj.addProperty(key, (Number)n.m_7061_());
                }
            } else if (value != null) {
                obj.addProperty(key, value.m_7916_());
            }
        });
        return obj;
    }

    private static JsonElement nbtToJson(Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag c = (CompoundTag)tag;
            return NBTShapedRecipeBuilder.nbtToJson(c);
        }
        if (tag instanceof StringTag) {
            StringTag s = (StringTag)tag;
            return new JsonPrimitive(s.m_7916_());
        }
        if (tag instanceof NumericTag) {
            NumericTag n = (NumericTag)tag;
            if (tag instanceof ByteTag) {
                return new JsonPrimitive((Number)n.m_7063_());
            }
            if (tag instanceof ShortTag) {
                return new JsonPrimitive((Number)n.m_7053_());
            }
            if (tag instanceof IntTag) {
                return new JsonPrimitive((Number)n.m_7047_());
            }
            if (tag instanceof LongTag) {
                return new JsonPrimitive((Number)n.m_7046_());
            }
            if (tag instanceof FloatTag) {
                return new JsonPrimitive((Number)Float.valueOf(n.m_7057_()));
            }
            if (tag instanceof DoubleTag) {
                return new JsonPrimitive((Number)n.m_7061_());
            }
        }
        return new JsonPrimitive(tag.m_7916_());
    }

    private static /* synthetic */ void lambda$save$0(FinishedRecipe plainRecipe, Consumer c) {
        c.accept(plainRecipe);
    }

    public static class NBTResult
    extends CraftingRecipeBuilder.CraftingResult {
        private final ResourceLocation id;
        private final ItemStack result;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, JsonObject> key;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final boolean showNotification;

        public NBTResult(ResourceLocation id, ItemStack result, String group, CraftingBookCategory category, List<String> pattern, Map<Character, JsonObject> key, Advancement.Builder advancement, ResourceLocation advancementId, boolean showNotification) {
            super(category);
            this.id = id;
            this.result = result;
            this.group = group;
            this.pattern = pattern;
            this.key = key;
            this.advancement = advancement;
            this.advancementId = advancementId;
            this.showNotification = showNotification;
        }

        public void m_7917_(@NotNull JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray patternArray = new JsonArray();
            this.pattern.forEach(arg_0 -> ((JsonArray)patternArray).add(arg_0));
            json.add("pattern", (JsonElement)patternArray);
            JsonObject keyObj = new JsonObject();
            this.key.forEach((c, jsonObj) -> keyObj.add(String.valueOf(c), (JsonElement)jsonObj));
            json.add("key", (JsonElement)keyObj);
            JsonObject resultObj = new JsonObject();
            resultObj.addProperty("type", "forge:partial_nbt");
            resultObj.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.result.m_41720_())).toString());
            if (this.result.m_41613_() > 1) {
                resultObj.addProperty("count", (Number)this.result.m_41613_());
            }
            if (this.result.m_41782_() && this.result.m_41783_() != null) {
                resultObj.add("nbt", NBTShapedRecipeBuilder.nbtToJson(this.result.m_41783_()));
            }
            json.add("result", (JsonElement)resultObj);
            json.addProperty("show_notification", Boolean.valueOf(this.showNotification));
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return RecipeSerializer.f_44076_;
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

