/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.integration.jade;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum WirelessTransceiverJadePluginComponents implements IBlockComponentProvider
{
    FREQUENCY("wt_frequency"){

        @Override
        protected void add(BlockAccessor accessor, ITooltip tooltip, IPluginConfig config, CompoundTag data) {
            if (data.m_128441_("frequency")) {
                long frequency = data.m_128454_("frequency");
                tooltip.add((Component)Component.m_237110_((String)"extendedae_plus.jade.frequency", (Object[])new Object[]{frequency}));
            }
        }
    }
    ,
    MODE("wt_master_mode"){

        @Override
        protected void add(BlockAccessor accessor, ITooltip tooltip, IPluginConfig config, CompoundTag data) {
            if (data.m_128441_("masterMode")) {
                boolean masterMode = data.m_128471_("masterMode");
                String modeKey = masterMode ? "extendedae_plus.jade.mode_master" : "extendedae_plus.jade.mode_slave";
                tooltip.add((Component)Component.m_237110_((String)"extendedae_plus.jade.mode", (Object[])new Object[]{Component.m_237115_((String)modeKey)}));
            }
        }
    }
    ,
    MASTER_LOCATION("wt_master_location"){

        @Override
        protected void add(BlockAccessor accessor, ITooltip tooltip, IPluginConfig config, CompoundTag data) {
            if (data.m_128441_("masterMode") && !data.m_128471_("masterMode") && data.m_128441_("masterPos")) {
                String customName;
                BlockPos pos = BlockPos.m_122022_((long)data.m_128454_("masterPos"));
                String dim = data.m_128441_("masterDim") ? data.m_128461_("masterDim") : "";
                String string = customName = data.m_128441_("customName") ? data.m_128461_("customName") : null;
                if (customName != null) {
                    tooltip.add((Component)Component.m_237110_((String)"extendedae_plus.jade.master_node_with_name", (Object[])new Object[]{customName, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}));
                } else {
                    tooltip.add((Component)Component.m_237110_((String)"extendedae_plus.jade.master_node_location", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}));
                }
                if (!dim.isEmpty()) {
                    tooltip.add((Component)Component.m_237110_((String)"extendedae_plus.jade.dimension", (Object[])new Object[]{dim}));
                }
            }
        }
    }
    ,
    LOCKED("wt_locked"){

        @Override
        protected void add(BlockAccessor accessor, ITooltip tooltip, IPluginConfig config, CompoundTag data) {
            if (data.m_128441_("locked")) {
                boolean locked = data.m_128471_("locked");
                String statusKey = locked ? "extendedae_plus.jade.locked" : "extendedae_plus.jade.unlocked";
                tooltip.add((Component)Component.m_237110_((String)"extendedae_plus.jade.lock_status", (Object[])new Object[]{Component.m_237115_((String)statusKey)}));
            }
        }
    }
    ,
    CHANNELS("wt_channels"){

        @Override
        protected void add(BlockAccessor accessor, ITooltip tooltip, IPluginConfig config, CompoundTag data) {
            if (data.m_128441_("usedChannels") && data.m_128441_("maxChannels")) {
                int usedChannels = data.m_128451_("usedChannels");
                int maxChannels = data.m_128451_("maxChannels");
                if (maxChannels <= 0) {
                    tooltip.add((Component)Component.m_237110_((String)"extendedae_plus.jade.channels", (Object[])new Object[]{usedChannels}));
                } else {
                    tooltip.add((Component)Component.m_237110_((String)"extendedae_plus.jade.channels_of", (Object[])new Object[]{usedChannels, maxChannels}));
                }
            }
        }
    }
    ,
    OWNER("wt_owner"){

        @Override
        protected void add(BlockAccessor accessor, ITooltip tooltip, IPluginConfig config, CompoundTag data) {
            if (data.m_128441_("ownerName")) {
                String ownerName = data.m_128461_("ownerName");
                tooltip.add((Component)Component.m_237110_((String)"extendedae_plus.jade.owner", (Object[])new Object[]{ownerName}));
            } else if (data.m_128441_("placerId")) {
                UUID placerId = data.m_128342_("placerId");
                tooltip.add((Component)Component.m_237110_((String)"extendedae_plus.jade.owner", (Object[])new Object[]{placerId.toString().substring(0, 8) + "..."}));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"extendedae_plus.jade.owner.public"));
            }
        }
    }
    ,
    NETWORK_USABLE("wt_network_usable"){

        @Override
        protected void add(BlockAccessor accessor, ITooltip tooltip, IPluginConfig config, CompoundTag data) {
            if (data.m_128441_("networkUsable")) {
                boolean usable = data.m_128471_("networkUsable");
                String statusKey = usable ? "extendedae_plus.jade.online" : "extendedae_plus.jade.offline";
                tooltip.add((Component)Component.m_237115_((String)statusKey));
            }
        }
    };

    private final ResourceLocation uid;

    private WirelessTransceiverJadePluginComponents(String path) {
        this.uid = new ResourceLocation("extendedae_plus", path);
    }

    public ResourceLocation getUid() {
        return this.uid;
    }

    public final void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag data = accessor.getServerData();
        if (data == null) {
            return;
        }
        this.add(accessor, tooltip, config, data);
    }

    protected abstract void add(BlockAccessor var1, ITooltip var2, IPluginConfig var3, CompoundTag var4);
}

