/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.integration.jade;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.pathing.ChannelMode;
import appeng.me.GridNode;
import com.extendedae_plus.ae.wireless.IWirelessEndpoint;
import com.extendedae_plus.ae.wireless.WirelessMasterRegistry;
import com.extendedae_plus.content.wireless.WirelessTransceiverBlockEntity;
import com.extendedae_plus.util.wireless.WirelessTeamUtil;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IServerDataProvider;

public enum WirelessTransceiverProvider implements IServerDataProvider<BlockAccessor>
{
    INSTANCE;

    private static final ResourceLocation UID;

    public ResourceLocation getUid() {
        return UID;
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof WirelessTransceiverBlockEntity) {
            long freq;
            IWirelessEndpoint master;
            ServerLevel level;
            WirelessTransceiverBlockEntity blockEntity2 = (WirelessTransceiverBlockEntity)blockEntity;
            data.m_128356_("frequency", blockEntity2.getFrequency());
            data.m_128379_("masterMode", blockEntity2.isMasterMode());
            data.m_128379_("locked", blockEntity2.isLocked());
            IGridNode node = blockEntity2.getGridNode();
            IGrid grid = node == null ? null : node.getGrid();
            boolean networkUsable = false;
            if (grid != null) {
                try {
                    networkUsable = grid.getEnergyService().isNetworkPowered();
                }
                catch (Throwable ignored) {
                    networkUsable = false;
                }
            }
            data.m_128379_("networkUsable", networkUsable);
            int usedChannels = 0;
            int maxChannels = 0;
            if (node != null && node.isActive()) {
                for (IGridConnection connection : node.getConnections()) {
                    usedChannels = Math.max(connection.getUsedChannels(), usedChannels);
                }
                if (node instanceof GridNode) {
                    GridNode gridNode = (GridNode)node;
                    ChannelMode channelMode = gridNode.getGrid().getPathingService().getChannelMode();
                    maxChannels = channelMode == ChannelMode.INFINITE ? -1 : gridNode.getMaxChannels();
                }
            }
            data.m_128405_("usedChannels", usedChannels);
            data.m_128405_("maxChannels", maxChannels);
            UUID placerId = blockEntity2.getPlacerId();
            if (placerId != null) {
                data.m_128362_("placerId", placerId);
                level = blockEntity2.getServerLevel();
                if (level != null) {
                    Component ownerName = WirelessTeamUtil.getNetworkOwnerName(level, placerId);
                    data.m_128359_("ownerName", ownerName.getString());
                }
            }
            if (!blockEntity2.isMasterMode() && (master = WirelessMasterRegistry.get(level = blockEntity2.getServerLevel(), freq = blockEntity2.getFrequency(), placerId)) != null && !master.isEndpointRemoved()) {
                BlockPos pos;
                WirelessTransceiverBlockEntity masterBlockEntity;
                if (master instanceof WirelessTransceiverBlockEntity && (masterBlockEntity = (WirelessTransceiverBlockEntity)master).m_7770_() != null) {
                    data.m_128359_("customName", masterBlockEntity.m_7770_().getString());
                }
                if ((pos = master.m_58899_()) != null) {
                    data.m_128356_("masterPos", pos.m_121878_());
                }
                if (master.getServerLevel() != null) {
                    data.m_128359_("masterDim", master.getServerLevel().m_46472_().m_135782_().toString());
                }
            }
        }
    }

    static {
        UID = new ResourceLocation("extendedae_plus", "wireless_transceiver_info");
    }
}

