/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.items.materials;

import appeng.items.materials.UpgradeCardItem;
import com.extendedae_plus.content.wireless.WirelessTransceiverBlock;
import com.extendedae_plus.util.wireless.WirelessTeamUtil;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ChannelCardItem
extends UpgradeCardItem {
    public static final String TAG_CHANNEL = "channel";
    public static final String TAG_OWNER_UUID = "ownerUUID";
    public static final String TAG_TEAM_NAME = "teamName";

    public ChannelCardItem(Item.Properties properties) {
        super(properties);
    }

    public static void setChannel(ItemStack stack, long channel) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128356_(TAG_CHANNEL, channel);
    }

    public static long getChannel(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_(TAG_CHANNEL) ? tag.m_128454_(TAG_CHANNEL) : 0L;
    }

    public static void setOwnerUUID(ItemStack stack, UUID ownerUUID) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128362_(TAG_OWNER_UUID, ownerUUID);
    }

    @Nullable
    public static UUID getOwnerUUID(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128403_(TAG_OWNER_UUID) ? tag.m_128342_(TAG_OWNER_UUID) : null;
    }

    public static void setTeamName(ItemStack stack, String teamName) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_(TAG_TEAM_NAME, teamName);
    }

    @Nullable
    public static String getTeamName(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_(TAG_TEAM_NAME) ? tag.m_128461_(TAG_TEAM_NAME) : null;
    }

    public static void clearOwner(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            tag.m_128473_(TAG_OWNER_UUID);
            tag.m_128473_(TAG_TEAM_NAME);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> lines, TooltipFlag flag) {
        super.m_7373_(stack, level, lines, flag);
        long ch = ChannelCardItem.getChannel(stack);
        if (ch == 0L) {
            lines.add((Component)Component.m_237115_((String)"item.extendedae_plus.channel_card.channel.unset"));
        } else {
            lines.add((Component)Component.m_237110_((String)"item.extendedae_plus.channel_card.channel", (Object[])new Object[]{ch}));
        }
        UUID ownerUUID = ChannelCardItem.getOwnerUUID(stack);
        String teamName = ChannelCardItem.getTeamName(stack);
        if (ownerUUID != null) {
            if (teamName != null && !teamName.isEmpty()) {
                lines.add((Component)Component.m_237110_((String)"item.extendedae_plus.channel_card.owner.team", (Object[])new Object[]{teamName}));
            } else {
                lines.add((Component)Component.m_237110_((String)"item.extendedae_plus.channel_card.owner.player", (Object[])new Object[]{ownerUUID.toString().substring(0, 8)}));
            }
        } else {
            lines.add((Component)Component.m_237115_((String)"item.extendedae_plus.channel_card.owner.unset"));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_) {
            long ch = ChannelCardItem.getChannel(stack);
            long next = player.m_6144_() ? Math.max(0L, ch - 1L) : ch + 1L;
            if (next != ch) {
                ChannelCardItem.setChannel(stack, next);
                player.m_5661_((Component)Component.m_237110_((String)"item.extendedae_plus.channel_card.set", (Object[])new Object[]{next}), true);
            }
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (player.m_6144_()) {
            return true;
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        if (!player.m_6144_()) {
            return false;
        }
        if (player.m_9236_().f_46443_) {
            return true;
        }
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockState blockState = player.m_9236_().m_8055_(pos);
            if (blockState.m_60734_() instanceof WirelessTransceiverBlock) {
                return false;
            }
            UUID currentOwner = ChannelCardItem.getOwnerUUID(stack);
            if (currentOwner != null) {
                ChannelCardItem.clearOwner(stack);
                player.m_5661_((Component)Component.m_237115_((String)"item.extendedae_plus.channel_card.owner.cleared"), true);
            } else {
                UUID playerUUID = player.m_20148_();
                ChannelCardItem.setOwnerUUID(stack, playerUUID);
                Component teamName = WirelessTeamUtil.getNetworkOwnerName(serverLevel, playerUUID);
                ChannelCardItem.setTeamName(stack, teamName.getString());
                player.m_5661_((Component)Component.m_237110_((String)"item.extendedae_plus.channel_card.owner.bound", (Object[])new Object[]{teamName}), true);
            }
        }
        return true;
    }
}

