/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.mixin.ae2.autopattern;

import appeng.api.crafting.IPatternDetails;
import appeng.crafting.CraftingCalculation;
import appeng.crafting.CraftingPlan;
import appeng.crafting.inv.CraftingSimulationState;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.me.service.CraftingService;
import com.extendedae_plus.api.crafting.ScaledProcessingPattern;
import com.extendedae_plus.api.smartDoubling.ICraftingCalculationExt;
import com.extendedae_plus.api.smartDoubling.ISmartDoublingAwarePattern;
import com.extendedae_plus.config.ModConfig;
import com.extendedae_plus.mixin.ae2.autopattern.CraftingSimulationStateAccessor;
import com.extendedae_plus.util.smartDoubling.PatternScaler;
import com.google.common.collect.Iterables;
import java.util.LinkedHashMap;
import java.util.Map;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CraftingSimulationState.class}, remap=false)
public abstract class CraftingSimulationStateMixin {
    @Inject(method={"buildCraftingPlan"}, at={@At(value="HEAD")})
    private static void onBuildCraftingPlan(CraftingSimulationState state, CraftingCalculation calculation, long calculatedAmount, CallbackInfoReturnable<CraftingPlan> cir) {
        CraftingSimulationStateAccessor accessor = (CraftingSimulationStateAccessor)state;
        Map<IPatternDetails, Long> crafts = accessor.getCrafts();
        LinkedHashMap<Object, Long> finalCrafts = new LinkedHashMap<Object, Long>();
        for (Map.Entry<IPatternDetails, Long> entry : crafts.entrySet()) {
            IPatternDetails details = entry.getKey();
            long totalAmount = entry.getValue();
            if (!(details instanceof AEProcessingPattern)) {
                finalCrafts.put(details, totalAmount);
                continue;
            }
            AEProcessingPattern processingPattern = (AEProcessingPattern)details;
            boolean allowScaling = false;
            int perCraftLimit = 0;
            if (processingPattern instanceof ISmartDoublingAwarePattern) {
                ISmartDoublingAwarePattern aware = (ISmartDoublingAwarePattern)processingPattern;
                allowScaling = aware.eap$allowScaling();
                perCraftLimit = aware.eap$getMultiplierLimit();
            }
            if (!allowScaling || totalAmount <= 1L) {
                finalCrafts.put(processingPattern, totalAmount);
                continue;
            }
            if (perCraftLimit <= 0 && ModConfig.INSTANCE.smartScalingMaxMultiplier > 0) {
                perCraftLimit = ModConfig.INSTANCE.smartScalingMaxMultiplier;
            }
            if (perCraftLimit <= 0) {
                if (ModConfig.INSTANCE.providerRoundRobinEnable) {
                    long countBase;
                    CraftingService craftingService = (CraftingService)((ICraftingCalculationExt)calculation).getGrid().getCraftingService();
                    int providerCount = Math.max(Iterables.size((Iterable)craftingService.getProviders((IPatternDetails)processingPattern)), 1);
                    if (totalAmount < (long)providerCount) {
                        providerCount = (int)totalAmount;
                    }
                    long base = totalAmount / (long)providerCount;
                    long remainder = totalAmount % (long)providerCount;
                    if (remainder > 0L) {
                        ScaledProcessingPattern scaledPlus = PatternScaler.createScaled(processingPattern, base + 1L);
                        finalCrafts.merge(scaledPlus, remainder, Long::sum);
                    }
                    if ((countBase = (long)providerCount - remainder) <= 0L) continue;
                    ScaledProcessingPattern scaledBase = PatternScaler.createScaled(processingPattern, base);
                    finalCrafts.merge(scaledBase, countBase, Long::sum);
                    continue;
                }
                ScaledProcessingPattern scaled = PatternScaler.createScaled(processingPattern, totalAmount);
                finalCrafts.put(scaled, 1L);
                continue;
            }
            long fullCrafts = totalAmount / (long)perCraftLimit;
            long remainder = totalAmount % (long)perCraftLimit;
            if (fullCrafts > 0L) {
                ScaledProcessingPattern scaledFull = PatternScaler.createScaled(processingPattern, perCraftLimit);
                finalCrafts.put(scaledFull, fullCrafts);
            }
            if (remainder <= 0L) continue;
            ScaledProcessingPattern scaledRem = PatternScaler.createScaled(processingPattern, remainder);
            finalCrafts.put(scaledRem, 1L);
        }
        crafts.clear();
        crafts.putAll(finalCrafts);
    }
}

