/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.mixin.ae2.helpers.patternprovider;

import appeng.api.crafting.IPatternDetails;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.helpers.patternprovider.PatternProviderLogic;
import com.extendedae_plus.api.smartDoubling.ISmartDoublingAwarePattern;
import com.extendedae_plus.api.smartDoubling.ISmartDoublingHolder;
import com.extendedae_plus.mixin.ae2.accessor.PatternProviderLogicAccessor;
import com.extendedae_plus.util.smartDoubling.PatternScaler;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PatternProviderLogic.class}, remap=false)
public class PatternProviderLogicDoublingMixin
implements ISmartDoublingHolder {
    @Unique
    private static final String EAP_SMART_DOUBLING_KEY = "eap_smart_doubling";
    @Unique
    private static final String EAP_PROVIDER_SCALING_LIMIT = "eap_provider_scaling_limit";
    @Unique
    private boolean eap$smartDoubling = false;
    @Unique
    private int eap$providerScalingLimit = 0;

    @Override
    public boolean eap$getSmartDoubling() {
        return this.eap$smartDoubling;
    }

    @Override
    public void eap$setSmartDoubling(boolean value) {
        this.eap$smartDoubling = value;
        try {
            ((PatternProviderLogic)this).updatePatterns();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public int eap$getProviderSmartDoublingLimit() {
        return this.eap$providerScalingLimit;
    }

    @Override
    public void eap$setProviderSmartDoublingLimit(int limit) {
        this.eap$providerScalingLimit = limit;
        try {
            ((PatternProviderLogic)this).updatePatterns();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Inject(method={"writeToNBT"}, at={@At(value="TAIL")})
    private void eap$writeSmartDoublingToNbt(CompoundTag tag, CallbackInfo ci) {
        tag.m_128379_(EAP_SMART_DOUBLING_KEY, this.eap$smartDoubling);
        tag.m_128405_(EAP_PROVIDER_SCALING_LIMIT, this.eap$providerScalingLimit);
    }

    @Inject(method={"readFromNBT"}, at={@At(value="TAIL")})
    private void eap$readSmartDoublingFromNbt(CompoundTag tag, CallbackInfo ci) {
        if (tag.m_128441_(EAP_SMART_DOUBLING_KEY)) {
            this.eap$smartDoubling = tag.m_128471_(EAP_SMART_DOUBLING_KEY);
        }
        if (tag.m_128441_(EAP_PROVIDER_SCALING_LIMIT)) {
            this.eap$providerScalingLimit = tag.m_128451_(EAP_PROVIDER_SCALING_LIMIT);
        }
    }

    @Inject(method={"updatePatterns"}, at={@At(value="TAIL")})
    private void eap$applySmartDoublingToPatterns(CallbackInfo ci) {
        try {
            List<IPatternDetails> list = ((PatternProviderLogicAccessor)((Object)this)).eap$patterns();
            boolean allow = this.eap$smartDoubling;
            int limit = this.eap$providerScalingLimit;
            for (IPatternDetails details : list) {
                AEProcessingPattern proc;
                if (!(details instanceof AEProcessingPattern) || !((proc = (AEProcessingPattern)details) instanceof ISmartDoublingAwarePattern)) continue;
                ISmartDoublingAwarePattern pattern = (ISmartDoublingAwarePattern)proc;
                pattern.eap$setAllowScaling(allow);
                pattern.eap$setMultiplierLimit(PatternScaler.getComputedMul(proc, limit));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Shadow
    public void saveChanges() {
    }

    @Inject(method={"exportSettings(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void onExportSettings(CompoundTag output, CallbackInfo ci) {
        output.m_128379_(EAP_SMART_DOUBLING_KEY, this.eap$smartDoubling);
        output.m_128405_(EAP_PROVIDER_SCALING_LIMIT, this.eap$providerScalingLimit);
    }

    @Inject(method={"importSettings(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="TAIL")})
    private void onImportSettings(CompoundTag input, Player player, CallbackInfo ci) {
        if (input.m_128441_(EAP_SMART_DOUBLING_KEY)) {
            this.eap$smartDoubling = input.m_128471_(EAP_SMART_DOUBLING_KEY);
            this.saveChanges();
        }
        if (input.m_128441_(EAP_PROVIDER_SCALING_LIMIT)) {
            this.eap$providerScalingLimit = input.m_128451_(EAP_PROVIDER_SCALING_LIMIT);
            this.saveChanges();
        }
    }
}

