/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.mixin.ae2.items;

import appeng.api.inventories.InternalInventory;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.core.localization.PlayerMessages;
import appeng.items.contents.NetworkToolMenuHost;
import appeng.items.tools.MemoryCardItem;
import appeng.items.tools.NetworkToolItem;
import appeng.util.inv.PlayerInternalInventory;
import com.extendedae_plus.ae.parts.EntitySpeedTickerPart;
import com.extendedae_plus.init.ModItems;
import java.util.ArrayList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MemoryCardItem.class}, remap=false)
public class MemoryCardItemMixin {
    @Inject(method={"storeUpgrades"}, at={@At(value="HEAD")}, cancellable=true)
    private static void storeUpgradesCustom(IUpgradeableObject upgradeableObject, CompoundTag output, CallbackInfo ci) {
        try {
            CompoundTag desiredUpgradesTag = new CompoundTag();
            ListTag entitySpeedCards = new ListTag();
            IUpgradeInventory upgrades = upgradeableObject.getUpgrades();
            for (int i = 0; i < upgrades.size(); ++i) {
                ItemStack upgradeStack = upgrades.getStackInSlot(i);
                if (upgradeStack.m_41619_()) continue;
                ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)upgradeStack.m_41720_());
                String key = itemId.toString();
                if (upgradeStack.m_41720_().equals(ModItems.ENTITY_SPEED_CARD.get())) {
                    CompoundTag stackTag = new CompoundTag();
                    stackTag.m_128405_("Slot", i);
                    upgradeStack.m_41739_(stackTag);
                    entitySpeedCards.add((Object)stackTag);
                    continue;
                }
                desiredUpgradesTag.m_128405_(key, desiredUpgradesTag.m_128451_(key) + upgradeStack.m_41613_());
            }
            if (!entitySpeedCards.isEmpty()) {
                desiredUpgradesTag.m_128365_("entity_speed_cards", (Tag)entitySpeedCards);
            }
            output.m_128365_("upgrades", (Tag)desiredUpgradesTag);
            ci.cancel();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Inject(method={"restoreUpgrades"}, at={@At(value="HEAD")}, cancellable=true)
    private static void restoreUpgradesCustom(Player player, CompoundTag input, IUpgradeableObject upgradeableObject, CallbackInfoReturnable<Boolean> cir) {
        try {
            ItemStack cards;
            if (!input.m_128441_("upgrades")) {
                cir.setReturnValue((Object)false);
                return;
            }
            CompoundTag desiredUpgradesTag = input.m_128469_("upgrades");
            IUpgradeInventory upgrades = upgradeableObject.getUpgrades();
            ArrayList<Object> upgradeSources = new ArrayList<Object>();
            upgradeSources.add(new PlayerInternalInventory(player.m_150109_()));
            NetworkToolMenuHost networkTool = NetworkToolItem.findNetworkToolInv((Player)player);
            if (networkTool != null) {
                upgradeSources.add(networkTool.getInventory());
            }
            for (int i = 0; i < upgrades.size(); ++i) {
                ItemStack stack = upgrades.getStackInSlot(i);
                if (stack.m_41619_() || !stack.m_41720_().equals(ModItems.ENTITY_SPEED_CARD.get())) continue;
                ItemStack removed = upgrades.extractItem(i, stack.m_41613_(), false);
                for (InternalInventory internalInventory : upgradeSources) {
                    if (removed.m_41619_()) continue;
                    removed = internalInventory.addItems(removed);
                }
                if (removed.m_41619_()) continue;
                player.m_36176_(removed, false);
            }
            if (desiredUpgradesTag.m_128425_("entity_speed_cards", 9)) {
                ListTag entitySpeedCards = desiredUpgradesTag.m_128437_("entity_speed_cards", 10);
                for (int i = 0; i < entitySpeedCards.size(); ++i) {
                    int n;
                    CompoundTag stackTag = entitySpeedCards.m_128728_(i);
                    ItemStack desiredStack = ItemStack.m_41712_((CompoundTag)stackTag);
                    int n2 = n = stackTag.m_128441_("Slot") ? stackTag.m_128451_("Slot") : i;
                    if (player.m_150110_().f_35937_) {
                        if (n >= 0 && n < upgrades.size()) {
                            upgrades.setItemDirect(n, desiredStack);
                            continue;
                        }
                        upgrades.addItems(desiredStack);
                        continue;
                    }
                    int missingAmount = desiredStack.m_41613_();
                    ItemStack extracted = ItemStack.f_41583_;
                    for (InternalInventory internalInventory : upgradeSources) {
                        ItemStack itemStack = new ItemStack((ItemLike)desiredStack.m_41720_(), missingAmount);
                        if (desiredStack.m_41782_()) {
                            itemStack.m_41751_(desiredStack.m_41783_().m_6426_());
                        }
                        if (!(cards = internalInventory.removeItems(missingAmount, itemStack, null)).m_41619_()) {
                            ItemStack overflow = upgrades.addItems(cards);
                            if (!overflow.m_41619_()) {
                                player.m_150109_().m_150079_(overflow);
                            }
                            missingAmount -= cards.m_41613_();
                            extracted = cards;
                        }
                        if (missingAmount > 0) continue;
                        break;
                    }
                    if (missingAmount > 0 && !player.m_9236_().m_5776_()) {
                        player.m_5661_((Component)PlayerMessages.MissingUpgrades.text(new Object[]{desiredStack.m_41720_().m_41466_(), missingAmount}), true);
                        continue;
                    }
                    if (extracted.m_41619_()) continue;
                    if (n >= 0 && n < upgrades.size()) {
                        upgrades.setItemDirect(n, extracted);
                        continue;
                    }
                    upgrades.addItems(extracted);
                }
            }
            for (String key : desiredUpgradesTag.m_128431_()) {
                int n;
                ResourceLocation id;
                try {
                    id = new ResourceLocation(key);
                }
                catch (Exception ex) {
                    continue;
                }
                Item item = BuiltInRegistries.f_257033_.m_6612_(id).orElse(null);
                if (item == null || item.equals(ModItems.ENTITY_SPEED_CARD.get()) || (n = desiredUpgradesTag.m_128451_(key)) <= 0) continue;
                if (player.m_150110_().f_35937_) {
                    ItemStack stack = new ItemStack((ItemLike)item, n);
                    upgrades.addItems(stack);
                    continue;
                }
                int missingAmount = n;
                ItemStack potential = new ItemStack((ItemLike)item, missingAmount);
                ItemStack overflow = upgrades.addItems(potential, true);
                if (!overflow.m_41619_()) {
                    missingAmount -= overflow.m_41613_();
                }
                for (InternalInventory internalInventory : upgradeSources) {
                    cards = internalInventory.removeItems(missingAmount, potential, null);
                    if (!cards.m_41619_()) {
                        overflow = upgrades.addItems(cards);
                        if (!overflow.m_41619_()) {
                            player.m_150109_().m_150079_(overflow);
                        }
                        missingAmount -= cards.m_41613_();
                    }
                    if (missingAmount > 0) continue;
                    break;
                }
                if (missingAmount <= 0 || player.m_9236_().m_5776_()) continue;
                player.m_5661_((Component)PlayerMessages.MissingUpgrades.text(new Object[]{item.m_41466_(), missingAmount}), true);
            }
            if (upgradeableObject instanceof EntitySpeedTickerPart) {
                EntitySpeedTickerPart speedTickerPart = (EntitySpeedTickerPart)upgradeableObject;
                BlockEntity be = speedTickerPart.getBlockEntity();
                if (be != null) {
                    be.m_6596_();
                }
                speedTickerPart.upgradesChanged();
            }
            cir.setReturnValue((Object)true);
        }
        catch (Exception e) {
            e.printStackTrace();
            cir.setReturnValue((Object)false);
        }
    }
}

