/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.mixin.jei;

import appeng.integration.modules.jei.transfer.EncodePatternTransferHandler;
import appeng.integration.modules.jeirei.EncodingHelper;
import appeng.menu.me.items.PatternEncodingTermMenu;
import com.extendedae_plus.util.uploadPattern.RecipeTypeNameConfig;
import java.lang.reflect.Field;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EncodePatternTransferHandler.class}, remap=false)
public abstract class EncodePatternTransferHandlerMixin {
    @Inject(method={"transferRecipe"}, at={@At(value="HEAD")}, require=0)
    private void eap$captureProcessingName(PatternEncodingTermMenu menu, Object recipeBase, IRecipeSlotsView slotsView, Player player, boolean maxTransfer, boolean doTransfer, CallbackInfoReturnable<IRecipeTransferError> cir) {
        if (!doTransfer) {
            return;
        }
        String name = null;
        if (recipeBase instanceof Recipe) {
            Recipe recipe = (Recipe)recipeBase;
            if (EncodingHelper.isSupportedCraftingRecipe((Recipe)recipe)) {
                return;
            }
            name = RecipeTypeNameConfig.mapRecipeTypeToSearchKey(recipe);
        } else if (recipeBase != null && "com.gregtechceu.gtceu.api.recipe.GTRecipe".equals(recipeBase.getClass().getName())) {
            name = RecipeTypeNameConfig.mapGTCEuRecipeToSearchKey(recipeBase);
        } else if ("com.gregtechceu.gtceu.integration.jei.recipe.GTRecipeWrapper".equals(recipeBase.getClass().getName())) {
            try {
                Field field = recipeBase.getClass().getField("recipe");
                Object inner = field.get(recipeBase);
                name = RecipeTypeNameConfig.mapGTCEuRecipeToSearchKey(inner);
            }
            catch (Throwable throwable) {}
        } else {
            name = RecipeTypeNameConfig.deriveSearchKeyFromUnknownRecipe(recipeBase);
        }
        if (name != null && !name.isBlank()) {
            RecipeTypeNameConfig.setLastProcessingName(name);
        }
    }
}

