/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import appeng.api.stacks.AEKey;
import com.extendedae_plus.content.ClientPatternHighlightStore;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class SetPatternHighlightS2CPacket {
    private final AEKey key;
    private final boolean highlight;

    public SetPatternHighlightS2CPacket(AEKey key, boolean highlight) {
        this.key = key;
        this.highlight = highlight;
    }

    public static void encode(SetPatternHighlightS2CPacket msg, FriendlyByteBuf buf) {
        AEKey.writeKey((FriendlyByteBuf)buf, (AEKey)msg.key);
        buf.writeBoolean(msg.highlight);
    }

    public static SetPatternHighlightS2CPacket decode(FriendlyByteBuf buf) {
        AEKey key = AEKey.readKey((FriendlyByteBuf)buf);
        boolean h = buf.readBoolean();
        return new SetPatternHighlightS2CPacket(key, h);
    }

    public static void handle(SetPatternHighlightS2CPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            try {
                ClientPatternHighlightStore.setHighlight(msg.key, msg.highlight);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        ctx.setPacketHandled(true);
    }
}

