/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import appeng.menu.me.items.PatternEncodingTermMenu;
import com.extendedae_plus.util.uploadPattern.ProviderUploadUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class UploadEncodedPatternToProviderC2SPacket {
    private final long providerId;

    public UploadEncodedPatternToProviderC2SPacket(long providerId) {
        this.providerId = providerId;
    }

    public static void encode(UploadEncodedPatternToProviderC2SPacket msg, FriendlyByteBuf buf) {
        buf.writeLong(msg.providerId);
    }

    public static UploadEncodedPatternToProviderC2SPacket decode(FriendlyByteBuf buf) {
        return new UploadEncodedPatternToProviderC2SPacket(buf.readLong());
    }

    public static void handle(UploadEncodedPatternToProviderC2SPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            if (player == null) {
                return;
            }
            AbstractContainerMenu patt0$temp = player.f_36096_;
            if (!(patt0$temp instanceof PatternEncodingTermMenu)) {
                return;
            }
            PatternEncodingTermMenu menu = (PatternEncodingTermMenu)patt0$temp;
            if (msg.providerId >= 0L) {
                ProviderUploadUtil.uploadFromEncodingMenuToProvider(player, menu, msg.providerId);
            } else {
                int index = (int)(-1L - msg.providerId);
                ProviderUploadUtil.uploadFromEncodingMenuToProviderByIndex(player, menu, index);
            }
        });
        ctx.setPacketHandled(true);
    }
}

