/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network.crafting;

import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.security.IActionHost;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.me.service.CraftingService;
import appeng.menu.AEBaseMenu;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.crafting.CraftingCPUMenu;
import appeng.parts.AEBasePart;
import com.extendedae_plus.init.ModNetwork;
import com.extendedae_plus.mixin.ae2.accessor.PatternProviderLogicAccessor;
import com.extendedae_plus.network.SetBlockHighlightS2CPacket;
import com.extendedae_plus.network.SetPatternHighlightS2CPacket;
import com.extendedae_plus.network.provider.SetProviderPageS2CPacket;
import com.extendedae_plus.util.PatternProviderDataUtil;
import com.glodblock.github.glodium.util.GlodUtil;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class CraftingMonitorOpenProviderC2SPacket {
    private final AEKey what;

    public CraftingMonitorOpenProviderC2SPacket(AEKey what) {
        this.what = what;
    }

    public static void encode(CraftingMonitorOpenProviderC2SPacket msg, FriendlyByteBuf buf) {
        AEKey.writeKey((FriendlyByteBuf)buf, (AEKey)msg.what);
    }

    public static CraftingMonitorOpenProviderC2SPacket decode(FriendlyByteBuf buf) {
        return new CraftingMonitorOpenProviderC2SPacket(AEKey.readKey((FriendlyByteBuf)buf));
    }

    public static void handle(CraftingMonitorOpenProviderC2SPacket msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            AbstractContainerMenu patt0$temp;
            ServerPlayer player = context.getSender();
            if (player == null || !((patt0$temp = player.f_36096_) instanceof CraftingCPUMenu)) {
                return;
            }
            CraftingCPUMenu menu = (CraftingCPUMenu)patt0$temp;
            IGrid grid = GridHelper.getGridFromMenu((AEBaseMenu)menu);
            if (grid == null) {
                return;
            }
            ICraftingService cs = grid.getCraftingService();
            if (!(cs instanceof CraftingService)) {
                return;
            }
            CraftingService craftingService = (CraftingService)cs;
            Collection patterns = craftingService.getCraftingFor(msg.what);
            if (patterns.isEmpty()) {
                return;
            }
            for (IPatternDetails pattern : patterns) {
                PatternProviderLogic provider = PatternLocator.findValidProvider(craftingService, pattern, grid);
                if (provider == null) continue;
                try {
                    ProviderUIHelper.openProviderUI(provider, pattern, player);
                }
                catch (Exception exception) {}
            }
        });
        context.setPacketHandled(true);
    }

    private static final class GridHelper {
        private GridHelper() {
        }

        private static IGrid getGridFromMenu(AEBaseMenu menu) {
            IActionHost host;
            Object target = menu.getTarget();
            if (target instanceof IActionHost && (host = (IActionHost)target).getActionableNode() != null) {
                return host.getActionableNode().getGrid();
            }
            return null;
        }
    }

    private static final class PatternLocator {
        private PatternLocator() {
        }

        private static PatternProviderLogic findValidProvider(CraftingService cs, IPatternDetails pattern, IGrid grid) {
            Iterable providers = cs.getProviders(pattern);
            for (ICraftingProvider provider : providers) {
                PatternProviderLogic ppl;
                PatternProviderLogicHost host;
                if (!(provider instanceof PatternProviderLogic) || (host = ((PatternProviderLogicAccessor)(ppl = (PatternProviderLogic)provider)).eap$host()) == null || host.getBlockEntity() == null || !PatternProviderDataUtil.isProviderAvailable(ppl, grid)) continue;
                return ppl;
            }
            return null;
        }
    }

    private static final class ProviderUIHelper {
        private ProviderUIHelper() {
        }

        private static void openProviderUI(PatternProviderLogic provider, IPatternDetails pattern, ServerPlayer player) {
            GenericStack[] outputs;
            int page;
            boolean bl;
            PatternProviderLogicHost host = ((PatternProviderLogicAccessor)provider).eap$host();
            BlockEntity pbe = host.getBlockEntity();
            if (pbe == null) {
                return;
            }
            if (host instanceof AEBasePart) {
                AEBasePart part = (AEBasePart)host;
                bl = true;
            } else {
                bl = false;
            }
            boolean isPart = bl;
            MenuLocator locator = isPart ? MenuLocators.forPart((AEBasePart)((AEBasePart)host)) : MenuLocators.forBlockEntity((BlockEntity)pbe);
            host.openMenu((Player)player, locator);
            ModNetwork.CHANNEL.sendTo((Object)new SetBlockHighlightS2CPacket(pbe.m_58899_(), isPart ? ((AEBasePart)host).getSide() : null, pbe.m_58904_().m_46472_().m_135782_(), (long)(6000.0 * GlodUtil.clamp((double)1.0, (double)1.0, (double)30.0))), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            player.m_5661_((Component)Component.m_237110_((String)"chat.extendedae_plus.terminal.pos", (Object[])new Object[]{pbe.m_58899_().m_123344_(), pbe.m_58904_().m_46472_().m_135782_().m_135815_(), (int)Math.sqrt(player.m_20183_().m_123331_((Vec3i)host.getBlockEntity().m_58899_()))}), false);
            int slot = PatternProviderDataUtil.findSlotForPattern(provider, pattern.getDefinition());
            if (slot >= 0 && (page = slot / 36) > 0) {
                ModNetwork.CHANNEL.sendTo((Object)new SetProviderPageS2CPacket(page), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
            if ((outputs = pattern.getOutputs()) != null && outputs.length > 0 && outputs[0] != null) {
                AEKey key = outputs[0].what();
                ModNetwork.CHANNEL.sendTo((Object)new SetPatternHighlightS2CPacket(key, true), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }
}

