/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util;

import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;

public class ModCheckUtils {
    private static final LoadingModList MOD_LIST = LoadingModList.get();
    public static final String MODID_JEI = "jei";
    public static final String MODID_EMI = "emi";
    public static final String MODID_AE = "ae2";
    public static final String MODID_AAE = "advanced_ae";
    public static final String MODID_AE2WTLIB = "ae2wtlib";
    public static final String MODID_FTB_TEAMS = "ftbteams";
    public static final String MODID_APPFLUX = "appflux";
    public static final String MODID_GUIDEME = "guideme";
    public static final String MODID_MAE2 = "mae2";
    public static final String MODID_MEGA = "megacells";
    public static final String MODID_EPA = "expandedae";

    public static boolean isLoaded(String modid) {
        return MOD_LIST != null && MOD_LIST.getModFileById(modid) != null;
    }

    public static String getVersion(String modid) {
        if (MOD_LIST == null) {
            return "0.0.0";
        }
        ModFileInfo file = MOD_LIST.getModFileById(modid);
        if (file == null || file.getMods().isEmpty()) {
            return "0.0.0";
        }
        return ((IModInfo)file.getMods().get(0)).getVersion().toString();
    }

    public static boolean isLoadedAndLowerThan(String modid, String targetVersion) {
        if (!ModCheckUtils.isLoaded(modid)) {
            return false;
        }
        return ModCheckUtils.isVersionLower(ModCheckUtils.getVersion(modid), targetVersion);
    }

    public static boolean isVersionLower(String current, String target) {
        if (current == null || target == null) {
            return false;
        }
        String[] curParts = current.split("\\.");
        String[] tarParts = target.split("\\.");
        for (int i = 0; i < 3; ++i) {
            int tarNum;
            int curNum = i < curParts.length ? ModCheckUtils.parse(curParts[i]) : 0;
            int n = tarNum = i < tarParts.length ? ModCheckUtils.parse(tarParts[i]) : 0;
            if (curNum < tarNum) {
                return true;
            }
            if (curNum <= tarNum) continue;
            return false;
        }
        return false;
    }

    private static int parse(String s) {
        try {
            return Integer.parseInt(s.replaceAll("[^0-9]", ""));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static boolean isAppfluxLoading() {
        return ModCheckUtils.isLoaded(MODID_APPFLUX);
    }

    public static boolean isAAELoading() {
        return ModCheckUtils.isLoaded(MODID_AAE);
    }
}

