/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IManagedGridNode;
import appeng.helpers.patternprovider.PatternContainer;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.menu.implementations.PatternAccessTermMenu;
import com.extendedae_plus.mixin.ae2.accessor.PatternProviderLogicAccessor;
import com.extendedae_plus.util.PatternTerminalUtil;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public final class PatternProviderDataUtil {
    private static final int INVALID_SLOT = -1;
    private static final String UNKNOWN_PROVIDER = "\u672a\u77e5\u4f9b\u5e94\u5668";

    private PatternProviderDataUtil() {
    }

    public static boolean isProviderAvailable(@NotNull PatternProviderLogic provider, @NotNull IGrid expectedGrid) {
        try {
            IGrid grid = provider.getGrid();
            if (grid == null || !grid.equals((Object)expectedGrid)) {
                return false;
            }
            if (provider instanceof PatternProviderLogicAccessor) {
                PatternProviderLogicAccessor accessor = (PatternProviderLogicAccessor)provider;
                IManagedGridNode mainNode = accessor.eap$mainNode();
                return mainNode != null && mainNode.isActive();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isProviderAvailable(long providerId, PatternAccessTermMenu menu) {
        PatternContainer container = PatternTerminalUtil.getPatternContainerById(menu, providerId);
        if (container == null) {
            return false;
        }
        if (!container.isVisibleInTerminal()) {
            return false;
        }
        return container.getGrid() != null;
    }

    public static int findSlotForPattern(@Nullable PatternProviderLogic provider, @Nullable Object targetDefinition) {
        if (provider == null || targetDefinition == null) {
            return -1;
        }
        InternalInventory inv = provider.getPatternInv();
        if (inv == null || inv.isEmpty()) {
            return -1;
        }
        Level level = PatternProviderDataUtil.getPatternProviderLevel(provider);
        if (level == null) {
            return -1;
        }
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.m_41619_() || !stack.m_41782_()) continue;
            try {
                IPatternDetails details = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)level);
                if (details == null || !targetDefinition.equals(details.getDefinition())) continue;
                return i;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    @Nullable
    private static Level getPatternProviderLevel(@Nullable PatternProviderLogic provider) {
        if (!(provider instanceof PatternProviderLogicAccessor)) {
            return null;
        }
        PatternProviderLogicAccessor accessor = (PatternProviderLogicAccessor)provider;
        PatternProviderLogicHost host = accessor.eap$host();
        if (host == null) {
            return null;
        }
        BlockEntity be = host.getBlockEntity();
        return be != null ? be.m_58904_() : null;
    }

    public static int getAvailableSlots(long providerId, PatternAccessTermMenu menu) {
        PatternContainer container = PatternTerminalUtil.getPatternContainerById(menu, providerId);
        return PatternProviderDataUtil.getAvailableSlots(container);
    }

    public static int getAvailableSlots(@Nullable PatternContainer container) {
        if (container == null) {
            return -1;
        }
        InternalInventory inv = container.getTerminalPatternInventory();
        if (inv == null) {
            return -1;
        }
        int available = 0;
        for (int i = 0; i < inv.size(); ++i) {
            if (!inv.getStackInSlot(i).m_41619_()) continue;
            ++available;
        }
        return available;
    }

    public static String getProviderDisplayName(long providerId, PatternAccessTermMenu menu) {
        PatternContainer container = PatternTerminalUtil.getPatternContainerById(menu, providerId);
        return PatternProviderDataUtil.getProviderDisplayName(container, providerId);
    }

    public static String getProviderDisplayName(@Nullable PatternContainer container) {
        return PatternProviderDataUtil.getProviderDisplayName(container, -1L);
    }

    private static String getProviderDisplayName(@Nullable PatternContainer container, long providerId) {
        if (container == null) {
            return UNKNOWN_PROVIDER;
        }
        try {
            PatternContainerGroup group = container.getTerminalGroup();
            if (group != null) {
                return Component.Serializer.m_130703_((Component)group.name());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return providerId > 0L ? "\u6837\u677f\u4f9b\u5e94\u5668 #" + providerId : "\u6837\u677f\u4f9b\u5e94\u5668";
    }
}

