/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util.uploadPattern;

import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.inventories.InternalInventory;
import appeng.helpers.patternprovider.PatternContainer;
import appeng.menu.implementations.PatternAccessTermMenu;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import com.extendedae_plus.mixin.ae2.accessor.PatternEncodingTermMenuAccessor;
import com.extendedae_plus.util.PatternProviderDataUtil;
import com.extendedae_plus.util.PatternTerminalUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public final class ProviderUploadUtil {
    private ProviderUploadUtil() {
    }

    private static void sendMessage(ServerPlayer player, String message) {
    }

    public static boolean uploadPatternToProvider(ServerPlayer player, int playerSlotIndex, long providerId) {
        PatternAccessTermMenu menu = PatternTerminalUtil.getPatternAccessMenu(player);
        if (menu == null) {
            ProviderUploadUtil.sendMessage(player, "ExtendedAE Plus: \u8bf7\u5148\u6253\u5f00\u6837\u677f\u8bbf\u95ee\u7ec8\u7aef\u6216\u6269\u5c55\u6837\u677f\u7ba1\u7406\u7ec8\u7aef");
            return false;
        }
        ItemStack playerItem = player.m_150109_().m_8020_(playerSlotIndex);
        if (playerItem.m_41619_()) {
            ProviderUploadUtil.sendMessage(player, "ExtendedAE Plus: \u80cc\u5305\u69fd\u4f4d\u4e3a\u7a7a");
            return false;
        }
        if (!PatternDetailsHelper.isEncodedPattern((ItemStack)playerItem)) {
            ProviderUploadUtil.sendMessage(player, "ExtendedAE Plus: \u8be5\u7269\u54c1\u4e0d\u662f\u6709\u6548\u7684\u7f16\u7801\u6837\u677f");
            return false;
        }
        PatternContainer patternContainer = PatternTerminalUtil.getPatternContainerById(menu, providerId);
        if (patternContainer == null) {
            ProviderUploadUtil.sendMessage(player, "ExtendedAE Plus: \u627e\u4e0d\u5230\u6307\u5b9a\u7684\u6837\u677f\u4f9b\u5e94\u5668 (ID: " + providerId + ")");
            return false;
        }
        InternalInventory patternInventory = patternContainer.getTerminalPatternInventory();
        if (patternInventory == null) {
            ProviderUploadUtil.sendMessage(player, "ExtendedAE Plus: \u65e0\u6cd5\u8bbf\u95ee\u6837\u677f\u4f9b\u5e94\u5668\u7684\u5e93\u5b58");
            return false;
        }
        ExtendedAEPatternFilter patternFilter = new ExtendedAEPatternFilter();
        FilteredInternalInventory filteredInventory = new FilteredInternalInventory(patternInventory, (IAEItemFilter)patternFilter);
        ItemStack itemToInsert = playerItem.m_41777_();
        ItemStack remaining = filteredInventory.addItems(itemToInsert);
        if (remaining.m_41613_() < itemToInsert.m_41613_()) {
            int insertedCount = itemToInsert.m_41613_() - remaining.m_41613_();
            playerItem.m_41774_(insertedCount);
            if (playerItem.m_41619_()) {
                player.m_150109_().m_6836_(playerSlotIndex, ItemStack.f_41583_);
            }
            String terminalType = PatternTerminalUtil.isExtendedAETerminal(player) ? "\u6269\u5c55\u6837\u677f\u7ba1\u7406\u7ec8\u7aef" : "\u6837\u677f\u8bbf\u95ee\u7ec8\u7aef";
            ProviderUploadUtil.sendMessage(player, "ExtendedAE Plus: \u901a\u8fc7" + terminalType + "\u6210\u529f\u4e0a\u4f20 " + insertedCount + " \u4e2a\u6837\u677f");
            return true;
        }
        ProviderUploadUtil.sendMessage(player, "ExtendedAE Plus: \u4e0a\u4f20\u5931\u8d25 - \u6837\u677f\u4f9b\u5e94\u5668\u5df2\u6ee1\u6216\u6837\u677f\u65e0\u6548");
        return false;
    }

    public static boolean uploadFromEncodingMenuToProvider(ServerPlayer player, PatternEncodingTermMenu menu, long providerId) {
        if (player == null || menu == null) {
            return false;
        }
        RestrictedInputSlot encodedSlot = ((PatternEncodingTermMenuAccessor)menu).eap$getEncodedPatternSlot();
        ItemStack stack = encodedSlot.m_7993_();
        if (stack.m_41619_() || !PatternDetailsHelper.isEncodedPattern((ItemStack)stack)) {
            return false;
        }
        PatternAccessTermMenu accessMenu = PatternTerminalUtil.getPatternAccessMenu(player);
        if (accessMenu == null) {
            return false;
        }
        String targetName = PatternProviderDataUtil.getProviderDisplayName(providerId, accessMenu);
        ArrayList<Long> tryIds = new ArrayList<Long>();
        tryIds.add(providerId);
        try {
            List<Long> all = PatternTerminalUtil.getAllProviderIds(accessMenu);
            for (Long id : all) {
                String name;
                if (id == null || id == providerId || (name = PatternProviderDataUtil.getProviderDisplayName(id, accessMenu)) == null || !name.equals(targetName)) continue;
                tryIds.add(id);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (Long id : tryIds) {
            ItemStack toInsert;
            FilteredInternalInventory filtered;
            ItemStack remain;
            InternalInventory inv;
            PatternContainer c = PatternTerminalUtil.getPatternContainerById(accessMenu, id);
            if (c == null || !c.isVisibleInTerminal() || (inv = c.getTerminalPatternInventory()) == null || inv.size() <= 0 || (remain = (filtered = new FilteredInternalInventory(inv, (IAEItemFilter)new ExtendedAEPatternFilter())).addItems(toInsert = stack.m_41777_())).m_41613_() >= toInsert.m_41613_()) continue;
            int inserted = toInsert.m_41613_() - remain.m_41613_();
            stack.m_41774_(inserted);
            if (stack.m_41619_()) {
                encodedSlot.m_5852_(ItemStack.f_41583_);
            } else {
                encodedSlot.m_5852_(stack);
            }
            return true;
        }
        return false;
    }

    public static boolean uploadFromEncodingMenuToProviderByIndex(ServerPlayer player, PatternEncodingTermMenu menu, int index) {
        if (player == null || menu == null || index < 0) {
            return false;
        }
        List<PatternContainer> list = PatternTerminalUtil.listAvailableProvidersFromGrid(menu);
        if (index >= list.size()) {
            return false;
        }
        PatternContainer container = list.get(index);
        if (container == null) {
            return false;
        }
        RestrictedInputSlot encodedSlot = ((PatternEncodingTermMenuAccessor)menu).eap$getEncodedPatternSlot();
        ItemStack stack = encodedSlot.m_7993_();
        if (stack.m_41619_() || !PatternDetailsHelper.isEncodedPattern((ItemStack)stack)) {
            return false;
        }
        String targetName = PatternProviderDataUtil.getProviderDisplayName(container);
        ArrayList<PatternContainer> tryList = new ArrayList<PatternContainer>();
        tryList.add(container);
        try {
            for (PatternContainer c : list) {
                String name;
                if (c == null || c == container || (name = PatternProviderDataUtil.getProviderDisplayName(c)) == null || !name.equals(targetName)) continue;
                tryList.add(c);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (PatternContainer c : tryList) {
            ItemStack toInsert;
            FilteredInternalInventory filtered;
            ItemStack remain;
            InternalInventory inv = c.getTerminalPatternInventory();
            if (inv == null || inv.size() <= 0 || (remain = (filtered = new FilteredInternalInventory(inv, (IAEItemFilter)new ExtendedAEPatternFilter())).addItems(toInsert = stack.m_41777_())).m_41613_() >= toInsert.m_41613_()) continue;
            int inserted = toInsert.m_41613_() - remain.m_41613_();
            stack.m_41774_(inserted);
            if (stack.m_41619_()) {
                encodedSlot.m_5852_(ItemStack.f_41583_);
            } else {
                encodedSlot.m_5852_(stack);
            }
            return true;
        }
        return false;
    }

    private static class ExtendedAEPatternFilter
    implements IAEItemFilter {
        private ExtendedAEPatternFilter() {
        }

        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return true;
        }

        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            return !stack.m_41619_() && PatternDetailsHelper.isEncodedPattern((ItemStack)stack);
        }
    }
}

