/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.ae.api.storage;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import com.extendedae_plus.ae.items.InfinityBigIntegerCellItem;
import com.extendedae_plus.util.ExtendedAELogger;
import com.extendedae_plus.util.storage.InfinityDataStorage;
import com.extendedae_plus.util.storage.InfinityStorageManager;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;

public class InfinityBigIntegerCellInventory
implements StorageCell {
    private static final ConcurrentLinkedQueue<InfinityBigIntegerCellInventory> PENDING_PERSIST = new ConcurrentLinkedQueue();
    private static final DecimalFormat DF = new DecimalFormat("#.##");
    private final ItemStack stack;
    private final ISaveProvider container;
    private Object2ObjectMap<AEKey, BigInteger> storedMap = null;
    private boolean isPersisted = true;
    private BigInteger totalStored = BigInteger.ZERO;

    private InfinityBigIntegerCellInventory(ItemStack stack, ISaveProvider saveProvider) {
        this.stack = stack;
        this.container = saveProvider;
        this.storedMap = null;
    }

    static InfinityBigIntegerCellInventory createInventory(ItemStack stack, ISaveProvider saveProvider) {
        if (stack.m_41720_() instanceof InfinityBigIntegerCellItem) {
            return new InfinityBigIntegerCellInventory(stack, saveProvider);
        }
        return null;
    }

    private static InfinityStorageManager getStorageInstance() {
        return InfinityStorageManager.INSTANCE;
    }

    public static void onServerTick(TickEvent.ServerTickEvent event) {
        InfinityBigIntegerCellInventory inv;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        while ((inv = PENDING_PERSIST.poll()) != null) {
            try {
                if (inv.isPersisted) continue;
                inv.persist();
            }
            catch (Throwable ignored) {
                ExtendedAELogger.LOGGER.info("InfinityBigIntegerCellInventory onServerTick error: {}", (Object)ignored.getMessage());
            }
        }
    }

    public static void onServerStopping(ServerStoppingEvent event) {
        InfinityBigIntegerCellInventory inv;
        while ((inv = PENDING_PERSIST.poll()) != null) {
            try {
                if (inv.isPersisted) continue;
                inv.persist();
            }
            catch (Throwable ignored) {
                ExtendedAELogger.LOGGER.info("InfinityBigIntegerCellInventory onServerStopping error1: {}", (Object)ignored.getMessage());
            }
        }
        try {
            InfinityStorageManager stor = InfinityBigIntegerCellInventory.getStorageInstance();
            if (stor != null) {
                stor.m_77762_();
            }
        }
        catch (Throwable ignored) {
            ExtendedAELogger.LOGGER.info("InfinityBigIntegerCellInventory onServerStopping error2: {}", (Object)ignored.getMessage());
        }
    }

    public static String formatBigInteger(BigInteger number) {
        int idx;
        BigDecimal bd = new BigDecimal(number);
        BigDecimal thousand = new BigDecimal(1000);
        String[] units = new String[]{"", "K", "M", "G", "T", "P", "E", "Z", "Y"};
        for (idx = 0; bd.compareTo(thousand) >= 0 && idx < units.length - 1; ++idx) {
            bd = bd.divide(thousand, 2, RoundingMode.HALF_UP);
        }
        if (idx == 0) {
            return bd.setScale(0, RoundingMode.DOWN).toPlainString();
        }
        return DF.format(bd.doubleValue()) + units[idx];
    }

    private InfinityDataStorage getCellStorage() {
        if (this.getUUID() == null) {
            return InfinityDataStorage.EMPTY;
        }
        return InfinityBigIntegerCellInventory.getStorageInstance().getOrCreateCell(this.getUUID());
    }

    public CellState getStatus() {
        if (this.getCellStoredMap().isEmpty()) {
            return CellState.EMPTY;
        }
        return CellState.NOT_EMPTY;
    }

    public double getIdleDrain() {
        return 512.0;
    }

    public Component getDescription() {
        return null;
    }

    public boolean hasUUID() {
        return this.stack.m_41782_() && this.stack.m_41784_().m_128441_("uuid");
    }

    public UUID getUUID() {
        if (this.hasUUID()) {
            return this.stack.m_41784_().m_128342_("uuid");
        }
        return null;
    }

    private Object2ObjectMap<AEKey, BigInteger> getCellStoredMap() {
        if (this.storedMap == null) {
            this.storedMap = new Object2ObjectOpenHashMap();
            this.loadCellStoredMap();
        }
        return this.storedMap;
    }

    private void loadCellStoredMap() {
        boolean corruptedTag = false;
        if (!this.stack.m_41782_()) {
            return;
        }
        ListTag keys = this.getCellStorage().keys;
        ListTag amounts = this.getCellStorage().amounts;
        int len = Math.min(keys.size(), amounts.size());
        for (int i = 0; i < len; ++i) {
            AEKey key = AEKey.fromTagGeneric((CompoundTag)keys.m_128728_(i));
            CompoundTag amtTag = amounts.m_128728_(i);
            try {
                BigInteger amount;
                if (amtTag.m_128441_("l")) {
                    long v = amtTag.m_128454_("l");
                    amount = BigInteger.valueOf(v);
                } else if (amtTag.m_128441_("s")) {
                    amount = new BigInteger(amtTag.m_128461_("s"));
                } else {
                    corruptedTag = true;
                    continue;
                }
                if (amount.compareTo(BigInteger.ZERO) <= 0 || key == null) {
                    corruptedTag = true;
                    continue;
                }
                this.storedMap.put((Object)key, (Object)amount);
                this.totalStored = this.totalStored.add(amount);
                continue;
            }
            catch (NumberFormatException ex) {
                corruptedTag = true;
            }
        }
        if (corruptedTag) {
            this.saveChanges();
        }
    }

    private void saveChanges() {
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else if (!PENDING_PERSIST.contains(this)) {
            PENDING_PERSIST.offer(this);
        }
    }

    public void getAvailableStacks(KeyCounter out) {
        BigInteger maxLong = BigInteger.valueOf(Long.MAX_VALUE);
        Object2ObjectMap<AEKey, BigInteger> map = this.getCellStoredMap();
        for (Object2ObjectMap.Entry entry : map.object2ObjectEntrySet()) {
            long delta;
            long toSet;
            AEKey key = (AEKey)entry.getKey();
            BigInteger value = (BigInteger)entry.getValue();
            long existing = out.get(key);
            BigInteger sum = BigInteger.valueOf(existing).add(value);
            long l = toSet = sum.compareTo(maxLong) > 0 ? Long.MAX_VALUE : sum.longValue();
            if (existing == Long.MAX_VALUE || (delta = toSet == Long.MAX_VALUE ? Long.MAX_VALUE - existing : toSet - existing) == 0L) continue;
            out.add(key, delta);
        }
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        Object2ObjectMap<AEKey, BigInteger> map = this.getCellStoredMap();
        if (map.isEmpty()) {
            if (this.hasUUID()) {
                InfinityBigIntegerCellInventory.getStorageInstance().removeCell(this.getUUID());
                if (this.stack.m_41783_() != null) {
                    this.stack.m_41783_().m_128473_("uuid");
                    this.stack.m_41783_().m_128473_("total");
                }
            }
            return;
        }
        ListTag amountTags = new ListTag();
        ListTag keys = new ListTag();
        for (Object2ObjectMap.Entry entry : map.object2ObjectEntrySet()) {
            BigInteger amount = (BigInteger)entry.getValue();
            if (amount.compareTo(BigInteger.ZERO) <= 0) continue;
            keys.add((Object)((AEKey)entry.getKey()).toTagGeneric());
            CompoundTag amt = new CompoundTag();
            if (amount.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0) {
                amt.m_128356_("l", amount.longValue());
            } else {
                amt.m_128359_("s", amount.toString());
            }
            amountTags.add((Object)amt);
        }
        if (keys.isEmpty()) {
            InfinityBigIntegerCellInventory.getStorageInstance().updateCell(this.getUUID(), new InfinityDataStorage());
        } else {
            InfinityBigIntegerCellInventory.getStorageInstance().modifyCell(this.getUUID(), keys, amountTags);
        }
        if (this.stack.m_41784_() != null) {
            if (this.totalStored.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0) {
                this.stack.m_41784_().m_128356_("total", this.totalStored.longValue());
            } else {
                this.stack.m_41784_().m_128359_("total", this.totalStored.toString());
            }
            int typesCount = this.getCellStoredMap().size();
            this.stack.m_41784_().m_128405_("types", typesCount);
        }
        this.isPersisted = true;
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        AEItemKey itemKey;
        if (amount == 0L) {
            return 0L;
        }
        if (what instanceof AEItemKey && (itemKey = (AEItemKey)what).getItem() instanceof InfinityBigIntegerCellItem) {
            return 0L;
        }
        if (!this.hasUUID()) {
            this.stack.m_41784_().m_128362_("uuid", UUID.randomUUID());
            InfinityBigIntegerCellInventory.getStorageInstance().getOrCreateCell(this.getUUID());
            this.getCellStoredMap();
        }
        Object2ObjectMap<AEKey, BigInteger> map = this.getCellStoredMap();
        BigInteger currentAmount = (BigInteger)map.getOrDefault((Object)what, (Object)BigInteger.ZERO);
        if (mode == Actionable.MODULATE) {
            BigInteger newAmount = currentAmount.add(BigInteger.valueOf(amount));
            map.put((Object)what, (Object)newAmount);
            this.totalStored = this.totalStored.add(BigInteger.valueOf(amount));
            this.saveChanges();
        }
        return amount;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        Object2ObjectMap<AEKey, BigInteger> map = this.getCellStoredMap();
        BigInteger currentAmount = (BigInteger)map.getOrDefault((Object)what, (Object)BigInteger.ZERO);
        if (currentAmount.compareTo(BigInteger.ZERO) > 0) {
            BigInteger requested = BigInteger.valueOf(amount);
            if (currentAmount.compareTo(requested) <= 0) {
                long ret = currentAmount.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0 ? Long.MAX_VALUE : currentAmount.longValue();
                if (mode == Actionable.MODULATE) {
                    map.remove((Object)what);
                    this.totalStored = this.totalStored.subtract(currentAmount);
                    this.saveChanges();
                }
                return ret;
            }
            if (mode == Actionable.MODULATE) {
                map.put((Object)what, (Object)currentAmount.subtract(requested));
                this.totalStored = this.totalStored.subtract(requested);
                this.saveChanges();
            }
            return amount;
        }
        return 0L;
    }

    public String getTotalStorage() {
        return InfinityBigIntegerCellInventory.formatBigInteger(this.totalStored);
    }
}

