/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.ae.menu;

import appeng.api.upgrades.IUpgradeableObject;
import appeng.core.definitions.AEItems;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.menu.slot.OptionalFakeSlot;
import com.extendedae_plus.ae.parts.EntitySpeedTickerPart;
import com.extendedae_plus.ae.screen.EntitySpeedTickerScreen;
import com.extendedae_plus.config.ModConfig;
import com.extendedae_plus.init.ModItems;
import com.extendedae_plus.init.ModMenuTypes;
import com.extendedae_plus.util.ConfigParsingUtils;
import com.extendedae_plus.util.PowerUtils;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.registries.ForgeRegistries;

public class EntitySpeedTickerMenu
extends UpgradeableMenu<EntitySpeedTickerPart> {
    @GuiSync(value=716)
    public boolean accelerateEnabled = true;
    @GuiSync(value=717)
    public int entitySpeedCardCount;
    @GuiSync(value=718)
    public int energyCardCount;
    @GuiSync(value=719)
    public int effectiveSpeed = 1;
    @GuiSync(value=720)
    public double multiplier = 1.0;
    @GuiSync(value=721)
    public boolean targetBlacklisted = false;

    public boolean getAccelerateEnabled() {
        return this.accelerateEnabled;
    }

    public void setAccelerateEnabled(boolean enabled) {
        this.accelerateEnabled = enabled;
    }

    public EntitySpeedTickerMenu(int id, Inventory ip, EntitySpeedTickerPart host) {
        super((MenuType)ModMenuTypes.ENTITY_TICKER_MENU.get(), id, ip, (IUpgradeableObject)host);
        ((EntitySpeedTickerPart)this.getHost()).menu = this;
        try {
            this.accelerateEnabled = ((EntitySpeedTickerPart)this.getHost()).getAccelerateEnabled();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onServerDataSync() {
        boolean blacklisted;
        Object object;
        block8: {
            super.onServerDataSync();
            this.entitySpeedCardCount = this.getUpgrades().getInstalledUpgrades((ItemLike)ModItems.ENTITY_SPEED_CARD.get());
            this.energyCardCount = this.getUpgrades().getInstalledUpgrades((ItemLike)AEItems.ENERGY_CARD);
            double mult = 1.0;
            try {
                BlockEntity target = ((EntitySpeedTickerPart)this.getHost()).getLevel().m_7702_(((EntitySpeedTickerPart)this.getHost()).getBlockEntity().m_58899_().m_121945_(((EntitySpeedTickerPart)this.getHost()).getSide()));
                if (target != null) {
                    String blockId = ForgeRegistries.BLOCKS.getKey((Object)target.m_58900_().m_60734_()).toString();
                    object = ConfigParsingUtils.getCachedMultiplierEntries(List.of(ModConfig.INSTANCE.entityTickerMultipliers)).iterator();
                    while (object.hasNext()) {
                        ConfigParsingUtils.MultiplierEntry me = (ConfigParsingUtils.MultiplierEntry)object.next();
                        if (!me.pattern.matcher(blockId).matches()) continue;
                        mult = Math.max(mult, me.multiplier);
                    }
                }
            }
            catch (Exception target) {
                // empty catch block
            }
            this.multiplier = mult;
            blacklisted = false;
            try {
                BlockEntity target = ((EntitySpeedTickerPart)this.getHost()).getLevel().m_7702_(((EntitySpeedTickerPart)this.getHost()).getBlockEntity().m_58899_().m_121945_(((EntitySpeedTickerPart)this.getHost()).getSide()));
                if (target == null) break block8;
                String blockId = ForgeRegistries.BLOCKS.getKey((Object)target.m_58900_().m_60734_()).toString();
                for (Pattern p : ConfigParsingUtils.getCachedBlacklist(List.of(ModConfig.INSTANCE.entityTickerBlackList))) {
                    if (!p.matcher(blockId).matches()) continue;
                    blacklisted = true;
                    break;
                }
            }
            catch (Exception target) {
                // empty catch block
            }
        }
        this.targetBlacklisted = blacklisted;
        this.effectiveSpeed = this.targetBlacklisted ? 0 : (int)PowerUtils.computeProductWithCapFromMenu(this, 8);
        if (this.isClientSide() && (object = Minecraft.m_91087_().f_91080_) instanceof EntitySpeedTickerScreen) {
            EntitySpeedTickerScreen screen = (EntitySpeedTickerScreen)((Object)object);
            screen.refreshGui();
        }
    }

    public void onSlotChange(Slot slot) {
        super.onSlotChange(slot);
        if (this.isClientSide()) {
            this.entitySpeedCardCount = this.getUpgrades().getInstalledUpgrades((ItemLike)ModItems.ENTITY_SPEED_CARD.get());
            this.energyCardCount = this.getUpgrades().getInstalledUpgrades((ItemLike)AEItems.ENERGY_CARD);
            this.effectiveSpeed = (int)PowerUtils.computeProductWithCapFromMenu(this, 8);
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof EntitySpeedTickerScreen) {
                EntitySpeedTickerScreen screen2 = (EntitySpeedTickerScreen)screen;
                screen2.refreshGui();
            }
        }
    }

    public void m_38946_() {
        for (Object o : this.f_38839_) {
            OptionalFakeSlot fs;
            if (!(o instanceof OptionalFakeSlot) || (fs = (OptionalFakeSlot)o).isSlotEnabled() || fs.getDisplayStack().m_41619_()) continue;
            fs.clearStack();
        }
        this.standardDetectAndSendChanges();
    }
}

