/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.ae.parts;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.core.definitions.AEItems;
import appeng.items.parts.PartModels;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import appeng.parts.automation.UpgradeablePart;
import com.extendedae_plus.ae.menu.EntitySpeedTickerMenu;
import com.extendedae_plus.config.ModConfig;
import com.extendedae_plus.init.ModItems;
import com.extendedae_plus.init.ModMenuTypes;
import com.extendedae_plus.util.ConfigParsingUtils;
import com.extendedae_plus.util.PowerUtils;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntitySpeedTickerPart
extends UpgradeablePart
implements IGridTickable,
MenuProvider,
IUpgradeableObject {
    public EntitySpeedTickerMenu menu;
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("extendedae_plus", "part/entity_speed_ticker_part");
    @PartModels
    public static final PartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("extendedae_plus", "part/entity_speed_ticker_off")});
    @PartModels
    public static final PartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("extendedae_plus", "part/entity_speed_ticker_on")});
    @PartModels
    public static final PartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("extendedae_plus", "part/entity_speed_ticker_has_channel")});
    private boolean accelerateEnabled = true;

    public EntitySpeedTickerPart(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).setIdlePowerUsage(1.0).addService(IGridTickable.class, (IGridNodeService)this);
    }

    public boolean getAccelerateEnabled() {
        return this.accelerateEnabled;
    }

    public void setAccelerateEnabled(boolean accelerateEnabled) {
        this.accelerateEnabled = accelerateEnabled;
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    public boolean onPartActivate(Player player, InteractionHand hand, Vec3 pos) {
        if (!player.m_20193_().m_5776_()) {
            MenuOpener.open((MenuType)((MenuType)ModMenuTypes.ENTITY_TICKER_MENU.get()), (Player)player, (MenuLocator)MenuLocators.forPart((AEBasePart)this));
        }
        return true;
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 14.0);
    }

    public TickingRequest getTickingRequest(IGridNode iGridNode) {
        return new TickingRequest(1, 1, false, true);
    }

    public void upgradesChanged() {
        if (this.menu != null) {
            this.menu.m_38946_();
        }
    }

    public TickRateModulation tickingRequest(IGridNode iGridNode, int ticksSinceLastCall) {
        if (!this.getAccelerateEnabled()) {
            return TickRateModulation.IDLE;
        }
        BlockEntity target = this.getLevel().m_7702_(this.getBlockEntity().m_58899_().m_121945_(this.getSide()));
        if (target != null && this.isActive()) {
            this.ticker(target);
        }
        return TickRateModulation.IDLE;
    }

    private <T extends BlockEntity> void ticker(@NotNull T blockEntity) {
        if (this.getGridNode() == null || this.getMainNode() == null || this.getMainNode().getGrid() == null) {
            return;
        }
        BlockPos pos = blockEntity.m_58899_();
        if (blockEntity.m_58904_() == null) {
            return;
        }
        String blockId = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)blockEntity.m_58900_().m_60734_())).toString();
        List<Pattern> compiledBlacklist = ConfigParsingUtils.getCachedBlacklist(List.of(ModConfig.INSTANCE.entityTickerBlackList));
        for (Pattern p : compiledBlacklist) {
            if (!p.matcher(blockId).matches()) continue;
            return;
        }
        BlockEntityTicker blockEntityTicker = this.getLevel().m_8055_(pos).m_155944_(this.getLevel(), blockEntity.m_58903_());
        if (blockEntityTicker == null) {
            return;
        }
        int energyCardCount = this.getUpgrades().getInstalledUpgrades((ItemLike)AEItems.ENERGY_CARD);
        int entitySpeedCardCount = this.getUpgrades().getInstalledUpgrades((ItemLike)ModItems.ENTITY_SPEED_CARD.get());
        long product = PowerUtils.computeProductWithCapFromStacks((Iterable<ItemStack>)this.getUpgrades(), 8);
        if (entitySpeedCardCount <= 0) {
            return;
        }
        double requiredPower = PowerUtils.computeFinalPowerForProduct(product, energyCardCount);
        int speed = (int)product;
        double multiplier = 1.0;
        for (ConfigParsingUtils.MultiplierEntry me : ConfigParsingUtils.getCachedMultiplierEntries(List.of(ModConfig.INSTANCE.entityTickerMultipliers))) {
            if (!me.pattern.matcher(blockId).matches()) continue;
            multiplier = Math.max(multiplier, me.multiplier);
        }
        requiredPower *= multiplier;
        double simulated = this.getMainNode().getGrid().getEnergyService().extractAEPower(requiredPower, Actionable.SIMULATE, PowerMultiplier.CONFIG);
        if (simulated < requiredPower) {
            return;
        }
        double extractedPower = this.getMainNode().getGrid().getEnergyService().extractAEPower(requiredPower, Actionable.MODULATE, PowerMultiplier.CONFIG);
        if (extractedPower < requiredPower) {
            return;
        }
        for (int i = 0; i < speed - 1; ++i) {
            blockEntityTicker.m_155252_(blockEntity.m_58904_(), blockEntity.m_58899_(), blockEntity.m_58900_(), blockEntity);
        }
    }

    public boolean m_8077_() {
        return super.m_8077_();
    }

    @NotNull
    public Component m_5446_() {
        return super.m_5446_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new EntitySpeedTickerMenu(containerId, playerInventory, this);
    }

    protected int getUpgradeSlots() {
        return 8;
    }
}

