/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.ae.screen;

import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.client.gui.Icon;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.CommonButtons;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.util.Platform;
import com.extendedae_plus.ae.menu.EntitySpeedTickerMenu;
import com.extendedae_plus.init.ModNetwork;
import com.extendedae_plus.network.ToggleEntityTickerC2SPacket;
import com.extendedae_plus.util.PowerUtils;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;

public class EntitySpeedTickerScreen<C extends EntitySpeedTickerMenu>
extends UpgradeableScreen<C> {
    private boolean eap$entitySpeedTickerEnabled = false;
    private SettingToggleButton<YesNo> eap$entitySpeedTickerToggle;

    public EntitySpeedTickerScreen(final EntitySpeedTickerMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((UpgradeableMenu)menu, playerInventory, title, style);
        this.addToLeftToolbar((Button)CommonButtons.togglePowerUnit());
        try {
            this.eap$entitySpeedTickerEnabled = menu.getAccelerateEnabled();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.eap$entitySpeedTickerToggle = new SettingToggleButton<YesNo>(this, Settings.BLOCKING_MODE, this.eap$entitySpeedTickerEnabled ? YesNo.YES : YesNo.NO, (btn, backwards) -> ModNetwork.CHANNEL.sendToServer((Object)new ToggleEntityTickerC2SPacket())){
            final /* synthetic */ EntitySpeedTickerScreen this$0;
            {
                this.this$0 = this$0;
                super(setting, (Enum)val, onPress);
            }

            public List<Component> getTooltipMessage() {
                try {
                    if (menu != null && menu.targetBlacklisted) {
                        MutableComponent title = Component.m_237113_((String)"\u5b9e\u4f53\u52a0\u901f");
                        MutableComponent stateLine = Component.m_237113_((String)"\u5df2\u7981\u7528\uff08\u76ee\u6807\u5728\u9ed1\u540d\u5355\uff09");
                        return List.of(title, stateLine);
                    }
                }
                catch (Exception title) {
                    // empty catch block
                }
                boolean enabled = this.this$0.eap$entitySpeedTickerEnabled;
                MutableComponent title = Component.m_237113_((String)"\u5b9e\u4f53\u52a0\u901f");
                MutableComponent stateLine = enabled ? Component.m_237113_((String)"\u5df2\u542f\u7528: \u5c06\u52a0\u901f\u76ee\u6807\u65b9\u5757\u5b9e\u4f53\u7684tick") : Component.m_237113_((String)"\u5df2\u5173\u95ed: \u4e0d\u4f1a\u5bf9\u76ee\u6807\u65b9\u5757\u5b9e\u4f53\u8fdb\u884c\u52a0\u901f");
                return List.of(title, stateLine);
            }

            protected Icon getIcon() {
                try {
                    if (menu != null && menu.targetBlacklisted) {
                        return Icon.INVALID;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.getCurrentValue() == YesNo.YES) {
                    return Icon.VALID;
                }
                return Icon.INVALID;
            }
        };
        this.eap$entitySpeedTickerToggle.set((Enum)(this.eap$entitySpeedTickerEnabled ? YesNo.YES : YesNo.NO));
        this.addToLeftToolbar((Button)this.eap$entitySpeedTickerToggle);
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        if (this.eap$entitySpeedTickerToggle != null) {
            boolean desired = this.eap$entitySpeedTickerEnabled;
            if (this.f_97732_ != null) {
                desired = ((EntitySpeedTickerMenu)this.f_97732_).getAccelerateEnabled();
            }
            this.eap$entitySpeedTickerEnabled = desired;
            if (this.f_97732_ != null && ((EntitySpeedTickerMenu)this.f_97732_).targetBlacklisted) {
                this.eap$entitySpeedTickerToggle.set((Enum)YesNo.NO);
                this.eap$entitySpeedTickerToggle.f_93623_ = false;
            } else {
                this.eap$entitySpeedTickerToggle.set((Enum)(desired ? YesNo.YES : YesNo.NO));
                this.eap$entitySpeedTickerToggle.f_93623_ = true;
            }
        }
        this.textData();
    }

    public void refreshGui() {
        this.textData();
    }

    private void textData() {
        if (((EntitySpeedTickerMenu)this.m_6262_()).targetBlacklisted) {
            this.setTextContent("enable", (Component)Component.m_237115_((String)"screen.extendedae_plus.entity_speed_ticker.enable"));
            this.setTextContent("speed", (Component)Component.m_237110_((String)"screen.extendedae_plus.entity_speed_ticker.speed", (Object[])new Object[]{0}));
            this.setTextContent("energy", (Component)Component.m_237110_((String)"screen.extendedae_plus.entity_speed_ticker.energy", (Object[])new Object[]{Platform.formatPower((double)0.0, (boolean)false)}));
            this.setTextContent("power_ratio", (Component)Component.m_237110_((String)"screen.extendedae_plus.entity_speed_ticker.power_ratio", (Object[])new Object[]{PowerUtils.formatPercentage(0.0)}));
            this.setTextContent("multiplier", (Component)Component.m_237110_((String)"screen.extendedae_plus.entity_speed_ticker.multiplier", (Object[])new Object[]{String.format("%.2fx", 0.0)}));
            return;
        }
        int energyCardCount = ((EntitySpeedTickerMenu)this.m_6262_()).energyCardCount;
        double multiplier = ((EntitySpeedTickerMenu)this.m_6262_()).multiplier;
        int effectiveSpeed = ((EntitySpeedTickerMenu)this.m_6262_()).effectiveSpeed;
        double finalPower = PowerUtils.computeFinalPowerForProduct(effectiveSpeed, energyCardCount);
        double remainingRatio = PowerUtils.getRemainingRatio(energyCardCount);
        this.setTextContent("speed", (Component)Component.m_237110_((String)"screen.extendedae_plus.entity_speed_ticker.speed", (Object[])new Object[]{effectiveSpeed}));
        this.setTextContent("energy", (Component)Component.m_237110_((String)"screen.extendedae_plus.entity_speed_ticker.energy", (Object[])new Object[]{Platform.formatPower((double)finalPower, (boolean)false)}));
        this.setTextContent("power_ratio", (Component)Component.m_237110_((String)"screen.extendedae_plus.entity_speed_ticker.power_ratio", (Object[])new Object[]{PowerUtils.formatPercentage(remainingRatio)}));
        this.setTextContent("multiplier", (Component)Component.m_237110_((String)"screen.extendedae_plus.entity_speed_ticker.multiplier", (Object[])new Object[]{String.format("%.2fx", multiplier)}));
    }
}

