/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.items.tools.powered.WirelessTerminalItem;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.crafting.CraftAmountMenu;
import com.extendedae_plus.menu.locator.CuriosItemLocator;
import com.extendedae_plus.util.WirelessTerminalLocator;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.NetworkEvent;

public class OpenCraftFromJeiC2SPacket {
    private final GenericStack stack;

    public OpenCraftFromJeiC2SPacket(GenericStack stack) {
        this.stack = stack;
    }

    public static void encode(OpenCraftFromJeiC2SPacket msg, FriendlyByteBuf buf) {
        GenericStack.writeBuffer((GenericStack)msg.stack, (FriendlyByteBuf)buf);
    }

    public static OpenCraftFromJeiC2SPacket decode(FriendlyByteBuf buf) {
        GenericStack gs = GenericStack.readBuffer((FriendlyByteBuf)buf);
        return new OpenCraftFromJeiC2SPacket(gs);
    }

    public static void handle(OpenCraftFromJeiC2SPacket msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null || msg.stack == null) {
                return;
            }
            AEKey what = msg.stack.what();
            WirelessTerminalLocator.LocatedTerminal located = WirelessTerminalLocator.find((Player)player);
            if (located.isEmpty()) {
                return;
            }
            String curiosSlotId = located.getCuriosSlotId();
            int curiosIndex = located.getCuriosIndex();
            if (curiosSlotId != null && curiosIndex >= 0) {
                int initial = 1;
                CraftAmountMenu.open((ServerPlayer)player, (MenuLocator)new CuriosItemLocator(curiosSlotId, curiosIndex), (AEKey)what, (int)initial);
                return;
            }
            Item patt0$temp = located.stack.m_41720_();
            if (!(patt0$temp instanceof WirelessTerminalItem)) {
                return;
            }
            WirelessTerminalItem wt = (WirelessTerminalItem)patt0$temp;
            IGrid grid = wt.getLinkedGrid(located.stack, player.m_9236_(), (Player)player);
            if (grid == null) {
                return;
            }
            if (!wt.hasPower((Player)player, 0.5, located.stack)) {
                return;
            }
            ICraftingService craftingService = grid.getCraftingService();
            if (!craftingService.isCraftable(what)) {
                return;
            }
            InteractionHand hand = located.getHand();
            int slot = located.getSlotIndex();
            if (hand != null) {
                int initial = 1;
                CraftAmountMenu.open((ServerPlayer)player, (MenuLocator)MenuLocators.forHand((Player)player, (InteractionHand)hand), (AEKey)what, (int)initial);
            } else if (slot >= 0) {
                int initial = 1;
                CraftAmountMenu.open((ServerPlayer)player, (MenuLocator)MenuLocators.forInventorySlot((int)slot), (AEKey)what, (int)initial);
            }
        });
        context.setPacketHandled(true);
    }
}

