/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import com.extendedae_plus.client.ui.ProviderSelectScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class ProvidersListS2CPacket {
    private final List<Long> ids;
    private final List<String> names;
    private final List<Integer> emptySlots;

    public ProvidersListS2CPacket(List<Long> ids, List<String> names, List<Integer> emptySlots) {
        this.ids = ids;
        this.names = names;
        this.emptySlots = emptySlots;
    }

    public static void encode(ProvidersListS2CPacket msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.ids.size());
        for (int i = 0; i < msg.ids.size(); ++i) {
            buf.writeLong(msg.ids.get(i).longValue());
            buf.m_130070_(msg.names.get(i));
            buf.m_130130_(msg.emptySlots.get(i).intValue());
        }
    }

    public static ProvidersListS2CPacket decode(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        ArrayList<Long> ids = new ArrayList<Long>(size);
        ArrayList<String> names = new ArrayList<String>(size);
        ArrayList<Integer> slots = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            ids.add(buf.readLong());
            names.add(buf.m_130277_());
            slots.add(buf.m_130242_());
        }
        return new ProvidersListS2CPacket(ids, names, slots);
    }

    public static void handle(ProvidersListS2CPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> ProvidersListS2CPacket.handleClient(msg));
        ctx.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(ProvidersListS2CPacket msg) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null) {
            return;
        }
        Screen current = mc.f_91080_;
        mc.m_91152_((Screen)new ProviderSelectScreen(current, msg.ids, msg.names, msg.emptySlots));
    }
}

