/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.items.tools.powered.WirelessCraftingTerminalItem;
import appeng.items.tools.powered.WirelessTerminalItem;
import appeng.me.helpers.PlayerSource;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.crafting.CraftAmountMenu;
import com.extendedae_plus.menu.locator.CuriosItemLocator;
import com.extendedae_plus.util.WirelessTerminalLocator;
import de.mari_023.ae2wtlib.terminal.WTMenuHost;
import de.mari_023.ae2wtlib.wut.WTDefinition;
import de.mari_023.ae2wtlib.wut.WUTHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class PullFromJeiOrCraftC2SPacket {
    private final GenericStack stack;

    public PullFromJeiOrCraftC2SPacket(GenericStack stack) {
        this.stack = stack;
    }

    public static void encode(PullFromJeiOrCraftC2SPacket msg, FriendlyByteBuf buf) {
        GenericStack.writeBuffer((GenericStack)msg.stack, (FriendlyByteBuf)buf);
    }

    public static PullFromJeiOrCraftC2SPacket decode(FriendlyByteBuf buf) {
        GenericStack gs = GenericStack.readBuffer((FriendlyByteBuf)buf);
        return new PullFromJeiOrCraftC2SPacket(gs);
    }

    public static void handle(PullFromJeiOrCraftC2SPacket msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            MEStorage storage;
            IGrid grid;
            ServerPlayer player = context.getSender();
            if (player == null || msg.stack == null) {
                return;
            }
            AEKey what = msg.stack.what();
            if (!(what instanceof AEItemKey)) {
                return;
            }
            AEItemKey itemKey = (AEItemKey)what;
            WirelessTerminalLocator.LocatedTerminal located = WirelessTerminalLocator.find((Player)player);
            ItemStack terminal = located.stack;
            if (terminal.m_41619_()) {
                return;
            }
            boolean usedWtHost = false;
            String curiosSlotId = located.getCuriosSlotId();
            int curiosIndex = located.getCuriosIndex();
            WTMenuHost wtHost = null;
            if (curiosSlotId != null && curiosIndex >= 0) {
                String current = WUTHandler.getCurrentTerminal((ItemStack)terminal);
                WTDefinition def = (WTDefinition)WUTHandler.wirelessTerminals.get(current);
                if (def == null) {
                    return;
                }
                wtHost = def.wTMenuHostFactory().create((Player)player, null, terminal, (p, sub) -> {});
                if (wtHost == null) {
                    return;
                }
                IGridNode node = wtHost.getActionableNode();
                if (node == null) {
                    return;
                }
                grid = node.getGrid();
                if (grid == null) {
                    return;
                }
                if (!wtHost.drainPower()) {
                    return;
                }
                usedWtHost = true;
            } else {
                WirelessCraftingTerminalItem wt;
                WirelessCraftingTerminalItem c;
                WirelessCraftingTerminalItem wct;
                ServerLevel level = player.m_284548_();
                Item patt0$temp = terminal.m_41720_();
                WirelessCraftingTerminalItem wirelessCraftingTerminalItem = wct = patt0$temp instanceof WirelessCraftingTerminalItem ? (c = (WirelessCraftingTerminalItem)patt0$temp) : null;
                if (wct != null) {
                    v1 = wct;
                } else {
                    Item patt0$temp2 = terminal.m_41720_();
                    if (patt0$temp2 instanceof WirelessTerminalItem) {
                        WirelessTerminalItem t = (WirelessTerminalItem)patt0$temp2;
                        v1 = t;
                    } else {
                        v1 = wt = null;
                    }
                }
                if (wt == null) {
                    return;
                }
                grid = wt.getLinkedGrid(terminal, (Level)level, (Player)player);
                if (grid == null) {
                    return;
                }
                if (!wt.hasPower((Player)player, 0.5, terminal)) {
                    return;
                }
            }
            Inventory inv = player.m_150109_();
            int free = inv.m_36062_();
            if (free == -1) {
                return;
            }
            int targetMax = itemKey.toStack(1).m_41741_();
            IEnergyService energy = grid.getEnergyService();
            long extracted = StorageHelper.poweredExtraction((IEnergySource)energy, (MEStorage)(storage = grid.getStorageService().getInventory()), (AEKey)itemKey, (long)targetMax, (IActionSource)new PlayerSource((Player)player));
            if (extracted > 0L) {
                inv.m_6836_(free, itemKey.toStack((int)extracted));
                if (!usedWtHost) {
                    WirelessCraftingTerminalItem wt2;
                    WirelessCraftingTerminalItem c2;
                    WirelessCraftingTerminalItem wct2;
                    Item patt0$temp = terminal.m_41720_();
                    WirelessCraftingTerminalItem wirelessCraftingTerminalItem = wct2 = patt0$temp instanceof WirelessCraftingTerminalItem ? (c2 = (WirelessCraftingTerminalItem)patt0$temp) : null;
                    if (wct2 != null) {
                        v3 = wct2;
                    } else {
                        Item patt0$temp3 = terminal.m_41720_();
                        if (patt0$temp3 instanceof WirelessTerminalItem) {
                            WirelessTerminalItem t2 = (WirelessTerminalItem)patt0$temp3;
                            v3 = t2;
                        } else {
                            v3 = wt2 = null;
                        }
                    }
                    if (wt2 != null) {
                        wt2.usePower((Player)player, Math.max(0.5, (double)extracted * 0.05), terminal);
                    }
                }
                located.commit();
                player.f_36096_.m_38946_();
                return;
            }
            ICraftingService craftingService = grid.getCraftingService();
            if (!craftingService.isCraftable(what)) {
                return;
            }
            if (curiosSlotId != null && curiosIndex >= 0) {
                CraftAmountMenu.open((ServerPlayer)player, (MenuLocator)new CuriosItemLocator(curiosSlotId, curiosIndex), (AEKey)what, (int)1);
            } else {
                InteractionHand hand = located.getHand();
                int slot = located.getSlotIndex();
                if (hand != null) {
                    CraftAmountMenu.open((ServerPlayer)player, (MenuLocator)MenuLocators.forHand((Player)player, (InteractionHand)hand), (AEKey)what, (int)1);
                } else if (slot >= 0) {
                    CraftAmountMenu.open((ServerPlayer)player, (MenuLocator)MenuLocators.forInventorySlot((int)slot), (AEKey)what, (int)1);
                }
            }
        });
        context.setPacketHandled(true);
    }
}

