/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util.storage;

import com.extendedae_plus.util.storage.InfinityDataStorage;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class InfinityStorageManager
extends SavedData {
    public static final String FILE_NAME = "eap_infinity_biginteger_cells";
    public static InfinityStorageManager INSTANCE = null;
    private final Map<UUID, InfinityDataStorage> cells = new HashMap<UUID, InfinityDataStorage>();

    public InfinityStorageManager() {
        this.m_77762_();
    }

    public InfinityStorageManager(CompoundTag nbt) {
        ListTag cellList = nbt.m_128437_("list", 10);
        for (int i = 0; i < cellList.size(); ++i) {
            CompoundTag cell = cellList.m_128728_(i);
            this.cells.put(cell.m_128342_("uuid"), InfinityDataStorage.loadFromNBT(cell.m_128469_("data")));
        }
        this.m_77762_();
    }

    public static InfinityStorageManager getForLevel(ServerLevel level) {
        if (INSTANCE == null && level != null) {
            INSTANCE = (InfinityStorageManager)level.m_8895_().m_164861_(InfinityStorageManager::new, InfinityStorageManager::new, FILE_NAME);
        }
        return INSTANCE;
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag nbt) {
        ListTag cellList = new ListTag();
        for (Map.Entry<UUID, InfinityDataStorage> entry : this.cells.entrySet()) {
            CompoundTag cell = new CompoundTag();
            cell.m_128362_("uuid", entry.getKey());
            cell.m_128365_("data", (Tag)entry.getValue().serializeNBT());
            cellList.add((Object)cell);
        }
        nbt.m_128365_("list", (Tag)cellList);
        return nbt;
    }

    public void updateCell(UUID uuid, InfinityDataStorage infinityDataStorage) {
        this.cells.put(uuid, infinityDataStorage);
        this.m_77762_();
    }

    public InfinityDataStorage getOrCreateCell(UUID uuid) {
        if (!this.cells.containsKey(uuid)) {
            this.updateCell(uuid, new InfinityDataStorage());
        }
        return this.cells.get(uuid);
    }

    public void modifyCell(UUID cellID, ListTag stackKeys, ListTag stackAmounts) {
        InfinityDataStorage cellToModify = this.getOrCreateCell(cellID);
        if (stackKeys != null && stackAmounts != null) {
            cellToModify.keys = stackKeys;
            cellToModify.amounts = stackAmounts;
        }
        this.updateCell(cellID, cellToModify);
    }

    public void removeCell(UUID uuid) {
        this.cells.remove(uuid);
        this.m_77762_();
    }
}

