/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.ae.api.crafting;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.crafting.pattern.AEProcessingPattern;
import java.util.Objects;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class ScaledProcessingPattern
implements IPatternDetails {
    private final AEProcessingPattern original;
    private final AEItemKey definition;
    private final long multiplier;
    private volatile transient IPatternDetails.IInput[] inputsCache;
    private volatile transient GenericStack[] outputsCache;
    private volatile transient GenericStack[] sparseInputsCache;
    private volatile transient GenericStack[] sparseOutputsCache;

    public ScaledProcessingPattern(AEProcessingPattern original, AEItemKey definition, long multiplier) {
        this.original = Objects.requireNonNull(original);
        this.definition = Objects.requireNonNull(definition);
        this.multiplier = multiplier <= 0L ? 1L : multiplier;
    }

    public AEProcessingPattern getOriginal() {
        return this.original;
    }

    public AEItemKey getDefinition() {
        return this.definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPatternDetails.IInput[] getInputs() {
        IPatternDetails.IInput[] cached = this.inputsCache;
        if (cached == null) {
            ScaledProcessingPattern scaledProcessingPattern = this;
            synchronized (scaledProcessingPattern) {
                cached = this.inputsCache;
                if (cached == null) {
                    IPatternDetails.IInput[] base = this.original.getInputs();
                    IPatternDetails.IInput[] arr = new IPatternDetails.IInput[base.length];
                    for (int i = 0; i < base.length; ++i) {
                        IPatternDetails.IInput in = base[i];
                        arr[i] = new Input(in.getPossibleInputs(), in.getMultiplier() * this.multiplier);
                    }
                    this.inputsCache = arr;
                    cached = arr;
                }
            }
        }
        return cached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericStack[] getOutputs() {
        GenericStack[] cached = this.outputsCache;
        if (cached == null) {
            ScaledProcessingPattern scaledProcessingPattern = this;
            synchronized (scaledProcessingPattern) {
                cached = this.outputsCache;
                if (cached == null) {
                    GenericStack[] baseOutputs = this.original.getOutputs();
                    GenericStack[] arr = new GenericStack[baseOutputs.length];
                    for (int i = 0; i < baseOutputs.length; ++i) {
                        GenericStack o = baseOutputs[i];
                        if (o == null) continue;
                        arr[i] = new GenericStack(o.what(), o.amount() * this.multiplier);
                    }
                    this.outputsCache = arr;
                    cached = arr;
                }
            }
        }
        return cached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericStack[] getSparseInputs() {
        GenericStack[] cached = this.sparseInputsCache;
        if (cached == null) {
            ScaledProcessingPattern scaledProcessingPattern = this;
            synchronized (scaledProcessingPattern) {
                cached = this.sparseInputsCache;
                if (cached == null) {
                    GenericStack[] base = this.original.getSparseInputs();
                    GenericStack[] arr = new GenericStack[base.length];
                    for (int i = 0; i < base.length; ++i) {
                        GenericStack v = base[i];
                        if (v == null) continue;
                        arr[i] = new GenericStack(v.what(), v.amount() * this.multiplier);
                    }
                    this.sparseInputsCache = arr;
                    cached = arr;
                }
            }
        }
        return cached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericStack[] getSparseOutputs() {
        GenericStack[] cached = this.sparseOutputsCache;
        if (cached == null) {
            ScaledProcessingPattern scaledProcessingPattern = this;
            synchronized (scaledProcessingPattern) {
                cached = this.sparseOutputsCache;
                if (cached == null) {
                    GenericStack[] base = this.original.getSparseOutputs();
                    GenericStack[] arr = new GenericStack[base.length];
                    for (int i = 0; i < base.length; ++i) {
                        GenericStack v = base[i];
                        if (v == null) continue;
                        arr[i] = new GenericStack(v.what(), v.amount() * this.multiplier);
                    }
                    this.sparseOutputsCache = arr;
                    cached = arr;
                }
            }
        }
        return cached;
    }

    public GenericStack getPrimaryOutput() {
        GenericStack[] outs = this.getOutputs();
        if (outs.length > 0 && outs[0] != null) {
            return outs[0];
        }
        return this.original.getPrimaryOutput();
    }

    public boolean supportsPushInputsToExternalInventory() {
        return this.original.supportsPushInputsToExternalInventory();
    }

    public void pushInputsToExternalInventory(KeyCounter[] inputHolder, IPatternDetails.PatternInputSink inputSink) {
        IPatternDetails.IInput[] ins;
        GenericStack[] sInputs = this.getSparseInputs();
        if (sInputs.length == (ins = this.getInputs()).length) {
            super.pushInputsToExternalInventory(inputHolder, inputSink);
            return;
        }
        KeyCounter allInputs = new KeyCounter();
        for (KeyCounter keyCounter : inputHolder) {
            allInputs.addAll(keyCounter);
        }
        for (KeyCounter keyCounter : sInputs) {
            if (keyCounter == null) continue;
            AEKey key = keyCounter.what();
            long amount = keyCounter.amount();
            long available = allInputs.get(key);
            if (available < amount) {
                throw new RuntimeException("Expected at least %d of %s when pushing scaled pattern, but only %d available".formatted(amount, key, available));
            }
            inputSink.pushInput(key, amount);
            allInputs.remove(key, amount);
        }
    }

    public static final class Input
    implements IPatternDetails.IInput {
        private final GenericStack[] template;
        private final long multiplier;

        public Input(GenericStack[] template, long multiplier) {
            this.template = template;
            this.multiplier = multiplier;
        }

        public GenericStack[] getPossibleInputs() {
            return this.template;
        }

        public long getMultiplier() {
            return this.multiplier;
        }

        public boolean isValid(AEKey input, Level level) {
            return input.matches(this.template[0]);
        }

        @Nullable
        public AEKey getRemainingKey(AEKey template) {
            return null;
        }
    }
}

