/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.ae.definitions.upgrades;

import appeng.items.materials.UpgradeCardItem;
import com.extendedae_plus.init.ModItems;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class EntitySpeedCardItem
extends UpgradeCardItem {
    public static final String NBT_MULTIPLIER = "EAS:mult";

    public EntitySpeedCardItem(Item.Properties props) {
        super(props);
    }

    public static ItemStack withMultiplier(int multiplier) {
        ItemStack s = new ItemStack((ItemLike)ModItems.ENTITY_SPEED_CARD.get());
        CompoundTag t = s.m_41784_();
        t.m_128405_(NBT_MULTIPLIER, multiplier);
        s.m_41751_(t);
        return s;
    }

    public static int readMultiplier(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return 1;
        }
        CompoundTag t = stack.m_41783_();
        if (t == null) {
            return 1;
        }
        int v = t.m_128451_(NBT_MULTIPLIER);
        return v <= 0 ? 1 : v;
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        int mult = EntitySpeedCardItem.readMultiplier(stack);
        return Component.m_237115_((String)(switch (mult) {
            case 2 -> "item.extendedae_plus.entity_speed_card.x2";
            case 4 -> "item.extendedae_plus.entity_speed_card.x4";
            case 8 -> "item.extendedae_plus.entity_speed_card.x8";
            case 16 -> "item.extendedae_plus.entity_speed_card.x16";
            default -> "item.extendedae_plus.entity_speed_card.x1";
        }));
    }

    public List<Component> getTooltipLines(ItemStack stack) {
        int mult = EntitySpeedCardItem.readMultiplier(stack);
        long cap = 1L;
        switch (mult) {
            case 16: {
                cap = 1024L;
                break;
            }
            case 8: {
                cap = 256L;
                break;
            }
            case 4: {
                cap = 64L;
                break;
            }
            case 2: {
                cap = 8L;
            }
        }
        MutableComponent line1 = Component.m_237110_((String)"tooltip.extendedae_plus.entity_speed_card.multiplier", (Object[])new Object[]{"x" + mult});
        MutableComponent line2 = Component.m_237110_((String)"tooltip.extendedae_plus.entity_speed_card.max", (Object[])new Object[]{cap});
        return List.of(line1, line2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> lines, TooltipFlag flag) {
        super.m_7373_(stack, level, lines, flag);
        lines.addAll(this.getTooltipLines(stack));
    }
}

