/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.ae.wireless;

import com.extendedae_plus.ae.wireless.IWirelessEndpoint;
import com.extendedae_plus.config.ModConfig;
import com.extendedae_plus.util.WirelessTeamUtil;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class WirelessMasterRegistry {
    private static final Map<Key, WeakReference<IWirelessEndpoint>> MASTERS = new HashMap<Key, WeakReference<IWirelessEndpoint>>();
    public static final UUID PUBLIC_NETWORK_UUID = new UUID(0L, 0L);

    private WirelessMasterRegistry() {
    }

    public static synchronized boolean register(ServerLevel level, long frequency, @Nullable UUID placerId, IWirelessEndpoint endpoint) {
        IWirelessEndpoint existingVal;
        Objects.requireNonNull(level, "level");
        Objects.requireNonNull(endpoint, "endpoint");
        if (frequency == 0L) {
            return false;
        }
        UUID ownerUUID = placerId != null ? WirelessTeamUtil.getNetworkOwnerUUID(level, placerId) : PUBLIC_NETWORK_UUID;
        Key key = new Key((ResourceKey<Level>)(WirelessMasterRegistry.useGlobal() ? null : level.m_46472_()), frequency, ownerUUID);
        WirelessMasterRegistry.cleanupIfCleared(key);
        WeakReference<IWirelessEndpoint> existing = MASTERS.get(key);
        IWirelessEndpoint iWirelessEndpoint = existingVal = existing == null ? null : (IWirelessEndpoint)existing.get();
        if (existingVal != null && !existingVal.isEndpointRemoved()) {
            return false;
        }
        MASTERS.put(key, new WeakReference<IWirelessEndpoint>(endpoint));
        return true;
    }

    public static synchronized void unregister(ServerLevel level, long frequency, @Nullable UUID placerId, IWirelessEndpoint endpoint) {
        IWirelessEndpoint cur;
        if (frequency == 0L || level == null) {
            return;
        }
        UUID ownerUUID = placerId != null ? WirelessTeamUtil.getNetworkOwnerUUID(level, placerId) : PUBLIC_NETWORK_UUID;
        Key key = new Key((ResourceKey<Level>)(WirelessMasterRegistry.useGlobal() ? null : level.m_46472_()), frequency, ownerUUID);
        WeakReference<IWirelessEndpoint> ref = MASTERS.get(key);
        if (ref != null && ((cur = (IWirelessEndpoint)ref.get()) == null || cur == endpoint)) {
            MASTERS.remove(key);
        }
    }

    public static synchronized IWirelessEndpoint get(ServerLevel level, long frequency, @Nullable UUID placerId) {
        if (frequency == 0L || level == null) {
            return null;
        }
        UUID ownerUUID = placerId != null ? WirelessTeamUtil.getNetworkOwnerUUID(level, placerId) : PUBLIC_NETWORK_UUID;
        Key key = new Key((ResourceKey<Level>)(WirelessMasterRegistry.useGlobal() ? null : level.m_46472_()), frequency, ownerUUID);
        WirelessMasterRegistry.cleanupIfCleared(key);
        WeakReference<IWirelessEndpoint> ref = MASTERS.get(key);
        return ref == null ? null : (IWirelessEndpoint)ref.get();
    }

    private static void cleanupIfCleared(Key key) {
        WeakReference<IWirelessEndpoint> ref = MASTERS.get(key);
        if (ref != null && ref.get() == null) {
            MASTERS.remove(key);
        }
    }

    private static boolean useGlobal() {
        return ModConfig.INSTANCE.wirelessCrossDimEnable;
    }

    private record Key(@Nullable ResourceKey<Level> dim, long freq, UUID owner) {
        @Override
        public String toString() {
            return (this.dim == null ? "*" : this.dim.m_135782_().toString()) + "#" + this.freq + "@" + String.valueOf(this.owner);
        }
    }
}

