/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.ae.wireless;

import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.me.service.helpers.ConnectionWrapper;
import com.extendedae_plus.ae.wireless.IWirelessEndpoint;
import com.extendedae_plus.ae.wireless.WirelessMasterRegistry;
import com.extendedae_plus.config.ModConfig;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.Nullable;

public class WirelessSlaveLink {
    private final IWirelessEndpoint host;
    private long frequency;
    @Nullable
    private UUID placerId;
    private ConnectionWrapper connection = new ConnectionWrapper(null);
    private boolean shutdown = true;
    private double distance;

    public WirelessSlaveLink(IWirelessEndpoint host) {
        this.host = Objects.requireNonNull(host);
    }

    public void setPlacerId(@Nullable UUID placerId) {
        this.placerId = placerId;
    }

    public void setFrequency(long frequency) {
        if (this.frequency != frequency) {
            this.frequency = frequency;
            this.updateStatus();
        }
    }

    public long getFrequency() {
        return this.frequency;
    }

    public boolean isConnected() {
        return !this.shutdown && this.connection.getConnection() != null;
    }

    public double getDistance() {
        return this.distance;
    }

    public void updateStatus() {
        if (this.host.isEndpointRemoved()) {
            this.destroyConnection();
            return;
        }
        ServerLevel level = this.host.getServerLevel();
        if (level == null || this.frequency == 0L) {
            this.destroyConnection();
            return;
        }
        IWirelessEndpoint master = WirelessMasterRegistry.get(level, this.frequency, this.placerId);
        this.shutdown = false;
        this.distance = 0.0;
        boolean crossDim = ModConfig.INSTANCE.wirelessCrossDimEnable;
        if (master != null && !master.isEndpointRemoved() && (crossDim || master.getServerLevel() == level)) {
            if (!crossDim) {
                this.distance = Math.sqrt(master.m_58899_().m_123331_((Vec3i)this.host.m_58899_()));
            }
            double maxRange = ModConfig.INSTANCE.wirelessMaxRange;
            if (crossDim || this.distance <= maxRange) {
                try {
                    IGridConnection current = this.connection.getConnection();
                    IGridNode a = this.host.getGridNode();
                    IGridNode b = master.getGridNode();
                    if (a != null && b != null) {
                        if (current != null) {
                            IGridNode ca = current.a();
                            IGridNode cb = current.b();
                            if (!(ca != a && cb != a || ca != b && cb != b)) {
                                return;
                            }
                            current.destroy();
                            this.connection = new ConnectionWrapper(null);
                        }
                        this.connection = new ConnectionWrapper(GridHelper.createConnection((IGridNode)a, (IGridNode)b));
                        return;
                    }
                    this.shutdown = true;
                }
                catch (IllegalStateException illegalStateException) {}
            } else {
                this.shutdown = true;
            }
        } else {
            this.shutdown = true;
        }
        this.destroyConnection();
    }

    public void onUnloadOrRemove() {
        this.destroyConnection();
    }

    private void destroyConnection() {
        IGridConnection current = this.connection.getConnection();
        if (current != null) {
            current.destroy();
            this.connection.setConnection(null);
        }
        this.connection = new ConnectionWrapper(null);
    }
}

